<x-filament-panels::page>
    <div class="flex flex-col lg:flex-row gap-4">
        {{-- Left side - Form (fixed width) --}}
        <div class="w-full lg:w-[400px] shrink-0">
            <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h2 class="text-lg font-medium">{{ $jobSkill ? 'Edit' : 'Create' }}</h2>
                        @if($jobSkill)
                            <button 
                                wire:click="cancelEdit"
                                class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200"
                            >
                                <x-heroicon-m-x-mark class="w-5 h-5" />
                            </button>
                        @endif
                    </div>
                    
                    <x-filament-panels::form wire:submit="save">
                        {{ $this->form }}

                        <x-filament-panels::form.actions 
                            :actions="[
                                \Filament\Actions\Action::make('save')
                                    ->label($jobSkill ? 'Update' : 'Create')
                                    ->submit('save')
                            ]" 
                        />
                    </x-filament-panels::form>
                </div>
            </div>
        </div>

        {{-- Right side - Table --}}
        <div class="w-full min-w-0">
            <div class="bg-white dark:bg-gray-800 shadow-sm rounded-xl">
                {{ $this->table }}
            </div>
        </div>
    </div>
</x-filament-panels::page> 