<x-filament-panels::page>
    <div class="flex flex-col gap-4 lg:flex-row">
        {{-- Left side - Form (fixed width) --}}
        <div class="w-full lg:w-[400px] shrink-0">
            <div class="bg-white shadow-sm dark:bg-gray-800 rounded-xl">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <h2 class="text-lg font-medium">{{ $this->leadFormField ? 'Edit Form Field' : 'Create Form Field' }}</h2>
                        @if ($this->leadFormField)
                            <button wire:click="cancelEdit" class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200">
                                <x-heroicon-m-x-mark class="w-5 h-5" />
                            </button>
                        @endif
                    </div>

                    <x-filament-panels::form wire:submit="save">
                        {{ $this->form }}

                        <x-filament-panels::form.actions :actions="[
                            \Filament\Actions\Action::make('save')
                                ->label($this->leadFormField ? 'Update Form Field' : 'Create Form Field')
                                ->submit('save'),
                        ]" />
                    </x-filament-panels::form>
                </div>
            </div>
        </div>

        {{-- Right side - Table --}}
        <div class="w-full min-w-0">
            <div class="bg-white shadow-sm dark:bg-gray-800 rounded-xl">
                {{ $this->table }}
            </div>
        </div>
    </div>
</x-filament-panels::page>
