<x-filament-panels::page>
    <div class="space-y-6">
        <!-- Form Information Section -->
        <x-filament::section>
            <x-slot name="heading">
                {{ __('Form Information') }}
            </x-slot>

            <x-slot name="description">
                {{ __('Basic form details and configuration settings') }}
            </x-slot>

            <div class="space-y-4">
                <!-- Basic Details -->
                <div>
                    <h4 class="text-base font-bold text-gray-900 dark:text-white mb-3">{{ __('Basic Details') }}</h4>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Title') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $record->title }}
                            </dd>
                        </div>

                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Created By') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $record->author?->name ?? 'N/A' }}
                            </dd>
                        </div>

                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Created At') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $record->created_at->format('M d, Y h:i A') }}
                            </dd>
                        </div>
                    </div>

                    @if($record->description)
                        <div class="mt-4">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Description') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $record->description }}
                            </dd>
                        </div>
                    @endif
                </div>

                <!-- Form Settings -->
                <div>
                    <h4 class="text-base font-bold text-gray-900 dark:text-white mb-3">{{ __('Form Settings') }}</h4>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Match Criteria') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-sm font-semibold
                                    {{ $record->match_criteria->value === 'category' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' : 'bg-amber-100 text-amber-800 dark:bg-amber-900 dark:text-amber-200' }}">
                                    {{ $record->match_criteria->getLabel() }}
                                </span>
                            </dd>
                        </div>

                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Reception Mode') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-sm font-semibold
                                    {{ $record->reception_mode->value === 'auto' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' }}">
                                    {{ $record->reception_mode->getLabel() }}
                                </span>
                            </dd>
                        </div>

                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('CAPTCHA Enabled') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                @if($record->enable_captcha)
                                    <x-heroicon-o-check-circle class="w-5 h-5 text-green-600 dark:text-green-400 inline" />
                                    <span class="text-green-600 dark:text-green-400 font-medium">Yes</span>
                                @else
                                    <x-heroicon-o-x-circle class="w-5 h-5 text-red-600 dark:text-red-400 inline" />
                                    <span class="text-red-600 dark:text-red-400 font-medium">No</span>
                                @endif
                            </dd>
                        </div>

                        <div>
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Status') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                @if($record->is_active)
                                    <x-heroicon-o-check-circle class="w-5 h-5 text-green-600 dark:text-green-400 inline" />
                                    <span class="text-green-600 dark:text-green-400 font-medium">Active</span>
                                @else
                                    <x-heroicon-o-x-circle class="w-5 h-5 text-red-600 dark:text-red-400 inline" />
                                    <span class="text-red-600 dark:text-red-400 font-medium">Inactive</span>
                                @endif
                            </dd>
                        </div>
                    </div>

                    @if($record->submit_message)
                        <div class="mt-4">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 mb-1.5">
                                {{ __('Submit Message') }}
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $record->submit_message }}
                            </dd>
                        </div>
                    @endif
                </div>

                <!-- Member Categories -->
                @if($record->memberCategories && $record->memberCategories->count() > 0)
                    <div>
                        <h4 class="text-base font-bold text-gray-900 dark:text-white mb-3">{{ __('Associated Member Categories') }}</h4>

                        <div class="flex flex-wrap gap-2">
                            @foreach($record->memberCategories as $category)
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800 dark:bg-green-800 dark:text-green-200">
                                    {{ $category->category_name }}
                                    @if($category->pivot->credits)
                                        <span class="ml-1 text-xs">({{ $category->pivot->credits }} credits)</span>
                                    @endif
                                    @if($category->pivot->radius)
                                        <span class="ml-1 text-xs">({{ $category->pivot->radius }} mi radius)</span>
                                    @endif
                                </span>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </x-filament::section>

        <!-- Statistics Section -->
        <x-filament::section>
            <x-slot name="heading">
                {{ __('Statistics') }}
            </x-slot>

            <x-slot name="description">
                {{ __('Form performance and engagement metrics') }}
            </x-slot>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                <!-- Total Visits -->
                <div class="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-4 border border-blue-200 dark:border-blue-800">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-blue-600 dark:text-blue-400">{{ __('Total Visits') }}</p>
                            <p class="text-2xl font-bold text-blue-900 dark:text-blue-100 mt-1">
                                {{ number_format($record->visits_count ?? 0) }}
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <x-heroicon-o-eye class="w-8 h-8 text-blue-500 dark:text-blue-400" />
                        </div>
                    </div>
                    <p class="text-xs text-blue-600 dark:text-blue-400 mt-2">
                        {{ __('Unique form views') }}
                    </p>
                </div>

                <!-- Total Leads -->
                <div class="bg-green-50 dark:bg-green-900/20 rounded-lg p-4 border border-green-200 dark:border-green-800">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-green-600 dark:text-green-400">{{ __('Total Leads') }}</p>
                            <p class="text-2xl font-bold text-green-900 dark:text-green-100 mt-1">
                                {{ number_format($record->leads_count ?? 0) }}
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <x-heroicon-o-user-group class="w-8 h-8 text-green-500 dark:text-green-400" />
                        </div>
                    </div>
                    <p class="text-xs text-green-600 dark:text-green-400 mt-2">
                        {{ __('Form submissions') }}
                    </p>
                </div>

                <!-- Conversion Rate -->
                <div class="bg-purple-50 dark:bg-purple-900/20 rounded-lg p-4 border border-purple-200 dark:border-purple-800">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-medium text-purple-600 dark:text-purple-400">{{ __('Conversion Rate') }}</p>
                            <p class="text-2xl font-bold text-purple-900 dark:text-purple-100 mt-1">
                                @php
                                    $visits = $record->visits_count ?? 0;
                                    $leads = $record->leads_count ?? 0;
                                    $conversionRate = $visits > 0 ? round(($leads / $visits) * 100, 2) : 0;
                                @endphp
                                {{ $conversionRate }}%
                            </p>
                        </div>
                        <div class="flex-shrink-0">
                            <x-heroicon-o-chart-bar class="w-8 h-8 text-purple-500 dark:text-purple-400" />
                        </div>
                    </div>
                    <p class="text-xs text-purple-600 dark:text-purple-400 mt-2">
                        {{ __('Visits to submissions') }}
                    </p>
                </div>
            </div>
        </x-filament::section>

        <!-- Form Fields Section -->
        <x-filament::section collapsible collapsed>
            <x-slot name="heading">
                {{ __('Form Fields') }} ({{ $record->formFields->count() }})
            </x-slot>

            <x-slot name="description">
                {{ __('Fields configured for this form') }}
            </x-slot>

            <div class="space-y-2">
                @if($record->formFields && $record->formFields->count() > 0)
                    <div class="space-y-2">
                        @foreach($record->formFields->sortBy('pivot.field_order') as $field)
                            <div class="flex items-center justify-between p-3 bg-gray-50 dark:bg-gray-800 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors">
                                <div class="flex items-center space-x-4 flex-1">
                                    <div class="flex-shrink-0 w-8 h-8 flex items-center justify-center bg-white dark:bg-gray-900 rounded-full text-sm font-bold text-gray-700 dark:text-gray-300">
                                        {{ $field->pivot->field_order ?? '-' }}
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                                            {{ $field->field_name }}
                                        </p>
                                        @if($field->pivot->field_placeholder)
                                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                                {{ $field->pivot->field_placeholder }}
                                            </p>
                                        @endif
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                            {{ $field->field_type->getLabel() }}
                                        </span>
                                        @if($field->pivot->is_required)
                                            <span class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                                Required
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8">
                        <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100 dark:bg-gray-800">
                            <x-heroicon-o-queue-list class="h-6 w-6 text-gray-400" />
                        </div>
                        <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('No fields configured') }}</h3>
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                            {{ __("This form doesn't have any fields configured yet.") }}
                        </p>
                    </div>
                @endif
            </div>
        </x-filament::section>

        <!-- Latest Leads Section -->
        <div class="space-y-4">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ __('Latest Leads') }}</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                        Showing latest {{ min($record->leads->count(), 10) }} of {{ $record->leads()->count() }} total leads
                    </p>
                </div>
            </div>

            <!-- Table Content -->
            <div>
                {{ $this->table }}
            </div>
        </div>

    </div>
</x-filament-panels::page>
