@php
    use Illuminate\Support\Str;
    $metaFields = $record->getMeta();
    
    // Load form fields with their configurations
    $formFields = $record->leadForm?->formFields->keyBy('field_id') ?? collect();
    
    // Helper function to check if array is associative (has parent-child structure)
    $isAssociative = function($arr) {
        if (!is_array($arr) || empty($arr)) {
            return false;
        }
        return array_keys($arr) !== range(0, count($arr) - 1);
    };
    
    // Helper function to format field name
    $formatFieldName = function($name) {
        return Str::title(str_replace('_', ' ', $name));
    };
    
    // Helper function to format field value
    $formatFieldValue = function($value) use ($formatFieldName) {
        if (is_null($value)) {
            return '<span class="text-gray-400">N/A</span>';
        }
        
        if (is_bool($value) || in_array($value, [0, 1, '0', '1'], true)) {
            return filter_var($value, FILTER_VALIDATE_BOOLEAN) ? 'Yes' : 'No';
        }
        
        if (is_array($value)) {
            return $formatFieldName(implode(', ', $value));
        }
        
        return $formatFieldName($value);
    };
@endphp
<x-filament-panels::page>
    <div class="space-y-6">
        <!-- Lead Information Section -->
        <x-filament::section>
            <x-slot name="heading">
                {{ __('Lead Data') }}
            </x-slot>

            <x-slot name="description">
                {{ __('Basic lead details and contact information') }}
            </x-slot>

            <div class="space-y-6">
                <!-- Contact Information -->
                <div>
                    <div>
                        <h4 class="mb-5 text-base font-bold text-gray-900 dark:text-white">{{ __('Contact Information') }}</h4>

                        <div class="grid grid-cols-1 gap-y-4 gap-x-8 sm:grid-cols-2">
                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('First Name') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    {{ $record->first_name ?? 'N/A' }}
                                </dd>
                            </div>

                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Last Name') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    {{ $record->last_name ?? 'N/A' }}
                                </dd>
                            </div>

                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Email') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    @if ($record->email)
                                        <a href="mailto:{{ $record->email }}" class="font-medium text-primary-600 hover:text-primary-800 dark:text-primary-400 dark:hover:text-primary-300">
                                            {{ $record->email }}
                                        </a>
                                    @else
                                        N/A
                                    @endif
                                </dd>
                            </div>

                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Phone') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    @if ($record->phone)
                                        <a href="tel:{{ $record->phone }}" class="font-medium text-primary-600 hover:text-primary-800 dark:text-primary-400 dark:hover:text-primary-300">
                                            {{ $record->phone }}
                                        </a>
                                    @else
                                        N/A
                                    @endif
                                </dd>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Lead Information -->
                <div>
                    <div>
                        <h4 class="mb-5 text-base font-bold text-gray-900 dark:text-white">{{ __('Lead Information') }}</h4>

                        <div class="grid grid-cols-1 gap-y-4 gap-x-8 sm:grid-cols-2">
                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Submitted Date') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    {{ $record->created_at->format('M d, Y h:i A') }}
                                </dd>
                            </div>

                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Message') }}:
                                </dt>
                                <dd class="text-base font-normal leading-relaxed text-gray-900 dark:text-gray-100">
                                    @if ($record->message)
                                        <div class="break-words">
                                            {{ $record->message }}
                                        </div>
                                    @else
                                        <span class="italic font-light text-gray-500 dark:text-gray-400">
                                            {{ __('No message provided') }}
                                        </span>
                                    @endif
                                </dd>
                            </div>

                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Lead Source') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    @if ($record->lead_source)
                                        <span class="inline-flex items-center px-2.5 py-0.5 text-sm font-semibold text-blue-800 bg-blue-100 rounded-full dark:bg-blue-900 dark:text-blue-200">
                                            {{ $record->lead_source }}
                                        </span>
                                    @else
                                        <span class="italic font-light text-gray-500 dark:text-gray-400">
                                            {{ __('Unknown source') }}
                                        </span>
                                    @endif
                                </dd>
                            </div>

                            @if (isset($record->lead_status))
                                <div class="contents">
                                    <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                        {{ __('Lead Status') }}:
                                    </dt>
                                    <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                        <span class="inline-flex items-center px-2.5 py-0.5 text-sm font-semibold text-green-800 bg-green-100 rounded-full dark:bg-green-900 dark:text-green-200">
                                            {{ $record->lead_status->getLabel() }}
                                        </span>
                                    </dd>
                                </div>
                            @endif
                            @if ($record->leadAddress()->exists())
                                <div class="contents">
                                    <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                        {{ __('Lead Address') }}:
                                    </dt>
                                    <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                        <span class="inline-flex items-center px-2.5 py-0.5 text-sm rounded-full">
                                            {{ $record->leadAddress->first()->address_line_1 }}
                                        </span>
                                    </dd>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </x-filament::section>

        <!-- Form Data Section -->
        <x-filament::section>
            <x-slot name="heading">
                {{ __('Form Data') }}
            </x-slot>

            <x-slot name="description">
                {{ __('Additional form fields and custom data') }}
            </x-slot>

            <div class="space-y-6">
                @if ($metaFields && count($metaFields) > 0)
                    <!-- Custom Lead Data -->
                    <div>
                        <div>
                            <h4 class="mb-5 text-base font-bold text-gray-900 dark:text-white">{{ __('Custom Lead Data') }}</h4>
                            
                            @foreach ($metaFields as $fieldKey => $fieldValue)
                                @php
                                    // Get field configuration from form fields
                                    $formField = $formFields->get($fieldKey);
                                    $fieldLabel = $formField?->pivot?->field_label ?? $formatFieldName($fieldKey);
                                    
                                    // Check if this field has parent-child structure (nested associative array)
                                    $hasChildren = is_array($fieldValue) && $isAssociative($fieldValue);
                                @endphp
                                
                                @if ($hasChildren)
                                    <!-- Parent field with children -->
                                    <div class="mb-6 pb-6 border-b border-gray-200 dark:border-gray-700 last:border-0">
                                        <!-- Parent Heading -->
                                        <h5 class="mb-4 text-sm font-bold text-primary-600 dark:text-primary-400">
                                            {{ $fieldLabel }}
                                        </h5>
                                        
                                        <!-- Loop through each parent item and its children -->
                                        @foreach ($fieldValue as $parentKey => $childFields)
                                            <div class="mb-4 pl-4 border-l-2 border-primary-300 dark:border-primary-700 last:mb-0">
                                                <!-- Parent value as subheading -->
                                                <h6 class="mb-3 text-sm font-semibold text-gray-700 dark:text-gray-300">
                                                    {{ $formatFieldName($parentKey) }}
                                                </h6>
                                                
                                                <!-- Child fields -->
                                                @if (is_array($childFields) && !empty($childFields))
                                                    <div class="grid grid-cols-1 gap-y-3 gap-x-8 sm:grid-cols-2">
                                                        @foreach ($childFields as $childKey => $childValue)
                                                            @php
                                                                // Try to get child field configuration
                                                                $childFormField = $formFields->get($childKey);
                                                                $childLabel = $childFormField?->pivot?->field_label ?? $formatFieldName($childKey);
                                                            @endphp
                                                            
                                                            <div class="contents">
                                                                <dt class="text-sm font-medium text-gray-600 dark:text-gray-400">
                                                                    {{ $childLabel }}:
                                                                </dt>
                                                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                                                    {!! $formatFieldValue($childValue) !!}
                                                                </dd>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                @else
                                                    <p class="text-sm text-gray-500 dark:text-gray-400 italic">
                                                        {{ __('No data provided') }}
                                                    </p>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <!-- Simple field (no children) -->
                                    <div class="grid grid-cols-1 gap-y-4 gap-x-8 mb-4 sm:grid-cols-2">
                                        <div class="contents">
                                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                                {{ $fieldLabel }}:
                                            </dt>
                                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                                {!! $formatFieldValue($fieldValue) !!}
                                            </dd>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @else
                    <div class="p-4 text-sm text-center text-gray-500 dark:text-gray-400">
                        {{ __('No additional form data available for this lead.') }}
                    </div>
                @endif
            </div>
        </x-filament::section>

        <!-- Attachments Section -->
        @if ($record->getMedia('attachments')->count() > 0)
            <x-filament::section>
                <x-slot name="heading">
                    {{ __('Attachments') }}
                </x-slot>

                <x-slot name="description">
                    {{ __('Files uploaded with this lead') }} ({{ $record->getMedia('attachments')->count() }} {{ $record->getMedia('attachments')->count() === 1 ? 'file' : 'files' }})
                </x-slot>

                <div class="grid grid-cols-2 gap-3 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6">
                    @foreach ($record->getMedia('attachments') as $media)
                        <div class="overflow-hidden relative rounded-lg border border-gray-200 transition-colors group dark:border-gray-700 hover:border-primary-500 dark:hover:border-primary-400">
                            <!-- Image Preview or File Icon -->
                            <div class="flex justify-center items-center h-32 bg-gray-100 dark:bg-gray-800">
                                @if (str_starts_with($media->mime_type, 'image/'))
                                    <img src="{{ $media->getUrl() }}"
                                         alt="{{ $media->file_name }}"
                                         class="object-cover w-full h-full">
                                @else
                                    <div class="flex flex-col justify-center items-center p-2">
                                        <svg class="w-10 h-10 text-red-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                        </svg>
                                        <span class="mt-1 text-[10px] text-gray-500 uppercase dark:text-gray-400">{{ pathinfo($media->file_name, PATHINFO_EXTENSION) }}</span>
                                    </div>
                                @endif
                            </div>

                            <!-- File Information -->
                            <div class="p-2 bg-white dark:bg-gray-900">
                                <p class="text-xs font-medium text-gray-900 truncate dark:text-gray-100" title="{{ $media->file_name }}">
                                    {{ $media->file_name }}
                                </p>
                                <p class="mt-0.5 text-[10px] text-gray-500 dark:text-gray-400">
                                    {{ number_format($media->size / 1024, 2) }} KB
                                </p>
                            </div>

                            <!-- Hover Actions -->
                            <div class="flex absolute inset-0 justify-center items-center bg-black bg-opacity-0 opacity-0 transition-opacity group-hover:bg-opacity-40 group-hover:opacity-100">
                                <div class="flex gap-1.5">
                                    <a href="{{ $media->getUrl() }}"
                                       target="_blank"
                                       class="inline-flex items-center px-2 py-1.5 text-xs text-gray-700 bg-white rounded-md transition-colors dark:bg-gray-800 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        <svg class="w-3.5 h-3.5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                        </svg>
                                    </a>
                                    <a href="{{ $media->getUrl() }}"
                                       download
                                       class="inline-flex items-center px-2 py-1.5 text-xs text-white rounded-md transition-colors bg-primary-600 hover:bg-primary-700">
                                        <svg class="w-3.5 h-3.5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </x-filament::section>
        @endif

        <!-- User Management Section -->
        {{-- <x-filament::section>
            <x-slot name="heading">
                {{ __('User Management') }}
            </x-slot>

            <x-slot name="description">
                {{ __('Manage users assigned to this lead and view available users based on member category matching') }}
            </x-slot>

            <div class="space-y-6">
                <!-- Tab Navigation -->
                <div class="flex p-1 space-x-1 bg-gray-100 rounded-lg dark:bg-gray-800">
                    <button wire:click="setActiveTab('assigned')" class="flex-1 px-4 py-2 text-sm font-medium rounded-md transition-colors duration-200 {{ $activeTab === 'assigned' ? 'bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 shadow-sm' : 'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' }}">
                        <div class="flex justify-center items-center space-x-2">
                            <x-heroicon-o-users class="w-4 h-4" />
                            <span>Assigned Users</span>
                            <span class="px-2 py-1 text-xs font-medium text-gray-700 bg-gray-200 rounded-full dark:bg-gray-600 dark:text-gray-300">
                                {{ $record->users->count() }}
                            </span>
                        </div>
                    </button>

                    <button wire:click="setActiveTab('available')" class="flex-1 px-4 py-2 text-sm font-medium rounded-md transition-colors duration-200 {{ $activeTab === 'available' ? 'bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 shadow-sm' : 'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' }}">
                        <div class="flex justify-center items-center space-x-2">
                            <x-heroicon-o-user-group class="w-4 h-4" />
                            <span>Available Users</span>
                            @if ($record->leadForm && $record->leadForm->memberCategories->count() > 0)
                                <span class="px-2 py-1 text-xs font-medium text-blue-700 bg-blue-100 rounded-full dark:bg-blue-800 dark:text-blue-300">
                                    {{ $this->getAvailableUsersCount() }}
                                </span>
                                <span class="px-2 py-1 text-xs font-medium text-green-700 bg-green-100 rounded-full dark:bg-green-800 dark:text-green-300">
                                    {{ $record->leadForm->memberCategories->count() }} {{ $record->leadForm->memberCategories->count() === 1 ? 'category' : 'categories' }}
                                </span>
                            @else
                                <span class="px-2 py-1 text-xs font-medium text-yellow-700 bg-yellow-100 rounded-full dark:bg-yellow-800 dark:text-yellow-300">
                                    No categories
                                </span>
                            @endif
                        </div>
                    </button>
                </div>

                <!-- Category Information for Available Users -->
                @if ($activeTab === 'available' && $record->leadForm && $record->leadForm->memberCategories->count() > 0)
                    <div class="p-4 bg-blue-50 rounded-lg border border-blue-200 dark:bg-blue-900/20 dark:border-blue-800">
                        <div class="flex items-start space-x-3">
                            <x-heroicon-o-information-circle class="flex-shrink-0 mt-0.5 w-5 h-5 text-blue-500 dark:text-blue-400" />
                            <div>
                                <h4 class="text-sm font-medium text-blue-900 dark:text-blue-100">
                                    {{ __('Matching Categories') }}
                                </h4>
                                <p class="mt-1 text-sm text-blue-700 dark:text-blue-200">
                                    {{ __('Showing users who belong to the following member categories associated with this lead form:') }}
                                </p>
                                <div class="flex flex-wrap gap-2 mt-2">
                                    @foreach ($record->leadForm->memberCategories as $category)
                                        <span class="inline-flex items-center px-2.5 py-0.5 text-xs font-medium text-blue-800 bg-blue-100 rounded-full dark:bg-blue-800 dark:text-blue-200">
                                            {{ $category->category_name }}
                                        </span>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($activeTab === 'available')
                    <div class="p-4 bg-amber-50 rounded-lg border border-amber-200 dark:bg-amber-900/20 dark:border-amber-800">
                        <div class="flex items-start space-x-3">
                            <x-heroicon-o-exclamation-triangle class="flex-shrink-0 mt-0.5 w-5 h-5 text-amber-500 dark:text-amber-400" />
                            <div>
                                <h4 class="text-sm font-medium text-amber-900 dark:text-amber-100">
                                    {{ __('No Categories Set') }}
                                </h4>
                                <p class="mt-1 text-sm text-amber-700 dark:text-amber-200">
                                    {{ __('This lead form does not have any member categories associated with it. Please configure the lead form to assign member categories for automatic user matching.') }}
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Table Content -->
                <div class="mt-6">
                    {{ $this->table }}
                </div>
            </div>
        </x-filament::section> --}}

    </div>
</x-filament-panels::page>
