@php
    @dump($this->record)
    // $user = $this->record;
    // $activeSubscription = $user->subscriptions()->where('is_active', true)->first();
@endphp

<x-filament::page>
    {{-- Status and Actions Bar --}}
    <x-admin.member.status-action-bar :member="$user" />

    {{-- Main Content Grid --}}
    <div class="grid grid-cols-12 gap-6">
        {{-- Profile Card --}}
        <x-admin.member.profile-card :user="$user" :activeSubscription="$activeSubscription" />

        {{-- Tabs and Content Section --}}
        <div class="col-span-12 lg:col-span-9">
            {{-- Navigation Tabs --}}
            <div class="mb-6">
                <div class="rounded-xl bg-white p-2 shadow-sm">
                    <nav class="flex items-center gap-1" aria-label="Tabs">
                        <div class="flex-1 flex items-center gap-1 overflow-x-auto">
                            @foreach($this->tabs as $label => $tab)
                                <button 
                                    wire:click="setActiveTab('{{ $label }}')"
                                    type="button" 
                                    @class([
                                        'group relative flex items-center gap-2.5 rounded-lg px-4 py-2.5 text-sm font-medium transition-all duration-200 whitespace-nowrap',
                                        'bg-primary-50/80 text-primary-600 ring-1 ring-primary-100/80' => $activeTab === $label,
                                        'hover:bg-gray-50 hover:text-gray-900' => $activeTab !== $label,
                                    ])
                                >
                                    <div @class([
                                        'flex items-center justify-center transition-transform duration-200 ease-out group-hover:scale-110',
                                        'text-primary-600' => $activeTab === $label,
                                        'text-gray-400 group-hover:text-gray-500' => $activeTab !== $label,
                                    ])>
                                        <x-dynamic-component :component="$tab['icon']" class="h-5 w-5" />
                                    </div>
                                    
                                    <span class="relative">
                                        {{ $label }}
                                        @if(isset($tab['badge']) && $tab['badge'] > 0)
                                            <span @class([
                                                'absolute -right-5 -top-2.5 flex h-4 min-w-[1rem] items-center justify-center rounded-full px-1 text-[10px] font-semibold leading-none',
                                                'bg-primary-100 text-primary-700' => $activeTab === $label,
                                                'bg-gray-100 text-gray-600' => $activeTab !== $label,
                                            ])>
                                                {{ number_format($tab['badge']) }}
                                            </span>
                                        @endif
                                        @if($activeTab === $label)
                                            <span class="absolute -bottom-1.5 left-0 h-0.5 w-full rounded-full bg-primary-600"></span>
                                        @endif
                                    </span>
                                </button>
                            @endforeach
                        </div>

                        {{-- Overflow Menu --}}
                        <div class="relative" x-data="{ open: false }">
                            <button
                                @click="open = !open"
                                type="button"
                                class="flex items-center gap-2 rounded-lg px-3 py-2.5 text-sm font-medium text-gray-500 hover:bg-gray-50 hover:text-gray-900"
                            >
                                <x-heroicon-m-ellipsis-horizontal class="h-5 w-5" />
                                More
                            </button>

                            <div
                                x-show="open"
                                @click.away="open = false"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 transform scale-95"
                                x-transition:enter-end="opacity-100 transform scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="opacity-100 transform scale-100"
                                x-transition:leave-end="opacity-0 transform scale-95"
                                class="absolute right-0 z-50 mt-1 w-56 origin-top-right rounded-lg bg-white py-2 shadow-lg ring-1 ring-black ring-opacity-5"
                            >
                                @foreach($this->overflowTabs as $label => $tab)
                                    <button
                                        wire:click="setActiveTab('{{ $label }}')"
                                        @click="open = false"
                                        type="button"
                                        @class([
                                            'flex w-full items-center gap-2 px-4 py-2 text-sm transition-colors duration-200',
                                            'bg-primary-50 text-primary-600' => $activeTab === $label,
                                            'text-gray-600 hover:bg-gray-50 hover:text-gray-900' => $activeTab !== $label,
                                        ])
                                    >
                                        <x-dynamic-component :component="$tab['icon']" class="h-5 w-5" />
                                        {{ $label }}
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    </nav>
                </div>
            </div>

            {{-- Tab Content with Loading State --}}
            <div wire:loading.remove wire:target="setActiveTab">
                <div 
                    x-data="{ show: false }" 
                    x-show="show" 
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform scale-95"
                    x-transition:enter-end="opacity-100 transform scale-100"
                    x-transition:leave="transition ease-in duration-100"
                    x-transition:leave-start="opacity-100 transform scale-100"
                    x-transition:leave-end="opacity-0 transform scale-95"
                    x-init="show = true"
                >
                    @if(isset($this->tabs[$activeTab]['component']))
                        <div wire:key="{{ $activeTab }}">
                            <livewire:is 
                                :component="$this->tabs[$activeTab]['component']" 
                                :member="$this->record" 
                                :wire:key="$activeTab"
                            />
                        </div>
                    @else
                        <div class="rounded-xl bg-white p-6 shadow-sm">
                            <div class="flex flex-col items-center justify-center py-12 text-center">
                                <div class="rounded-full bg-primary-50 p-3">
                                    <x-heroicon-o-wrench-screwdriver class="h-6 w-6 text-primary-500" />
                                </div>
                                <h3 class="mt-4 text-sm font-medium text-gray-900">Coming Soon</h3>
                                <p class="mt-1 text-sm text-gray-500">This feature is currently under development.</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Loading Skeleton --}}
            <div wire:loading wire:target="setActiveTab" class="w-full">
                <div class="rounded-xl bg-white shadow-sm">
                    <div class="animate-pulse">
                        @if(str_contains($this->tabs[$activeTab]['component'] ?? '', 'OverviewTab'))
                            {{-- Overview Tab Skeleton --}}
                            <div class="p-6 space-y-8">
                                {{-- Stats Grid --}}
                                <div class="grid grid-cols-3 gap-6">
                                    @for ($i = 0; $i < 3; $i++)
                                        <div class="p-6 rounded-lg border border-gray-200">
                                            <div class="h-4 w-20 bg-gray-200 rounded mb-2"></div>
                                            <div class="h-8 w-16 bg-gray-200 rounded"></div>
                                        </div>
                                    @endfor
                                </div>

                                {{-- Recent Activity Section --}}
                                <div class="space-y-4">
                                    <div class="h-5 w-40 bg-gray-200 rounded"></div>
                                    <div class="space-y-4">
                                        @for ($i = 0; $i < 4; $i++)
                                            <div class="flex items-start space-x-4">
                                                <div class="w-10 h-10 rounded-full bg-gray-200"></div>
                                                <div class="flex-1 space-y-2">
                                                    <div class="h-4 w-3/4 bg-gray-200 rounded"></div>
                                                    <div class="h-4 w-1/2 bg-gray-200 rounded"></div>
                                                </div>
                                            </div>
                                        @endfor
                                    </div>
                                </div>

                                {{-- Additional Info Section --}}
                                <div class="space-y-4">
                                    <div class="h-5 w-32 bg-gray-200 rounded"></div>
                                    <div class="grid grid-cols-2 gap-6">
                                        @for ($i = 0; $i < 4; $i++)
                                            <div class="space-y-2">
                                                <div class="h-4 w-24 bg-gray-200 rounded"></div>
                                                <div class="h-4 w-48 bg-gray-200 rounded"></div>
                                            </div>
                                        @endfor
                                    </div>
                                </div>
                            </div>
                        @else
                            {{-- Table Layout Skeleton for Other Tabs --}}
                            <div>
                                {{-- Top Section Skeleton --}}
                                <div class="p-4 space-y-4">
                                    {{-- Search and Filters --}}
                                    <div class="flex items-center justify-between">
                                        <div class="w-72">
                                            <div class="h-10 bg-gray-200 rounded-lg w-full"></div>
                                        </div>
                                        <div class="flex items-center space-x-4">
                                            <div class="h-10 w-32 bg-gray-200 rounded-lg"></div>
                                            <div class="h-10 w-32 bg-gray-200 rounded-lg"></div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Table Section --}}
                                <div class="border-t border-gray-200">
                                    {{-- Table Header --}}
                                    <div class="border-b border-gray-200">
                                        <div class="grid grid-cols-12 gap-3 px-4 py-3">
                                            <div class="col-span-1">
                                                <div class="h-4 bg-gray-200 rounded w-4"></div>
                                            </div>
                                            <div class="col-span-3">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-4">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-2">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-2">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Table Rows --}}
                                    @for ($i = 0; $i < 6; $i++)
                                        <div class="border-b border-gray-100">
                                            <div class="grid grid-cols-12 gap-3 px-4 py-3">
                                                <div class="col-span-1">
                                                    <div class="h-4 bg-gray-200 rounded w-4"></div>
                                                </div>
                                                <div class="col-span-3">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-4">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-2">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-2">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endfor

                                    {{-- Pagination --}}
                                    <div class="px-4 py-3 border-t border-gray-200 flex items-center justify-between">
                                        <div class="flex items-center gap-4">
                                            <div class="h-8 w-48 bg-gray-200 rounded"></div>
                                        </div>
                                        <div class="flex items-center gap-2">
                                            @for ($i = 0; $i < 4; $i++)
                                                <div class="h-8 w-8 bg-gray-200 rounded"></div>
                                            @endfor
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-filament::page> 