@php
    $user = $this->record;
    $activeSubscription = $user->subscriptions()->where('is_active', true)->first();
@endphp

<x-filament::page>
    {{-- Status and Actions Bar --}}
    <x-admin.member.status-action-bar :member="$user" />
    {{-- Main Content Grid --}}
    <div class="grid grid-cols-12 gap-6">
        {{-- Profile Card --}}
        <x-admin.member.profile-card :user="$user" :activeSubscription="$activeSubscription" />
        {{-- Tabs and Content Section --}}
        <div class="col-span-12 lg:col-span-9">
            {{-- Navigation Tabs --}}
            <div class="mb-6">
                <div class="p-2 bg-white rounded-xl shadow-sm">
                    <nav class="flex gap-1 items-center" aria-label="Tabs">
                        <div class="flex overflow-x-auto flex-1 gap-1 items-center">
                            @foreach ($this->tabs as $label => $tab)
                                <button wire:click="setActiveTab('{{ $label }}')"
                                    type="button"
                                    @class([
                                        'group relative flex items-center gap-2.5 rounded-lg px-4 py-2.5 text-sm font-medium transition-all duration-200 whitespace-nowrap',
                                        'bg-primary-50/80 text-primary-600 ring-1 ring-primary-100/80' =>
                                            $activeTab === $label,
                                        'hover:bg-gray-50 hover:text-gray-900' => $activeTab !== $label,
                                    ])>
                                    <div @class([
                                        'flex items-center justify-center transition-transform duration-200 ease-out group-hover:scale-110',
                                        'text-primary-600' => $activeTab === $label,
                                        'text-gray-400 group-hover:text-gray-500' => $activeTab !== $label,
                                    ])>
                                        <x-dynamic-component :component="$tab['icon']" class="w-5 h-5" />
                                    </div>

                                    <span class="relative">
                                        {{ $label }}
                                        @if (isset($tab['badge']) && $tab['badge'] > 0)
                                            <span @class([
                                                'absolute -right-5 -top-2.5 flex h-4 min-w-[1rem] items-center justify-center rounded-full px-1.5 text-[10px] font-medium leading-none',
                                                'bg-white text-primary-600 ring-1 ring-primary-100' =>
                                                    $activeTab === $label,
                                                'bg-gray-100/80 text-gray-600' => $activeTab !== $label,
                                            ])>
                                                {{ $tab['badge'] > 99 ? '99+' : number_format($tab['badge']) }}
                                            </span>
                                        @endif
                                        @if ($activeTab === $label)
                                            <span class="absolute left-0 -bottom-1.5 w-full h-0.5 rounded-full bg-primary-600"></span>
                                        @endif
                                    </span>
                                </button>
                            @endforeach
                        </div>

                        {{-- Overflow Menu --}}
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open"
                                type="button"
                                class="flex gap-2 items-center px-3 py-2.5 text-sm font-medium text-gray-500 rounded-lg hover:bg-gray-50 hover:text-gray-900">
                                <x-heroicon-m-ellipsis-horizontal class="w-5 h-5" />
                                More
                            </button>

                            <div x-show="open"
                                @click.away="open = false"
                                x-transition:enter="transition ease-out duration-200"
                                x-transition:enter-start="opacity-0 transform scale-95"
                                x-transition:enter-end="opacity-100 transform scale-100"
                                x-transition:leave="transition ease-in duration-75"
                                x-transition:leave-start="opacity-100 transform scale-100"
                                x-transition:leave-end="opacity-0 transform scale-95"
                                class="absolute right-0 z-50 py-2 mt-1 w-56 bg-white rounded-lg ring-1 ring-black ring-opacity-5 shadow-lg origin-top-right">
                                @foreach ($this->overflowTabs as $label => $tab)
                                    <button wire:click="setActiveTab('{{ $label }}')"
                                        @click="open = false"
                                        type="button"
                                        @class([
                                            'flex w-full items-center gap-2 px-4 py-2 text-sm transition-colors duration-200',
                                            'bg-primary-50 text-primary-600' => $activeTab === $label,
                                            'text-gray-600 hover:bg-gray-50 hover:text-gray-900' =>
                                                $activeTab !== $label,
                                        ])>
                                        <x-dynamic-component :component="$tab['icon']" class="w-5 h-5" />
                                        {{ $label }}
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    </nav>
                </div>
            </div>

            {{-- Tab Content with Loading State --}}
            <div wire:loading.remove wire:target="setActiveTab">
                <div x-data="{ show: false }"
                    x-show="show"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform scale-95"
                    x-transition:enter-end="opacity-100 transform scale-100"
                    x-transition:leave="transition ease-in duration-100"
                    x-transition:leave-start="opacity-100 transform scale-100"
                    x-transition:leave-end="opacity-0 transform scale-95"
                    x-init="show = true">
                    @php
                        $tabConfig = $this->tabs[$activeTab] ?? ($this->overflowTabs[$activeTab] ?? null);
                    @endphp
                    @if ($tabConfig && isset($tabConfig['component']) && $tabConfig['component'])
                        <div wire:key="{{ $activeTab }}">
                            <livewire:is :component="$tabConfig['component']"
                                :member="$this->record"
                                :wire:key="$activeTab" />
                        </div>
                    @else
                        <div class="p-6 bg-white rounded-xl shadow-sm">
                            <div class="flex flex-col justify-center items-center py-12 text-center">
                                <div class="p-3 rounded-full bg-primary-50">
                                    <x-heroicon-o-wrench-screwdriver class="w-6 h-6 text-primary-500" />
                                </div>
                                <h3 class="mt-4 text-sm font-medium text-gray-900">Coming Soon</h3>
                                <p class="mt-1 text-sm text-gray-500">This feature is currently under development.</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Loading Skeleton --}}
            <div wire:loading
                wire:target="setActiveTab"
                class="w-full">
                <div class="bg-white rounded-xl shadow-sm">
                    <div class="animate-pulse">
                        @php
                            $currentTabConfig = $this->tabs[$activeTab] ?? ($this->overflowTabs[$activeTab] ?? null);
                            $currentTabComponent = $currentTabConfig['component'] ?? '';
                        @endphp
                        @if (str_contains($currentTabComponent, 'OverviewTab'))
                            {{-- Overview Tab Skeleton --}}
                            <div class="p-6 space-y-8">
                                {{-- Stats Grid --}}
                                <div class="grid grid-cols-3 gap-6">
                                    @for ($i = 0; $i < 3; $i++)
                                        <div class="p-6 rounded-lg border border-gray-200">
                                            <div class="mb-2 w-20 h-4 bg-gray-200 rounded"></div>
                                            <div class="w-16 h-8 bg-gray-200 rounded"></div>
                                        </div>
                                    @endfor
                                </div>

                                {{-- Recent Activity Section --}}
                                <div class="space-y-4">
                                    <div class="w-40 h-5 bg-gray-200 rounded"></div>
                                    <div class="space-y-4">
                                        @for ($i = 0; $i < 4; $i++)
                                            <div class="flex items-start space-x-4">
                                                <div class="w-10 h-10 bg-gray-200 rounded-full"></div>
                                                <div class="flex-1 space-y-2">
                                                    <div class="w-3/4 h-4 bg-gray-200 rounded"></div>
                                                    <div class="w-1/2 h-4 bg-gray-200 rounded"></div>
                                                </div>
                                            </div>
                                        @endfor
                                    </div>
                                </div>

                                {{-- Additional Info Section --}}
                                <div class="space-y-4">
                                    <div class="w-32 h-5 bg-gray-200 rounded"></div>
                                    <div class="grid grid-cols-2 gap-6">
                                        @for ($i = 0; $i < 4; $i++)
                                            <div class="space-y-2">
                                                <div class="w-24 h-4 bg-gray-200 rounded"></div>
                                                <div class="w-48 h-4 bg-gray-200 rounded"></div>
                                            </div>
                                        @endfor
                                    </div>
                                </div>
                            </div>
                        @else
                            {{-- Table Layout Skeleton for Other Tabs --}}
                            <div>
                                {{-- Top Section Skeleton --}}
                                <div class="p-4 space-y-4">
                                    {{-- Search and Filters --}}
                                    <div class="flex justify-between items-center">
                                        <div class="w-72">
                                            <div class="w-full h-10 bg-gray-200 rounded-lg"></div>
                                        </div>
                                        <div class="flex items-center space-x-4">
                                            <div class="w-32 h-10 bg-gray-200 rounded-lg"></div>
                                            <div class="w-32 h-10 bg-gray-200 rounded-lg"></div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Table Section --}}
                                <div class="border-t border-gray-200">
                                    {{-- Table Header --}}
                                    <div class="border-b border-gray-200">
                                        <div class="grid grid-cols-12 gap-3 px-4 py-3">
                                            <div class="col-span-1">
                                                <div class="w-4 h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-3">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-4">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-2">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                            <div class="col-span-2">
                                                <div class="h-4 bg-gray-200 rounded"></div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Table Rows --}}
                                    @for ($i = 0; $i < 6; $i++)
                                        <div class="border-b border-gray-100">
                                            <div class="grid grid-cols-12 gap-3 px-4 py-3">
                                                <div class="col-span-1">
                                                    <div class="w-4 h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-3">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-4">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-2">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                                <div class="col-span-2">
                                                    <div class="h-4 bg-gray-200 rounded"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endfor

                                    {{-- Pagination --}}
                                    <div class="flex justify-between items-center px-4 py-3 border-t border-gray-200">
                                        <div class="flex gap-4 items-center">
                                            <div class="w-48 h-8 bg-gray-200 rounded"></div>
                                        </div>
                                        <div class="flex gap-2 items-center">
                                            @for ($i = 0; $i < 4; $i++)
                                                <div class="w-8 h-8 bg-gray-200 rounded"></div>
                                            @endfor
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-filament::page>
