<x-filament-panels::page>
    <div class="space-y-6">
        {{-- Profile Meta Form Section --}}
        <div class="bg-white rounded-lg shadow">
            <div class="px-4 py-5 sm:p-6">
                <div class="mb-5">
                    <h3 class="text-lg font-medium text-gray-900">
                        Profile Highlights & Services
                    </h3>
                    <p class="mt-1 text-sm text-gray-600">
                        Manage member's service highlights, selling points, and emergency service information.
                    </p>
                </div>

                <form wire:submit="saveProfileMeta">
                    {{ $this->form }}

                    <div class="mt-6">
                        <x-filament::button type="submit" color="primary">
                            Save Profile Information
                        </x-filament::button>
                    </div>
                </form>
            </div>
        </div>

        {{-- Services Management Section --}}
        <div class="bg-white rounded-lg shadow">
            <div class="px-4 py-5 sm:p-6">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h3 class="text-lg font-medium text-gray-900">
                            Member Services
                        </h3>
                        <p class="mt-1 text-sm text-gray-600">
                            Manage services offered by this member.
                        </p>
                    </div>

                    <x-filament::button x-data
                        @click="$dispatch('open-modal', 'add-service-modal')"
                        color="primary"
                        icon="heroicon-m-plus">
                        Add Service
                    </x-filament::button>
                </div>

                {{-- Services List --}}
                <div wire:sortable="reorder"
                    wire:sortable.options="{ animation: 150, handle: '.drag-handle', dragClass: 'opacity-50' }"
                    class="space-y-4">
                    @forelse ($services as $service)
                        <div wire:key="service-{{ $service->uuid }}"
                            wire:sortable.item="{{ $service->uuid }}"
                            class="transition-all duration-200">
                            <div class="rounded-lg border border-gray-200 transition-shadow duration-200 hover:shadow-md">
                                <div class="flex">
                                    {{-- Drag Handle --}}
                                    <div class="flex justify-center items-center w-12 border-r border-gray-200 cursor-move drag-handle hover:bg-gray-50">
                                        <x-heroicon-o-bars-4 class="w-5 h-5 text-gray-400" />
                                    </div>

                                    {{-- Service Content --}}
                                    <div class="flex-1 p-4" wire:sortable.handle.stop>
                                        <div class="flex justify-between items-start mb-2">
                                            <h4 class="text-lg font-medium text-gray-900">
                                                {{ $service->service_title }}
                                            </h4>

                                            <div class="flex items-center space-x-2">
                                                <x-filament::button wire:click.stop="editService('{{ $service->uuid }}')"
                                                    color="gray"
                                                    size="sm"
                                                    icon="heroicon-m-pencil">
                                                    Edit
                                                </x-filament::button>

                                                <x-filament::button wire:click.stop="mountAction('delete', { uuid: '{{ $service->uuid }}' })"
                                                    color="danger"
                                                    size="sm"
                                                    icon="heroicon-m-trash">
                                                    Delete
                                                </x-filament::button>
                                            </div>
                                        </div>

                                        <p class="text-sm text-gray-600">
                                            {{ str($service->service_description)->limit(200) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="py-8 text-center">
                            <x-heroicon-o-briefcase class="mx-auto w-12 h-12 text-gray-400" />
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No services</h3>
                            <p class="mt-1 text-sm text-gray-500">Get started by adding a service for this member.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    {{-- Service Modal --}}
    <div x-data="{
        show: false,
        closeModal() {
            this.show = false;
            $wire.resetForm();
        }
    }"
        x-show="show"
        x-on:open-modal.window="$event.detail == 'add-service-modal' ? show = true : null"
        x-on:close-modal.window="closeModal"
        x-on:close.window="closeModal"
        x-on:keydown.escape.window="closeModal"
        class="overflow-y-auto fixed inset-0 z-50"
        style="display: none;">

        <div class="flex justify-center items-center px-4 pt-4 pb-20 min-h-screen text-center sm:block sm:p-0">
            {{-- Backdrop --}}
            <div x-show="show"
                x-transition:enter="ease-out duration-300"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in duration-200"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
                aria-hidden="true">
            </div>

            <span class="hidden sm:inline-block sm:h-screen sm:align-middle" aria-hidden="true">&#8203;</span>

            {{-- Modal Content --}}
            <div x-show="show"
                x-transition:enter="ease-out duration-300"
                x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                x-transition:leave="ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                class="inline-block overflow-hidden px-4 pt-5 pb-4 w-full max-w-2xl text-left align-bottom bg-white rounded-lg shadow-xl transition-all transform sm:my-8 sm:align-middle sm:p-6">

                <div class="hidden absolute top-0 right-0 pt-4 pr-4 sm:block">
                    <button type="button"
                        @click="closeModal"
                        class="text-gray-400 bg-white rounded-md hover:text-gray-500 focus:outline-none">
                        <span class="sr-only">Close</span>
                        <x-heroicon-o-x-mark class="w-6 h-6" />
                    </button>
                </div>

                <div class="sm:flex sm:items-start">
                    <div class="mt-3 w-full text-center sm:mt-0 sm:text-left">
                        <h3 class="text-lg font-medium leading-6 text-gray-900">
                            {{ $editingService ? 'Edit Service' : 'Add New Service' }}
                        </h3>

                        <form wire:submit="save" class="mt-6">
                            <div class="space-y-6">
                                <div>
                                    <label for="service_title" class="block text-sm font-medium text-gray-700">
                                        Service Title
                                        <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text"
                                        id="service_title"
                                        wire:model="service_title"
                                        class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm"
                                        placeholder="Enter service title"
                                        required>
                                    @error('service_title')
                                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="service_description" class="block text-sm font-medium text-gray-700">
                                        Service Description
                                        <span class="text-red-500">*</span>
                                    </label>
                                    <textarea id="service_description"
                                        wire:model="service_description"
                                        rows="6"
                                        class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 sm:text-sm"
                                        placeholder="Enter service description"
                                        required></textarea>
                                    @error('service_description')
                                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div class="flex justify-end mt-6 space-x-3">
                                <x-filament::button type="button"
                                    @click="closeModal"
                                    color="gray">
                                    Cancel
                                </x-filament::button>

                                <x-filament::button type="submit" color="primary">
                                    {{ $editingService ? 'Update' : 'Save' }}
                                </x-filament::button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <x-filament-actions::modals />
</x-filament-panels::page>
