<x-filament-panels::page>
    <div class="space-y-6">
        <!-- Invoice Details -->
        <div class="bg-white rounded-lg shadow-sm p-6 border border-gray-200">
            <!-- Header -->
            <div class="flex justify-between items-start mb-8">
                <div class="flex items-start gap-4">
                    <div class="space-y-2">
                        <h1 class="text-2xl font-bold text-gray-900">ESP Directory</h1>
                        <div class="text-sm text-gray-600 space-y-1">
                            <p>123 Business Street</p>
                            <p>Suite 100</p>
                            <p>Toronto, ON M5H 2N2</p>
                            <p>Canada</p>
                            <p>Phone: (416) 555-0123</p>
                            <p>Email: info@espdirectory.com</p>
                        </div>
                    </div>
                </div>

                <div class="text-right space-y-2">
                    <h2 class="text-xl font-semibold text-gray-900">INVOICE</h2>
                    <div class="text-sm text-gray-600 space-y-1">
                        <p><strong>Invoice ID:</strong> {{ $record->invoice_id ?? 'N/A' }}</p>
                        <p><strong>Date:</strong> {{ $record->created_at->format('M d, Y') }}</p>
                        <p><strong>Status:</strong> 
                            <span class="px-2 py-1 text-xs rounded-full {{ $record->status ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $record->status ? 'Paid' : 'Unpaid' }}
                            </span>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Bill To -->
            <div class="mb-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Bill To:</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-2">
                        <p class="text-sm text-gray-600"><strong>Name:</strong> {{ $record->user->name ?? 'N/A' }}</p>
                        <p class="text-sm text-gray-600"><strong>Email:</strong> {{ $record->user->email ?? 'N/A' }}</p>
                        @if($record->user->phone)
                            <p class="text-sm text-gray-600"><strong>Phone:</strong> {{ $record->user->phone }}</p>
                        @endif
                    </div>
                    <div class="space-y-2">
                        @if($record->user->company_name)
                            <p class="text-sm text-gray-600"><strong>Company:</strong> {{ $record->user->company_name }}</p>
                        @endif
                        @if($record->user->city || $record->user->province || $record->user->postal_code)
                            <p class="text-sm text-gray-600">
                                <strong>Location:</strong> 
                                {{ collect([$record->user->city, $record->user->province, $record->user->postal_code])->filter()->join(', ') }}
                            </p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Invoice Items -->
            <div class="mb-8">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Invoice Items</h3>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Item Type</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Quantity</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full {{ $record->item_type?->getColor() === 'info' ? 'bg-blue-100 text-blue-800' : ($record->item_type?->getColor() === 'warning' ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800') }}">
                                        {{ $record->item_type}}
                                    </span>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-gray-900">
                                        @if($record->item_type === \App\Enums\PurchaseItemType::Subscription && $record->purchaseable?->membershipPlan)
                                            <div class="space-y-1">
                                                <p class="font-medium">{{ $record->purchaseable->membershipPlan->package_title }}</p>
                                                <p class="text-gray-600">{{ $record->purchaseable->membershipPlan->package_description }}</p>
                                                <div class="text-xs text-gray-500">
                                                    <p>Payment Term: {{ $record->purchaseable->payment_term?->getLabel() ?? 'N/A' }}</p>
                                                    @if($record->purchaseable->current_period_start && $record->purchaseable->current_period_end)
                                                        <p>Period: {{ $record->purchaseable->current_period_start->format('M d, Y') }} - {{ $record->purchaseable->current_period_end->format('M d, Y') }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        @else
                                            {{-- <p>{{ $record->item_type?->getDescription() }}</p> --}}
                                        @endif
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $record->quantity ?? 1 }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    ${{ number_format($record->amount, 2) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    ${{ number_format($record->amount * ($record->quantity ?? 1), 2) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Invoice Summary -->
            <div class="flex justify-end mb-8">
                <div class="w-full max-w-md space-y-3">
                    <div class="flex justify-between text-sm">
                        <span class="text-gray-600">Subtotal:</span>
                        <span class="text-gray-900">${{ number_format($record->amount * ($record->quantity ?? 1), 2) }}</span>
                    </div>
                    
                    @if($record->tax_amount && $record->tax_amount > 0)
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Tax:</span>
                            <span class="text-gray-900">${{ number_format($record->tax_amount, 2) }}</span>
                        </div>
                    @endif
                    
                    @if($record->discount_amount && $record->discount_amount > 0)
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Discount:</span>
                            <span class="text-red-600">-${{ number_format($record->discount_amount, 2) }}</span>
                        </div>
                    @endif
                    
                    <div class="border-t border-gray-200 pt-3">
                        <div class="flex justify-between text-lg font-semibold">
                            <span class="text-gray-900">Total:</span>
                            <span class="text-gray-900">${{ number_format($record->total_amount, 2) }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment History -->
            @if($record->payments && $record->payments->count() > 0)
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Payment History</h3>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Method</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Transaction ID</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($record->payments as $payment)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $payment->payment_date?->format('M d, Y') ?? $payment->created_at->format('M d, Y') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $payment->payment_method?->getLabel() ?? 'N/A' }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            ${{ number_format($payment->amount, 2) }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 py-1 text-xs font-medium rounded-full {{ $payment->status?->getColor() === 'success' ? 'bg-green-100 text-green-800' : ($payment->status?->getColor() === 'warning' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') }}">
                                                {{ $payment->status?->getLabel() ?? 'Unknown' }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $payment->transaction_id ?? 'N/A' }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            @endif

            <!-- Notes -->
            @if($record->notes)
                <div class="mb-8">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Notes</h3>
                    <p class="text-sm text-gray-600">{{ $record->notes }}</p>
                </div>
            @endif

            <!-- Footer -->
            <div class="text-center text-sm text-gray-600 space-y-2 pt-8 border-t border-gray-200">
                <p><strong>Thank you for your business!</strong></p>
                <p>For questions regarding this invoice, please contact us at <a href="mailto:billing@espdirectory.com" class="text-blue-600 hover:text-blue-800">billing@espdirectory.com</a></p>
                <p>ESP Directory | 123 Business Street, Toronto, ON M5H 2N2 | Phone: (416) 555-0123</p>
            </div>
        </div>
    </div>
</x-filament-panels::page>
