@php
    $id = $getId();
    $statePath = $getStatePath();
    $editorId = $getEditorId();
@endphp

<x-dynamic-component :component="$getFieldWrapperView()" :field="$field">
    <div x-data="{
        state: $wire.entangle('{{ $statePath }}'),
        init() {
            // Wait for TinyMCE to load
            if (typeof tinymce === 'undefined') {
                // If TinyMCE is not loaded, add a script tag to load it
                if (!document.querySelector('script[src*=\'tinymce\']')) {
                    const script = document.createElement('script');
                    script.src = 'https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.7.3/tinymce.min.js';
                    script.referrerpolicy = 'origin';
                    document.head.appendChild(script);
    
                    script.onload = () => this.initTinyMce();
                } else {
                    // Wait for TinyMCE to be ready
                    const checkTinyMCE = setInterval(() => {
                        if (typeof tinymce !== 'undefined') {
                            clearInterval(checkTinyMCE);
                            this.initTinyMce();
                        }
                    }, 100);
                }
            } else {
                this.initTinyMce();
            }
        },
        initTinyMce() {
            // Clean up any existing editor instance
            tinymce.remove('#{{ $editorId }}');
    
            // Initialize TinyMCE
            tinymce.init({
                selector: '#{{ $editorId }}',
                plugins: '{{ $getPlugins() }}',
                toolbar: '{{ $getToolbar() }}',
                menubar: {{ $getMenubar() ? 'true' : 'false' }},
                branding: {{ $getBranding() ? 'true' : 'false' }},
                promotion: {{ $getPromotion() ? 'true' : 'false' }},
                height: {{ $getHeight() }},
                @if($getPlaceholder())
                placeholder: '{{ str_replace("'", "\\'", $getPlaceholder()) }}',
                @endif
                setup: (editor) => {
                    editor.on('init', () => {
                        editor.setContent(this.state || '');
                    });
    
                    editor.on('change input blur', () => {
                        this.state = editor.getContent();
                    });
                }
            });
        }
    }" wire:ignore>
        <textarea id="{{ $editorId }}" class="hidden">{{ $getState() }}</textarea>
    </div>
</x-dynamic-component>
