<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex, nofollow">
    <title>@yield('title', 'Dashboard')</title>
    <link rel="icon"
        href="{{ get_app_favicon() }}"
        type="image/x-icon">
    @filamentStyles
    @vite(['resources/css/dashboard/dashboard.css'])

    <!-- TinyMCE from CDN -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/6.7.3/tinymce.min.js" referrerpolicy="no-referrer"></script>
</head>

<body class="font-Poppins bg-body-blue">
    <x-dashboard.common.navbar />
    <section class="">
        <div class="sidebar transition-all ease-in-out duration-500 pt-5 border-r border-solid border-gray-1200 z-50 max-w-11xl bg-white fixed lg:left-0 -left-full bottom-0 sm:h-[calc(100%-71px)] h-[calc(100%-54px)] overflow-y-auto pb-5">
            <x-dashboard.common.sidebar />
        </div>
        <div class="right-content pt-[71px] lg:pl-[249px] pl-0 pr-0">
            <div class="xl:p-[30px] lg:p-5 p-4">
                @isset($slot)
                    {{ $slot }}
                @endisset
                @yield('content')
            </div>
        </div>
    </section>
    @livewire('notifications')
    @filamentScripts
    @vite(['resources/js/dashboard/dashboard.js', 'resources/js/editor.js'])

    @stack('after_scripts')
</body>

</html>
