@props(['saveable'])
<button wire:click="toggleSave" type="button" class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
    <x-icon-save-icon class="w-4 h-4 {{ $isSaved ? 'text-primary-blue' : '' }}" />
    <span class="hidden md:block">{{ $isSaved ? __('Saved') : __('Save') }}</span>
</button>