@php
    use Illuminate\Support\Facades\Route;
@endphp
@section('title', 'Sign in to your account')

<div class="flex justify-center items-center px-4 min-h-screen bg-gray-50 sm:px-6 lg:px-8">
    <div class="space-y-8 w-full max-w-md">
        <!-- Header Section -->
        <div class="text-center">
            <h2 class="mb-2 text-3xl font-extrabold text-gray-900">
                Sign in to your account
            </h2>
            @if (Route::has('register'))
                <p class="text-sm text-gray-600">
                    Or
                    <a href="{{ route('register') }}" class="font-medium text-indigo-600 transition duration-150 ease-in-out hover:text-indigo-500 focus:outline-none focus:underline">
                        create a new account
                    </a>
                </p>
            @endif
        </div>

        <!-- Login Form -->
        <div class="px-6 py-8 bg-white rounded-lg border border-gray-200 shadow-lg">
            <form wire:submit.prevent="authenticate" class="space-y-6">
                <!-- Email Field -->
                <div>
                    <label for="email" class="block mb-1 text-sm font-medium text-gray-700">
                        Email address
                    </label>
                    <div class="relative">
                        <input wire:model.lazy="email"
                            id="email"
                            name="email"
                            type="email"
                            required
                            autofocus
                            placeholder="Enter your email address"
                            class="appearance-none block w-full px-3 py-3 border border-gray-300 rounded-md placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition duration-150 ease-in-out sm:text-sm @error('email') border-red-300 text-red-900 placeholder-red-300 focus:border-red-300 focus:ring-red-500 @enderror" />
                    </div>
                    @error('email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password Field -->
                <div>
                    <label for="password" class="block mb-1 text-sm font-medium text-gray-700">
                        Password
                    </label>
                    <div class="relative">
                        <input wire:model.lazy="password"
                            id="password"
                            type="password"
                            required
                            placeholder="Enter your password"
                            class="appearance-none block w-full px-3 py-3 border border-gray-300 rounded-md placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-indigo-500 transition duration-150 ease-in-out sm:text-sm @error('password') border-red-300 text-red-900 placeholder-red-300 focus:border-red-300 focus:ring-red-500 @enderror" />
                    </div>
                    @error('password')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Remember & Forgot Password -->
                <div class="flex justify-between items-center">
                    <div class="flex items-center">
                        <input wire:model.lazy="remember"
                            id="remember"
                            type="checkbox"
                            class="w-4 h-4 text-indigo-600 rounded border-gray-300 transition duration-150 ease-in-out focus:ring-indigo-500" />
                        <label for="remember" class="block ml-2 text-sm text-gray-700">
                            Remember me
                        </label>
                    </div>

                    <div class="text-sm">
                        <a href="{{ route('password.request') }}" class="font-medium text-indigo-600 transition duration-150 ease-in-out hover:text-indigo-500 focus:outline-none focus:underline">
                            Forgot your password?
                        </a>
                    </div>
                </div>

                <!-- Login Button -->
                <div>
                    <button type="submit" class="w-full primary-btn disabled:opacity-50 disabled:cursor-not-allowed focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                        <span wire:loading.remove wire:target="authenticate">
                            Sign in
                        </span>
                        <span wire:loading
                            wire:target="authenticate"
                            class="flex items-center">
                            <svg class="mr-2 -ml-1 w-4 h-4 text-white animate-spin"
                                xmlns="http://www.w3.org/2000/svg"
                                fill="none"
                                viewBox="0 0 24 24">
                                <circle class="opacity-25"
                                    cx="12"
                                    cy="12"
                                    r="10"
                                    stroke="currentColor"
                                    stroke-width="4"></circle>
                                <path class="opacity-75"
                                    fill="currentColor"
                                    d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                            </svg>
                            Signing in...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
