<div class="w-full max-w-md mx-auto">
    <h3 class="mb-4 text-xl font-semibold text-white">Get Notified When We Launch</h3>

    <form wire:submit="subscribe" class="space-y-4">
        <div class="relative" x-show="!$wire.subscribed">
            <input type="email" wire:model="email" class="w-full px-4 py-3 text-white placeholder-indigo-200 border rounded-lg bg-white/10 border-white/20 focus:outline-none focus:ring-2 focus:ring-white/50" placeholder="Enter your email address" required>
            <button type="submit" class="absolute px-4 py-2 font-medium text-indigo-800 transition-colors bg-white rounded-md right-1 top-1 hover:bg-indigo-100">
                Notify Me
            </button>
        </div>

        @if ($errorMessage)
            <div class="text-sm text-red-300">{{ $errorMessage }}</div>
        @endif

        @if ($subscribed)
            <div class="p-4 text-center text-indigo-100 rounded-lg bg-white/10 backdrop-blur-sm">
                Thank you! We'll notify you when we launch.
            </div>
        @endif
    </form>
</div>
