@php
    use Illuminate\Support\Str;
    use App\Enums\MembershipType;
@endphp
<div>
    {{-- Grid Container for Side by Side Layout --}}
    <div class="grid grid-cols-1 gap-6 lg:grid-cols-2">
        {{-- Credit Balance Section - Always Visible --}}
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
            <div class="w-full">
                <div class="flex justify-between items-center mb-6">
                    <h4 class="text-lg font-semibold leading-none text-dark-blue">{{ __('Credit Balance') }}</h4>
                    <a href="{{ route('dashboard.credits.purchase') }}"
                        wire:navigate
                        class="flex gap-2 justify-center items-center px-6 py-2.5 text-sm font-medium text-white rounded-md transition-colors duration-200 bg-blue-1200 hover:bg-blue-1200/90">
                        <svg class="w-4 h-4"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round"
                                stroke-linejoin="round"
                                stroke-width="2"
                                d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                        </svg>
                        {{ __('Buy Credits') }}
                    </a>
                </div>

                <div class="p-6 bg-gray-50 rounded-xl border border-gray-100">
                    <div class="flex gap-4 items-center">
                        <div class="p-3 rounded-full bg-blue-1200/10">
                            <svg class="w-6 h-6 text-blue-1200"
                                fill="none"
                                stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1" />
                            </svg>
                        </div>
                        <div>
                            <p class="text-sm font-medium text-dark-blue/70">{{ __('Available Credits') }}</p>
                            <p class="mt-1 text-3xl font-bold text-dark-blue">{{ $creditBalance }}</p>
                        </div>
                    </div>
                    <div class="pt-4 mt-4 border-t border-gray-200">
                        <p class="text-sm text-dark-blue/60">
                            {{ __('Use credits to boost your listings and access premium features.') }}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        {{-- Subscription Section --}}
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
            @if (!$subscription)
                {{-- No Subscription Message --}}
                <div class="text-center">
                    {{-- Icon --}}
                    <div class="mb-6">
                        <div class="flex justify-center items-center mx-auto w-16 h-16 rounded-full bg-blue-1200/10">
                            <svg class="w-8 h-8 text-blue-1200"
                                fill="none"
                                stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                            </svg>
                        </div>
                    </div>

                    {{-- Title --}}
                    <h3 class="mb-3 text-xl font-semibold text-dark-blue">
                        {{ __('No Active Subscription') }}
                    </h3>

                    {{-- Description --}}
                    <p class="mx-auto mb-6 max-w-md text-dark-blue/70">
                        {{ __('You currently don\'t have an active subscription. Choose a membership plan to unlock premium features and start growing your business.') }}
                    </p>

                    {{-- Action Buttons --}}
                    <div class="flex flex-col gap-3 justify-center items-center sm:flex-row">
                        <a href="#" class="inline-flex items-center justify-center px-6 py-3 bg-blue-1200 text-white font-medium text-sm rounded-md hover:bg-blue-1200/90 transition-colors duration-200 min-w-[140px]">
                            <svg class="mr-2 w-4 h-4"
                                fill="none"
                                stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            {{ __('Buy Subscription') }}
                        </a>

                        <a href="#" class="inline-flex items-center justify-center px-6 py-3 border border-dark-blue/20 text-dark-blue font-medium text-sm rounded-md hover:bg-dark-blue/5 transition-colors duration-200 min-w-[140px]">
                            {{ __('View Plans') }}
                        </a>
                    </div>

                    {{-- Features Preview --}}
                    <div class="pt-6 mt-8 border-t border-dark-blue/10">
                        <p class="mb-4 text-sm text-dark-blue/60">{{ __('With a subscription, you get:') }}</p>
                        <div class="flex flex-wrap gap-4 justify-center text-xs text-dark-blue/70">
                            <div class="flex items-center">
                                <svg class="mr-1 w-4 h-4 text-green-500"
                                    fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                {{ __('Advanced Features') }}
                            </div>
                            <div class="flex items-center">
                                <svg class="mr-1 w-4 h-4 text-green-500"
                                    fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                {{ __('Priority Support') }}
                            </div>
                            <div class="flex items-center">
                                <svg class="mr-1 w-4 h-4 text-green-500"
                                    fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                {{ __('More Listings') }}
                            </div>
                        </div>
                    </div>
                </div>
            @else
                @php
                    $price = esp_currency_formated($subscriberPlan?->getPrice() ?? 0);
                @endphp
                {{-- Existing Subscription Content --}}
                <div class="w-full">
                    <div class="w-full max-w-full">
                        <div class="flex justify-between items-center">
                            <div>
                                <h4 class="text-base font-semibold leading-none text-dark-blue">{{ __('Current Package') }}</h4>
                                <p class="mt-2 text-sm text-dark-blue/70">{{ $subscriberPlan->package_title }}</p>
                            </div>
                            @if ($subscriberPlan?->getPrice() ?? (false || !$subscriberPlan?->preferred_payment_term ?? false))
                                <p class="text-base font-normal leading-none text-dark-blue">
                                    @if ($subscriberPlan->getPrice() ?? false)
                                        <span class="font-semibold">
                                            {{ $price }}
                                        </span>
                                    @endif
                                    @if ($subscriberPlan->preferred_payment_term)
                                        {{ __('/') }}
                                        {{ $subscriberPlan->preferred_payment_term }}
                                    @endif
                                </p>
                            @endif
                        </div>

                        {{-- Subscription Details --}}
                        <ul class="mt-5">
                            @if ($subscriberPlan->planModules->count() > 0)
                                @foreach ($subscriberPlan->planModules as $planModule)
                                    @if ($planModule->module_allow_listing == 1)
                                        <li class="flex justify-between items-center py-1 text-xs font-medium text-dark-blue">
                                            {{ Str::title($planModule->module_name) }} {{ 'Allowed :' }} <span class="font-normal text-dark-blue/[0.8] flex items-center">{{ $planModule->module_listing_limit }}</span></li>
                                    @endif
                                @endforeach
                            @endif
                            {{-- Auto Renewal --}}
                            <li class="flex justify-between items-center py-1 text-xs font-medium text-dark-blue"> {{ __('Auto Renewal :') }}
                                <span class="font-normal text-dark-blue/[0.8] flex items-center gap-2">
                                    <a href="#" class="flex items-center underline text-blue-1200">{{ __('Edit') }}</a>
                                    <span class="inline-flex px-2.5 items-center justify-center font-medium md:text-[11px] text-xs tracking-[-0.16px] h-[21px] rounded-md {{ $subscription->getRenewalStatus() ? 'text-green-1300 bg-green-1300/[0.1] border border-solid border-green-1300/[0.1]' : 'text-red-1300 bg-red-1300/[0.1] border border-solid border-red-1300/[0.1]' }}">
                                        @if ($subscription->getRenewalStatus())
                                            {{ __('Enabled') }}
                                        @else
                                            {{ __('Disabled') }}
                                        @endif
                                    </span>
                                </span>
                            </li>
                            {{-- @endif --}}
                            @if ($subscription->getSubscriptionDate())
                                <li class="flex justify-between items-center py-1 text-xs font-medium text-dark-blue"> {{ __('Subscription Date :') }}
                                    <span class="font-normal text-dark-blue/[0.8] flex items-center">
                                        {{ $subscription->getSubscriptionDate() }}
                                    </span>
                                </li>
                            @endif
                            @if ($subscription->getSubscriptionExpireDate())
                                <li class="flex justify-between items-center py-1 text-xs font-medium text-dark-blue"> {{ __('Expire On :') }}
                                    <span class="font-normal text-dark-blue/[0.8] flex items-center">
                                        {{ $subscription->getSubscriptionExpireDate() }}
                                    </span>
                                </li>
                            @endif
                            {{-- Next Renew On --}}
                            @if ($subscription->getRenewalStatus())
                                <li class="flex justify-between items-center py-1 text-xs font-medium text-dark-blue"> {{ __('Next Renew On :') }}
                                    <span class="font-normal text-dark-blue/[0.8] flex items-center">
                                        {{ $subscription->getSubscriptionExpireDate() }}
                                    </span>
                                </li>
                            @endif
                        </ul>

                        {{-- Upgrade/Downgrade Button --}}
                        <div class="pt-6 mt-6 border-t border-dark-blue/10">
                            @if ($subscriberPlan->membership_type === MembershipType::Featured)
                                <a href="#" class="inline-flex justify-center items-center px-6 py-3 w-full text-sm font-medium text-white rounded-md transition-colors duration-200 bg-blue-1200 hover:bg-blue-1200/90">
                                    <svg class="mr-2 w-4 h-4"
                                        fill="none"
                                        stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round"
                                            stroke-linejoin="round"
                                            stroke-width="2"
                                            d="M19 14l-7 7m0 0l-7-7m7 7V3"></path>
                                    </svg>
                                    {{ __('Downgrade Plan') }}
                                </a>
                            @else
                                <a href="#" class="inline-flex justify-center items-center px-6 py-3 w-full text-sm font-medium text-white rounded-md transition-colors duration-200 bg-blue-1200 hover:bg-blue-1200/90">
                                    <svg class="mr-2 w-4 h-4"
                                        fill="none"
                                        stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round"
                                            stroke-linejoin="round"
                                            stroke-width="2"
                                            d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
                                    </svg>
                                    {{ __('Upgrade Plan') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>

    {{-- JavaScript for handling URL parameter clearing --}}
    <script>
        document.addEventListener('livewire:initialized', function() {
            // Listen for clear-url-params event
            Livewire.on('clear-url-params', () => {
                // Clear URL parameters without page reload
                if (window.history && window.history.replaceState) {
                    const url = window.location.origin + window.location.pathname;
                    window.history.replaceState({}, document.title, url);
                }
            });
        });
    </script>
</div>
