<div>
    <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
        <h4 class="text-dark-blue font-semibold text-base leading-none mb-[18px]">{{ __('Transaction History') }}</h4>
        <div class="relative">
            <form>
                <div class="flex items-center justify-between xl:flex-row md:flex-col flex-row md:border border-0 border-solid border-dark-blue/[0.1] rounded-lg xl:p-4 md:p-2.5 p-0 md:gap-0 gap-3 md:mb-0 mb-[26px]">
                    <div class="block relative w-full md:hidden">
                        <input type="text"
                            wire:model="search"
                            class="bg-white w-full pl-[41px] border border-solid border-dark-blue/[0.1] rounded-lg h-10 text-gray-1500 placeholder:text-gray-1500 font-normal text-xs shadow-none focus:border-gray-1200 focus:ring-0"
                            placeholder="Search here" />
                        <a href="#" class="flex absolute left-5 top-1/2 justify-center items-center -translate-y-1/2">
                            <x-icon-search-icon2 />
                        </a>
                    </div>
                    <div class="hidden gap-2 items-center md:flex 2xl:gap-3">
                        <a href="#" class="flex items-center justify-center w-[30px] h-[30px]">
                            <x-icon-filter-icon />
                        </a>

                        @if ($activeTab == \App\Enums\PurchaseItemType::Subscription->value)
                            <select wire:model="memberPlan" class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[143px] xl:w-[130px] w-[120px] h-10 {{ $activeTab != \App\Enums\PurchaseItemType::Subscription->value ? 'none' : 'block' }}">
                                <option value="">{{ __('Select Package') }}</option>
                                @foreach ($memberPlans as $plan)
                                    <option value="{{ $plan->slug }}">{{ $plan->package_title }}</option>
                                @endforeach
                            </select>
                        @endif

                        <select wire:model.live="dateRange" class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[131px] w-[115px] h-10">
                            <option value="">{{ __('Select Date Range') }}</option>
                            <option value="7">{{ __('Last 7 days') }}</option>
                            <option value="14">{{ __('Last 14 days') }}</option>
                            <option value="30">{{ __('Last 30 days') }}</option>
                            <option value="45">{{ __('Last 45 days') }}</option>
                            <option value="60">{{ __('Last 60 days') }}</option>
                            <option value="90">{{ __('Last 90 days') }}</option>
                            <option value="180">{{ __('Last 180 days') }}</option>
                            <option value="365">{{ __('Last 365 days') }}</option>
                            <option value="custom">{{ __('Custom Date') }}</option>
                        </select>
                        @if ($dateRange === 'custom')
                            <div class="flex items-center gap-2 {{ $dateRange === 'custom' ? 'block' : 'hidden' }}">
                                <!-- Start Date -->
                                <div class="relative 2xl:w-[161px] w-[145px]">
                                    <span class="flex absolute left-3.5 top-1/2 items-center -translate-y-1/2">
                                        <x-icon-calendar-icon3 />
                                    </span>
                                    <input type="date"
                                        wire:model.live="startDate"
                                        id="startDateInput"
                                        class="text-dark-blue/[0.7] font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-10 pl-10"
                                        placeholder="Start Date" />
                                </div>

                                <!-- Date Range Separator -->
                                <span class="text-dark-blue/[0.7] font-normal text-xs">{{ __('to') }}</span>

                                <!-- End Date -->
                                <div class="relative 2xl:w-[161px] w-[145px]">
                                    <span class="flex absolute left-3.5 top-1/2 items-center -translate-y-1/2">
                                        <x-icon-calendar-icon3 />
                                    </span>
                                    <input type="date"
                                        wire:model.live="endDate"
                                        id="endDateInput"
                                        class="text-dark-blue/[0.7] font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-10 pl-10"
                                        placeholder="End Date" />
                                </div>
                            </div>
                        @endif
                    </div>
                    <div class="flex-1 mt-0 w-auto xl:w-auto md:w-full md:flex-auto xl:mt-0 md:mt-4">
                        <ul class="flex gap-2 justify-end items-center 2xl:gap-3">
                            <li class="hidden md:block">
                                <a wire:click="applyFilter" class="cursor-pointer text-white font-normal 2xl:text-xs text-[10px] rounded-lg h-10 2xl:w-[113px] w-[90px] bg-blue-1200 flex items-center justify-center">
                                    {{ __('Apply Filters') }}
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="advance-filter z-20 absolute left-0 xl:top-[74px] md:top-[120px] top-11  w-full rounded-b-lg border mt-[-5px] hidden border-solid border-dark-blue/[0.1] bg-white shadow-8xl p-4">
                    <h4 class="text-dark-blue/[0.7] font-medium text-xs leading-none mb-4">{{ __('More Filters') }}</h4>
                    <div class="flex flex-wrap gap-4 items-center mb-5 md:flex-nowrap md:gap-3 sm:gap-0 md:mb-2.5 md:mx-0 sm:-mx-1.5">
                        <div class="w-full md:w-auto sm:w-4/12 md:px-0 sm:px-1.5">
                            <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 md:w-[130px] w-full h-10">
                                <option>{{ __('Select option') }}</option>
                            </select>
                        </div>

                        <div class="px-0 w-full md:w-auto sm:w-4/12 md:px-0 sm:px-1.5">
                            <input type="date"
                                id="data-picker"
                                class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[183px] xl:w-[130px] md:w-[120px] w-full h-10"
                                placeholder="Another Field" />
                        </div>

                        <div class="px-0 w-full md:w-auto sm:w-4/12 md:px-0 sm:px-1.5">
                            <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[140px] xl:w-[130px] md:w-[120px] w-full h-10">
                                <option>{{ __('Select option 2') }}</option>
                            </select>
                        </div>
                        <div class="px-0 mt-3 w-full md:w-auto md:mt-0 md:px-0 sm:px-1.5">
                            <ul class="flex gap-4 items-center">
                                <li>
                                    <div class="flex items-center">
                                        <input id="default-radio-1"
                                            type="radio"
                                            value=""
                                            name="default-radio"
                                            class="w-4 h-4 cursor-pointer text-blue-600 bg-white border-[1.5px] border-solid border-dark-blue/[0.2] focus:ring-transparent focus:ring-0 ">
                                        <label for="default-radio-1" class="ms-3 text-sm cursor-pointer  font-normal text-dark-blue/[0.7] leading-none">{{ __('Option 1') }}</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center">
                                        <input id="default-radio-2"
                                            type="radio"
                                            value=""
                                            name="default-radio"
                                            class="w-4 h-4 cursor-pointer text-blue-600 bg-white border-[1.5px] border-solid border-dark-blue/[0.2] focus:ring-transparent focus:ring-0 ">
                                        <label for="default-radio-2" class="ms-3 text-sm cursor-pointer  font-normal text-dark-blue/[0.7] leading-none">{{ __('Option 1') }}</label>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="flex flex-col gap-3 items-center md:flex-row">
                        <div class="w-full md:w-auto">
                            <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 md:w-[130px] w-full h-10">
                                <option>{{ __('Select option') }}</option>
                            </select>
                        </div>
                        <div class="w-full md:w-auto">
                            <ul class="flex flex-wrap gap-4 items-center sm:flex-nowrap">
                                <li>
                                    <div class="flex items-center">
                                        <input id="checked-checkbox3"
                                            type="checkbox"
                                            value=""
                                            class="w-[18px] h-[18px] cursor-pointer text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="checked-checkbox3" class="2xl:ms-3 cursor-pointer ms-2 2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">{{ __('Check One') }}</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center">
                                        <input checked=""
                                            id="checked-checkbox4"
                                            type="checkbox"
                                            value=""
                                            class="w-[18px] cursor-pointer h-[18px] text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="checked-checkbox4" class="2xl:ms-3 ms-2 cursor-pointer  2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">{{ __('Check Two') }}</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center">
                                        <input id="checked-checkbox5"
                                            type="checkbox"
                                            value=""
                                            class="w-[18px] cursor-pointer h-[18px] text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="checked-checkbox5" class="2xl:ms-3 ms-2 cursor-pointer  2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">{{ __('Check Three') }}</label>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="flex gap-3 justify-end items-center mt-5">
                        <a href="#" class="filter-close text-blue-1200 hover:bg-blue-1200 hover:text-white border-2 border-solid border-blue-1200 font-normal text-sm leading-none flex items-center justify-center h-[34px] max-w-[78px] w-full rounded-lg">{{ __('Close') }}</a>
                        <a href="#" class="text-white border-2 hover:bg-transparent hover:text-black-1200 border-solid border-blue-1200 font-normal text-sm leading-none flex items-center justify-center h-[34px] max-w-[78px] w-full rounded-lg bg-blue-1200">{{ __('Apply') }}</a>
                    </div>
                </div>
            </form>
        </div>
        <div class="mb-[35px] mt-[18px] flex items-center justify-between border-b border-solid border-dark-blue/[0.1]">
            <ul class="flex flex-wrap text-center sm:gap-0 gap-[18px]"
                id="default-styled-tab"
                data-tabs-toggle="#default-styled-tab-content"
                data-tabs-active-classes="text-blue-1200 hover:text-blue-1200 border-blue-1200"
                data-tabs-inactive-classes="text-dark-blue hover:text-blue-1200 border-transparent hover:border-blue-1200"
                role="tablist">
                <li class="sm:me-2" role="presentation">
                    <button wire:click="switchTab('{{ \App\Enums\PurchaseItemType::Subscription->value }}')"
                        class="inline-block sm:px-10 py-1 border-b-[3px] font-medium text-sm {{ $activeTab == \App\Enums\PurchaseItemType::Subscription->value ? 'text-blue-1200 border-blue-1200' : 'text-dark-blue border-transparent' }}"
                        id="profile-styled-tab"
                        data-tabs-target="#styled-profile"
                        type="button"
                        role="tab"
                        aria-controls="profile"
                        aria-selected="false">{{ __('Subscription') }}</button>
                </li>
                <li class="sm:me-2" role="presentation">
                    <button wire:click="switchTab('{{ \App\Enums\PurchaseItemType::Credit->value }}')"
                        class="inline-block sm:px-10 py-1 border-b-[3px] font-medium text-sm {{ $activeTab == \App\Enums\PurchaseItemType::Credit->value ? 'text-blue-1200 border-blue-1200' : 'text-dark-blue border-transparent' }}"
                        id="dashboard-styled-tab"
                        data-tabs-target="#styled-dashboard"
                        type="button"
                        role="tab"
                        aria-controls="dashboard"
                        aria-selected="false">{{ __('Credits') }}</button>
                </li>
            </ul>
        </div>

        <div class="relative">
            <!-- Loading Overlay -->
            <div wire:loading.flex
                wire:target="switchTab,applyFilter,dateRange,memberPlan,search,startDate,endDate"
                class="flex absolute inset-0 z-10 justify-center items-center rounded-lg bg-white/80">
                <div class="flex flex-col gap-3 items-center">
                    <svg class="w-8 h-8 animate-spin text-blue-1200"
                        xmlns="http://www.w3.org/2000/svg"
                        fill="none"
                        viewBox="0 0 24 24">
                        <circle class="opacity-25"
                            cx="12"
                            cy="12"
                            r="10"
                            stroke="currentColor"
                            stroke-width="4"></circle>
                        <path class="opacity-75"
                            fill="currentColor"
                            d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                    </svg>
                    <span class="text-sm font-medium text-blue-1200">{{ __('Loading data...') }}</span>
                </div>
            </div>

            <!-- Table Content -->
            <div wire:loading.class="opacity-50" wire:target="switchTab,applyFilter,dateRange,memberPlan,search,startDate,endDate">
                {{ $this->table }}
            </div>
        </div>
    </div>
</div>
