@php
    use App\Enums\JobApplicationStatus;
    $statusCounts = $this->getAllStatusCounts();
@endphp
<div>
    <div class="relative">
        <x-filament::breadcrumbs :breadcrumbs="[
             '/' => 'Home',
            '/dashboard' => 'Dashboard',
            '/dashboard/applicants' => 'Applicants',
        ]" />
        <x-dashboard.common.loading-overlay-table />
        <x-dashboard.common.page-header>
            <x-slot name="title">{{ __('Applicants') }}</x-slot>
        </x-dashboard.common.page-header>
        
        <div class="flex md:flex-row flex-col-reverse md:items-center items-start justify-between md:pb-[18px] md:mb-0 mb-[26px]">
            <p class="text-dark-blue font-medium text-sm leading-none">{{ $this->getTotalCount() }} {{ __('Total Records') }}</p>
            <ul class="flex sm:flex-row flex-col sm:items-center items-start gap-3 md:mb-0 sm:mb-4 mb-[26px]">
                <li>
                    <a href="#" wire:click="clearStatusFilter()" class="flex items-center justify-center font-medium xl:text-sm sm:text-xs text-sm leading-none text-gray-600 border border-solid border-gray-300 bg-gray-100 h-[29px] rounded xl:px-[22px] sm:px-3 px-[22px] {{ !$status ? 'ring-2 ring-gray-400' : '' }}">
                        {{ __('All') }}
                    </a>
                </li>
                <li>
                    <a href="#" wire:click="filterByStatus('{{ JobApplicationStatus::Pending->value }}')" class="flex items-center justify-center font-medium xl:text-sm sm:text-xs text-sm leading-none text-purpal-1200 border border-solid border-purpal-1200/[0.2] bg-purpal-1200/[0.1] h-[29px] rounded xl:px-[22px] sm:px-3 px-[22px] ">
                        {{ __('Pending') }} ({{ $statusCounts[JobApplicationStatus::Pending->value] ?? 0 }})
                    </a>
                </li>
                <li>
                    <a href="#" wire:click="filterByStatus('{{ JobApplicationStatus::Hired->value }}')" class="flex items-center justify-center font-medium xl:text-sm sm:text-xs text-sm leading-none text-green-1300 border border-solid border-green-1300/[0.2] bg-green-1300/[0.1] h-[29px] rounded xl:px-[22px] sm:px-3 px-[22px]  ">
                        {{ __('Hired') }} ({{ $statusCounts[JobApplicationStatus::Hired->value] ?? 0 }})
                    </a>
                </li>
                <li>
                    <a href="#" wire:click="filterByStatus('{{ JobApplicationStatus::Shortlisted->value }}')" class="flex items-center justify-center font-medium xl:text-sm sm:text-xs text-sm leading-none text-orange-bg-1400 border border-solid border-orange-bg-1400/[0.2] bg-orange-bg-1400/[0.1] h-[29px] rounded xl:px-[22px] sm:px-3 px-[22px] ">
                        {{ __('Short Listed') }} ({{ $statusCounts[JobApplicationStatus::Shortlisted->value] ?? 0 }})
                    </a>
                </li>
                <li>
                    <a href="#" wire:click="filterByStatus('{{ JobApplicationStatus::Rejected->value }}')" class="flex items-center justify-center font-medium xl:text-sm sm:text-xs text-sm leading-none text-red-1200 border border-solid border-red-1300/[0.2] bg-red-1300/[0.1] h-[29px] rounded xl:px-[22px] sm:px-3 px-[22px] ">
                        {{ __('Rejected') }} ({{ $statusCounts[JobApplicationStatus::Rejected->value] ?? 0 }})
                    </a>
                </li>
                
            </ul>
        </div>
        {{ $this->table }}
    </div>
</div>
