<div class="p-6 space-y-6">
    <!-- Flash Messages -->
    @if (session()->has('success'))
        <div class="p-4 bg-green-50 rounded-md border border-green-200">
            <div class="flex">
                <div class="flex-shrink-0">
                    <x-heroicon-o-check-circle class="w-5 h-5 text-green-400" />
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-green-800">
                        {{ session('success') }}
                    </p>
                </div>
            </div>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="p-4 bg-red-50 rounded-md border border-red-200">
            <div class="flex">
                <div class="flex-shrink-0">
                    <x-heroicon-o-x-circle class="w-5 h-5 text-red-400" />
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-red-800">
                        {{ session('error') }}
                    </p>
                </div>
            </div>
        </div>
    @endif

    @if ($jobApplication)
        <!-- Header Section -->
        <div class="pb-4 border-b border-gray-200">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-4">
                    <h2 class="text-2xl font-bold text-gray-900">{{ __('Application Details') }}</h2>
                </div>
                <div class="flex items-center space-x-2">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                        @switch($jobApplication->application_status->value)
                            @case(\App\Enums\JobApplicationStatus::Pending->value)
                                bg-blue-50 text-blue-1300 border border-blue-1300
                                @break
                            @case(\App\Enums\JobApplicationStatus::Shortlisted->value)
                                bg-yellow-50 text-yellow-1300 border border-yellow-1300
                                @break
                            @case(\App\Enums\JobApplicationStatus::Hired->value)
                                bg-light-green-1200 text-green-1300 border border-green-1300
                                @break
                            @case(\App\Enums\JobApplicationStatus::Rejected->value)
                                bg-red-50 text-red-1300 border border-red-1300
                                @break
                        @endswitch
                    ">
                        @switch($jobApplication->application_status->value)
                            @case(\App\Enums\JobApplicationStatus::Pending->value)
                                <x-heroicon-o-paper-airplane class="mr-1 w-4 h-4" />
                            @break

                            @case(\App\Enums\JobApplicationStatus::Shortlisted->value)
                                <x-heroicon-o-list-bullet class="mr-1 w-4 h-4" />
                            @break

                            @case(\App\Enums\JobApplicationStatus::Hired->value)
                                <x-heroicon-o-check-circle class="mr-1 w-4 h-4" />
                            @break

                            @case(\App\Enums\JobApplicationStatus::Rejected->value)
                                <x-heroicon-o-x-circle class="mr-1 w-4 h-4" />
                            @break
                        @endswitch
                        {{ $jobApplication->application_status->getLabel() }}
                    </span>
                </div>
            </div>
            <div class="flex justify-between items-center mt-4">
                <p class="text-sm text-gray-500">{{ __('Applied on') }} {{ $jobApplication->created_at->format('F j, Y \a\t g:i A') }}</p>
                @if ($jobApplication->application_status->value == \App\Enums\JobApplicationStatus::Pending->value)
                    <div class="flex items-center space-x-3">
                        <button wire:click="updateStatus({{ $jobApplication->id }}, '{{ \App\Enums\JobApplicationStatus::Shortlisted->value }}')"
                            wire:confirm="{{ __('Are you sure you want to shortlist this application?') }}"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium bg-white rounded-md border border-yellow-300 shadow-sm transition-colors duration-200 text-yellow-1300 hover:bg-yellow-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                            <x-heroicon-o-list-bullet class="mr-2 w-4 h-4" />
                            {{ __('Shortlist') }}
                        </button>
                        <button wire:click="updateStatus({{ $jobApplication->id }}, '{{ \App\Enums\JobApplicationStatus::Rejected->value }}')"
                            wire:confirm="{{ __('Are you sure you want to reject this application?') }}"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-red-700 bg-white rounded-md border border-red-300 shadow-sm transition-colors duration-200 hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <x-heroicon-o-x-circle class="mr-2 w-4 h-4" />
                            {{ __('Reject') }}
                        </button>
                        <button wire:click="updateStatus({{ $jobApplication->id }}, '{{ \App\Enums\JobApplicationStatus::Hired->value }}')"
                            wire:confirm="{{ __('Are you sure you want to hire this applicant?') }}"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-green-700 bg-white rounded-md border border-green-300 shadow-sm transition-colors duration-200 hover:bg-green-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            <x-heroicon-o-check-circle class="mr-2 w-4 h-4" />
                            {{ __('Hire') }}
                        </button>
                    </div>
                @endif
                @if ($jobApplication->application_status->value == \App\Enums\JobApplicationStatus::Shortlisted->value)
                    <div class="flex items-center space-x-3">
                        <button wire:click="updateStatus({{ $jobApplication->id }}, '{{ \App\Enums\JobApplicationStatus::Rejected->value }}')"
                            wire:confirm="{{ __('Are you sure you want to reject this application?') }}"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-red-700 bg-white rounded-md border border-red-300 shadow-sm transition-colors duration-200 hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                            <x-heroicon-o-x-circle class="mr-2 w-4 h-4" />
                            {{ __('Reject') }}
                        </button>
                        <button wire:click="updateStatus({{ $jobApplication->id }}, '{{ \App\Enums\JobApplicationStatus::Hired->value }}')"
                            wire:confirm="{{ __('Are you sure you want to hire this applicant?') }}"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-green-700 bg-white rounded-md border border-green-300 shadow-sm transition-colors duration-200 hover:bg-green-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                            <x-heroicon-o-check-circle class="mr-2 w-4 h-4" />
                            {{ __('Hire') }}
                        </button>
                    </div>
                @endif
            </div>
            {{-- <div class="flex justify-end">
                    <button wire:click="back()" class="inline-flex items-center px-3 py-2 text-sm font-medium leading-4 text-gray-700 bg-white rounded-md border border-gray-300 shadow-sm transition-colors duration-200 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        <x-heroicon-o-arrow-left class="mr-2 w-4 h-4" />
                        {{ __('Back') }}
                    </button>
                </div> --}}
        </div>
        <div class="grid grid-cols-1 gap-8 lg:grid-cols-2">
            <!-- Applicant Details Section -->
            <div class="p-6 bg-white rounded-lg border border-gray-200">
                <div class="flex items-center mb-6 space-x-3">
                    <div class="flex-shrink-0">
                        @if ($jobApplication->applicant && method_exists($jobApplication->applicant, 'getFirstMediaUrl') && $jobApplication->applicant->getFirstMediaUrl('avatar', 'small'))
                            <img class="object-cover w-16 h-16 rounded-full"
                                src="{{ $jobApplication->applicant->getFirstMediaUrl('avatar', 'small') }}"
                                alt="{{ $jobApplication->applicant->name ?? 'Applicant' }}">
                        @else
                            <img class="object-cover w-16 h-16 rounded-full"
                                src="{{ $jobApplication->applicant->getFirstMediaUrl('logo', 'small') }}"
                                alt="{{ $jobApplication->applicant->name ?? 'Applicant' }}">
                        @endif
                    </div>
                    <div>
                        <h3 class="text-xl font-semibold text-gray-900">{{ $jobApplication->applicant->full_name ?? ($jobApplication->applicant->name ?? 'N/A') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Applicant') }}</p>
                    </div>
                </div>

                <div class="space-y-4">
                    <!-- Contact Information -->
                    <div>
                        <h4 class="mb-3 text-lg font-medium text-gray-900">{{ __('Contact Information') }}</h4>
                        <div class="space-y-2">
                            <div class="flex items-center text-sm text-gray-600">
                                <x-heroicon-o-envelope class="mr-2 w-4 h-4 text-gray-400" />
                                <span>{{ $jobApplication->applicant->email ?? 'N/A' }}</span>
                            </div>
                            @if ($jobApplication->applicant->profile->phone ?? false)
                                <div class="flex items-center text-sm text-gray-600">
                                    <x-heroicon-o-phone class="mr-2 w-4 h-4 text-gray-400" />
                                    <span>{{ $jobApplication->applicant?->profile?->phone ?? 'N/A' }}</span>
                                </div>
                            @endif
                            @if ($jobApplication->applicant->profile->mobile ?? false)
                                <div class="flex items-center text-sm text-gray-600">
                                    <x-heroicon-o-phone class="mr-2 w-4 h-4 text-gray-400" />
                                    <span>{{ $jobApplication->applicant?->profile?->mobile ?? 'N/A' }}</span>
                                </div>
                            @endif
                            {{-- @if ($jobApplication->applicant->address() ?? false)
                                <div class="flex items-center text-sm text-gray-600">
                                    <x-heroicon-o-map-pin class="mr-2 w-4 h-4 text-gray-400" />
                                    <span>{{ $jobApplication->applicant->address }}</span>
                                </div>
                            @endif --}}
                        </div>
                    </div>

                    <!-- Professional Information -->
                    @if (($jobApplication->applicant->bio ?? false) || ($jobApplication->applicant->experience_years ?? false))
                        <div>
                            <h4 class="mb-3 text-lg font-medium text-gray-900">{{ __('Professional Information') }}</h4>
                            <div class="space-y-2">
                                @if ($jobApplication->applicant->experience_years ?? false)
                                    <div class="flex items-center text-sm text-gray-600">
                                        <x-heroicon-o-briefcase class="mr-2 w-4 h-4 text-gray-400" />
                                        <span>{{ $jobApplication->applicant->experience_years }} {{ __('years of experience') }}</span>
                                    </div>
                                @endif
                                @if ($jobApplication->applicant->bio ?? false)
                                    <div class="mt-3">
                                        <p class="text-sm leading-relaxed text-gray-600">{{ $jobApplication->applicant->bio }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif

                    <!-- Application Status History -->
                    <div>
                        <h4 class="mb-3 text-lg font-medium text-gray-900">{{ __('Application Status') }}</h4>
                        <div class="p-4 bg-gray-50 rounded-lg">
                            <div class="flex justify-between items-center">
                                <div class="flex items-center space-x-2">
                                    <div
                                        class="w-3 h-3 rounded-full 
                                        @switch($jobApplication->application_status->value)
                                            @case(\App\Enums\JobApplicationStatus::Pending->value)
                                                bg-blue-1300
                                                @break
                                            @case(\App\Enums\JobApplicationStatus::Shortlisted->value)
                                                bg-yellow-1200
                                                @break
                                            @case(\App\Enums\JobApplicationStatus::Hired->value)
                                                bg-green-1500
                                                @break
                                            @case(\App\Enums\JobApplicationStatus::Rejected->value)
                                                bg-red-1500
                                                @break
                                        @endswitch
                                    ">
                                    </div>
                                    <span class="text-sm font-medium text-gray-900">{{ $jobApplication->application_status->getLabel() }}</span>
                                </div>
                                <span class="text-xs text-gray-500">{{ $jobApplication->updated_at->format('M j, Y') }}</span>
                            </div>
                            <p class="mt-1 ml-5 text-xs text-gray-500">{{ $jobApplication->application_status->getDescription() }}</p>
                        </div>

                    </div>
                </div>
                <div class="flex justify-center mt-6">
                    @if($jobApplication->hasMedia('resume'))
                        <button wire:click="downloadResume()"
                            class="inline-flex items-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 rounded-md border border-transparent shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            <x-heroicon-o-arrow-down-tray class="mr-2 w-4 h-4" />
                            {{ __('Download Resume') }}
                        </button>
                    @else
                        <span class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-400 bg-gray-100 rounded-md border border-gray-300">
                            <x-heroicon-o-document class="mr-2 w-4 h-4" />
                            {{ __('No Resume Uploaded') }}
                        </span>
                    @endif
                </div>

                <!-- Application Data Section -->
                @if($jobApplication->application_data)
                    <div class="mt-6">
                        <h4 class="mb-4 text-lg font-medium text-gray-900">{{ __('Application Details') }}</h4>
                        
                        <div class="space-y-4">
                            @php
                                $formConfig = config('job-application-form.sections', []);
                                $applicationData = $jobApplication->application_data ?? [];
                                
                                // Ensure application data is an array
                                if (!is_array($applicationData)) {
                                    $applicationData = [];
                                }
                            @endphp

                            @foreach($formConfig as $sectionKey => $section)
                                @if(is_array($section) && (isset($applicationData[$sectionKey]) || (isset($section['conditional_field']) && is_array($section['conditional_field']) && isset($applicationData[$section['conditional_field']['name']]))))
                                    <div class="p-3 bg-gray-50 rounded-lg">
                                        <h5 class="mb-2 text-sm font-medium text-gray-900">{{ __($section['label'] ?? ucfirst(str_replace('_', ' ', $sectionKey))) }}</h5>
                                        
                                        @switch($section['type'] ?? 'unknown')
                                            @case('radio_group')
                                            @case('radio')
                                                @if(isset($applicationData[$sectionKey]))
                                                    <div class="flex items-center space-x-2">
                                                        <div class="w-2 h-2 bg-blue-500 rounded-full"></div>
                                                        <span class="text-xs font-medium text-gray-900">
                                                            @if(isset($section['options']) && is_array($section['options']) && isset($section['options'][$applicationData[$sectionKey]]))
                                                                @if(is_array($section['options'][$applicationData[$sectionKey]]))
                                                                    {{ __($section['options'][$applicationData[$sectionKey]]['label']) }}
                                                                @else
                                                                    {{ __($section['options'][$applicationData[$sectionKey]]) }}
                                                                @endif
                                                            @else
                                                                {{ ucfirst(str_replace('_', ' ', $applicationData[$sectionKey])) }}
                                                            @endif
                                                        </span>
                                                    </div>
                                                    
                                                    @if(isset($section['conditional_field']) && is_array($section['conditional_field']) && $applicationData[$sectionKey] === $section['conditional_field']['condition'] && isset($applicationData[$section['conditional_field']['name']]))
                                                        <div class="mt-1 ml-4">
                                                            <span class="text-xs text-gray-600">
                                                                {{ __('Date') }}: {{ \Carbon\Carbon::parse($applicationData[$section['conditional_field']['name']])->format('F j, Y') }}
                                                            </span>
                                                        </div>
                                                    @endif
                                                @endif
                                                @break
                                                
                                            @case('platform_selector')
                                                @if(isset($applicationData['video_platform']))
                                                    <div class="space-y-2">
                                                        <div class="flex items-center space-x-2">
                                                            <div class="w-2 h-2 bg-purple-500 rounded-full"></div>
                                                            <span class="text-xs font-medium text-gray-900">
                                                                {{ __('Platform') }}: {{ ucfirst($applicationData['video_platform']) }}
                                                            </span>
                                                        </div>
                                                        @if(isset($applicationData['video_url']))
                                                            <div class="mt-2">
                                                                <a href="{{ $applicationData['video_url'] }}" 
                                                                   target="_blank"
                                                                   class="inline-flex items-center px-2 py-1 text-xs font-medium text-blue-700 bg-blue-100 rounded-full hover:bg-blue-200">
                                                                    <x-heroicon-o-play class="mr-1 w-3 h-3" />
                                                                    {{ __('Watch Video') }}
                                                                </a>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                                @break
                                                
                                            @case('rich_text')
                                                @if(isset($applicationData[$sectionKey]))
                                                    <div class="max-w-none text-xs text-gray-700 prose prose-sm">
                                                        {!! $applicationData[$sectionKey] !!}
                                                    </div>
                                                @endif
                                                @break
                                                
                                            @case('file')
                                                @if($sectionKey === 'resume')
                                                    <div class="flex items-center space-x-2">
                                                        @if($jobApplication->hasMedia('resume'))
                                                            <x-heroicon-o-document class="w-4 h-4 text-green-600" />
                                                            <span class="text-xs text-green-700 font-medium">{{ __('Resume uploaded') }}</span>
                                                        @else
                                                            <x-heroicon-o-document class="w-4 h-4 text-gray-400" />
                                                            <span class="text-xs text-gray-500">{{ __('No resume uploaded') }}</span>
                                                        @endif
                                                    </div>
                                                @endif
                                                @break
                                                
                                            @default
                                                @if(isset($applicationData[$sectionKey]))
                                                    <div class="text-xs text-gray-700">
                                                        {{ $applicationData[$sectionKey] }}
                                                    </div>
                                                @endif
                                        @endswitch
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            <!-- Job Details Section -->
            <div class="p-6 bg-white rounded-lg border border-gray-200">
                <div class="mb-6">
                    <h3 class="mb-2 text-xl font-semibold text-gray-900">{{ $jobApplication->job->job_title ?? __('N/A') }}</h3>
                    <div class="flex items-center space-x-4 text-sm text-gray-500">
                        @if ($jobApplication->job->job_industry ?? false)
                            <span>{{ $jobApplication->job->job_industry->industry_name }}</span>
                        @endif
                        @if ($jobApplication->job->job_role ?? false)
                            <span>{{ __('•') }}</span>
                            <span>{{ $jobApplication->job->job_role->job_role_name }}</span>
                        @endif
                    </div>
                </div>

                <div class="space-y-4">
                    <!-- Job Overview -->
                    <div>
                        <h4 class="mb-3 text-lg font-medium text-gray-900">{{ __('Job Overview') }}</h4>
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                            @if ($jobApplication->job->job_type ?? false)
                                <div class="flex items-center text-sm">
                                    <span class="w-20 font-medium text-gray-500">{{ __('Type') }}:</span>
                                    <span class="text-gray-900">{{ $jobApplication->job->job_type->job_type_name }}</span>
                                </div>
                            @endif
                            @if ($jobApplication->job->work_mode ?? false)
                                <div class="flex items-center text-sm">
                                    <span class="w-20 font-medium text-gray-500">{{ __('Mode') }}:</span>
                                    <span class="text-gray-900">{{ $jobApplication->job->work_mode->getLabel() }}</span>
                                </div>
                            @endif
                            @if ($jobApplication->job->job_career_level ?? false)
                                <div class="flex items-center text-sm">
                                    <span class="w-20 font-medium text-gray-500">{{ __('Level') }}:</span>
                                    <span class="text-gray-900">{{ $jobApplication->job->job_career_level->career_level_name }}</span>
                                </div>
                            @endif
                            @if ($jobApplication->job->available_positions ?? false)
                                <div class="flex items-center text-sm">
                                    <span class="w-20 font-medium text-gray-500">{{ __('Positions') }}:</span>
                                    <span class="text-gray-900">{{ $jobApplication->job->available_positions }}</span>
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Salary Information -->
                    @if (($jobApplication->job->min_salary ?? false) || ($jobApplication->job->max_salary ?? false))
                        <div>
                            <h4 class="mb-3 text-lg font-medium text-gray-900">Salary Information</h4>
                            <div class="p-4 bg-green-50 rounded-lg">
                                <div class="flex items-center space-x-2">
                                    <x-heroicon-o-currency-dollar class="w-5 h-5 text-green-600" />
                                    <span class="text-lg font-semibold text-green-800">
                                        @if ($jobApplication->job->currency ?? false)
                                            {{ $jobApplication->job->currency->symbol }}
                                        @endif
                                        @if (($jobApplication->job->min_salary ?? false) && ($jobApplication->job->max_salary ?? false))
                                            {{ number_format($jobApplication->job->min_salary) }} - {{ number_format($jobApplication->job->max_salary) }}
                                        @elseif($jobApplication->job->min_salary ?? false)
                                            {{ number_format($jobApplication->job->min_salary) }}+
                                        @elseif($jobApplication->job->max_salary ?? false)
                                            {{ __('Up to') }} {{ number_format($jobApplication->job->max_salary) }}
                                        @endif
                                        @if ($jobApplication->job->salary_period ?? false)
                                            {{ __('/') }} {{ $jobApplication->job->salary_period->getLabel() }}
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Location -->
                    @if ($jobApplication->job->address() ?? false)
                        <div>
                            <h4 class="mb-3 text-lg font-medium text-gray-900">Location</h4>
                            <div class="flex items-center text-sm text-gray-600">
                                <x-heroicon-o-map-pin class="mr-2 w-4 h-4 text-gray-400" />
                                <span>{{ $jobApplication->job->address() }}</span>
                            </div>
                        </div>
                    @endif

                    <!-- Application Deadline -->
                    @if ($jobApplication->job->apply_by_date ?? false)
                        <div>
                            <h4 class="mb-3 text-lg font-medium text-gray-900">{{ __('Application Deadline') }}</h4>
                            <div class="flex items-center text-sm text-gray-600">
                                <x-heroicon-o-calendar class="mr-2 w-4 h-4 text-gray-400" />
                                <span>{{ $jobApplication->job->apply_by_date->format('F j, Y') }}</span>
                                @if ($jobApplication->job->apply_by_date->isPast())
                                    <span class="ml-2 text-red-600">({{ __('Expired') }})</span>
                                @endif
                            </div>
                        </div>
                    @endif

                    <!-- Job Description -->
                    @if ($jobApplication->job->job_description ?? false)
                        <div>
                            <h4 class="mb-3 text-lg font-medium text-gray-900">Job Description</h4>
                            <div class="max-w-none text-gray-600 prose prose-sm">
                                {!! nl2br(e($jobApplication->job->job_description)) !!}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @else
        <div class="py-12 text-center">
            <x-heroicon-o-exclamation-triangle class="mx-auto w-12 h-12 text-gray-400" />
            <h3 class="mt-4 text-lg font-medium text-gray-900">{{ __('Application not found') }}</h3>
            <p class="mt-2 text-sm text-gray-500">{{ __('The requested job application could not be found.') }}</p>
        </div>
    @endif
</div>
