<div>
    {{-- Page Header --}}
    <x-dashboard.common.page-header :title="__('Purchase Credits')">
        <x-slot name="button">
            <button wire:navigate
                href="{{ route('dashboard.account-subscription') }}"
                class="inline-flex items-center px-4 py-2 bg-gray-100 rounded-md transition-colors dark:bg-gray-700 text-dark-blue dark:text-white hover:bg-gray-200 dark:hover:bg-gray-600">
                <svg class="mr-2 w-4 h-4"
                    fill="none"
                    stroke="currentColor"
                    viewBox="0 0 24 24">
                    <path stroke-linecap="round"
                        stroke-linejoin="round"
                        stroke-width="2"
                        d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                {{ __('Back') }}
            </button>
        </x-slot>
        <x-slot name="subtitle">
            {{ __('Add credits to your account to access premium features') }}
        </x-slot>
    </x-dashboard.common.page-header>

    {{-- Main Content --}}
    <div class="grid gap-6 lg:grid-cols-3">
        {{-- Credit Selection --}}
        <div class="lg:col-span-2">
            <div class="bg-white dark:bg-gray-800 rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px] mb-[35px]">
                <h2 class="mb-6 text-xl font-semibold text-dark-blue dark:text-white">{{ __('Select Credits') }}</h2>

                {{-- Quick Select Tiers --}}
                @if (!empty($pricingTiers))
                    <div class="mb-8">
                        <h3 class="mb-4 text-lg font-medium text-dark-blue dark:text-white">{{ __('Popular Credit Packages') }}</h3>
                        <div class="grid gap-4 md:grid-cols-2">
                            @foreach ($pricingTiers as $tier)
                                <div class="relative border-2 {{ $quantity == $tier['quantity'] ? 'border-blue-1200 bg-blue-50 dark:bg-blue-900/20' : 'border-gray-200 dark:border-gray-600' }} rounded-lg p-4 cursor-pointer hover:border-blue-1200 dark:hover:border-blue-400 transition-colors" wire:click="selectPricingTier({{ $tier['quantity'] }})">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <h4 class="font-semibold text-dark-blue dark:text-white">{{ $tier['quantity'] }} {{ __('Credits') }}</h4>
                                            <p class="text-sm text-gray-600 dark:text-gray-400">{{ esp_currency_formated($tier['price_per_credit']) }} {{ __('per credit') }}</p>
                                        </div>
                                        <div class="text-right">
                                            <p class="text-lg font-bold text-dark-blue dark:text-white">{{ esp_currency_formated($tier['total_price']) }}</p>
                                            @if ($tier['discount_percentage'] > 0)
                                                <p class="text-sm text-green-600 dark:text-green-400">{{ $tier['discount_percentage'] }}% {{ __('off') }}</p>
                                            @endif
                                        </div>
                                    </div>
                                    @if ($tier['savings'] > 0)
                                        <div class="text-sm text-green-600 dark:text-green-400">
                                            {{ __('Save') }} {{ esp_currency_formated($tier['savings']) }}
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                {{-- Custom Quantity --}}
                <div class="mb-6">
                    <label for="quantity" class="block mb-2 text-sm font-medium text-dark-blue dark:text-white">
                        {{ __('Custom Quantity') }}
                    </label>
                    <div class="flex items-center space-x-4">
                        <button type="button"
                            wire:click="$set('quantity', {{ max(1, $quantity - 1) }})"
                            class="flex justify-center items-center w-10 h-10 bg-white rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-dark-blue dark:text-white hover:bg-gray-50 dark:hover:bg-gray-600">
                            <svg class="w-4 h-4"
                                fill="none"
                                stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M20 12H4"></path>
                            </svg>
                        </button>
                        <input type="number"
                            id="quantity"
                            wire:model.live="quantity"
                            min="1"
                            max="{{ get_max_credits_per_purchase() }}"
                            class="flex-1 max-w-[120px] px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-dark-blue dark:text-white focus:ring-2 focus:ring-blue-1200 focus:border-transparent">
                        <button type="button"
                            wire:click="$set('quantity', {{ $quantity + 1 }})"
                            class="flex justify-center items-center w-10 h-10 bg-white rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-dark-blue dark:text-white hover:bg-gray-50 dark:hover:bg-gray-600">
                            <svg class="w-4 h-4"
                                fill="none"
                                stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round"
                                    stroke-linejoin="round"
                                    stroke-width="2"
                                    d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                        </button>
                    </div>
                    <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">
                        {{ __('Min: :min, Max: :max credits', ['min' => get_min_credits_per_purchase(), 'max' => get_max_credits_per_purchase()]) }}
                    </p>
                </div>

                {{-- Payment Method Selection --}}
                @if (!empty($availablePaymentMethods))
                    <div class="mb-6">
                        <h3 class="mb-4 text-lg font-medium text-dark-blue dark:text-white">{{ __('Payment Method') }}</h3>
                        <div class="space-y-3">
                            @foreach ($availablePaymentMethods as $method)
                                <label class="flex items-center p-4 border-2 {{ $selectedPaymentMethod == $method['id'] ? 'border-blue-1200 bg-blue-50 dark:bg-blue-900/20' : 'border-gray-200 dark:border-gray-600' }} rounded-lg cursor-pointer hover:border-blue-1200 dark:hover:border-blue-400 transition-colors">
                                    <input type="radio"
                                        wire:model.live="selectedPaymentMethod"
                                        value="{{ $method['id'] }}"
                                        class="w-4 h-4 bg-gray-100 border-gray-300 text-blue-1200 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                                    <div class="flex-1 ml-3">
                                        <div class="flex items-center">
                                            <span class="font-medium text-dark-blue dark:text-white">{{ $method['name'] }}</span>
                                        </div>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">{{ __('Secure payment processing') }}</p>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>

        {{-- Order Summary --}}
        <div class="lg:col-span-1">
            <div class="bg-white dark:bg-gray-800 rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px] sticky top-6">
                <h2 class="mb-6 text-xl font-semibold text-dark-blue dark:text-white">{{ __('Order Summary') }}</h2>

                @if (!empty($pricingDetails))
                    <div class="mb-6 space-y-4">
                        <div class="flex justify-between">
                            <span class="text-dark-blue/70 dark:text-gray-300">{{ __('Credits') }}</span>
                            <span class="font-medium text-dark-blue dark:text-white">{{ number_format($quantity) }}</span>
                        </div>

                        <div class="flex justify-between">
                            <span class="text-dark-blue/70 dark:text-gray-300">{{ __('Price per credit') }}</span>
                            <span class="font-medium text-dark-blue dark:text-white">{{ esp_currency_formated($pricingDetails['base_price'] ?? 0) }}</span>
                        </div>

                        <div class="flex justify-between">
                            <span class="text-dark-blue/70 dark:text-gray-300">{{ __('Subtotal') }}</span>
                            <span class="font-medium text-dark-blue dark:text-white">{{ esp_currency_formated($pricingDetails['subtotal'] ?? 0) }}</span>
                        </div>

                        @if (($pricingDetails['discount_percentage'] ?? 0) > 0)
                            <div class="flex justify-between text-green-600 dark:text-green-400">
                                <span>{{ __('Discount') }} ({{ $pricingDetails['discount_percentage'] }}%)</span>
                                <span>-{{ esp_currency_formated($pricingDetails['discount_amount'] ?? 0) }}</span>
                            </div>
                        @endif

                        @if (get_payment_tax_rate() > 0)
                            <div class="flex justify-between">
                                <span class="text-dark-blue/70 dark:text-gray-300">{{ __('Tax') }} ({{ get_payment_tax_rate() }}%)</span>
                                <span class="font-medium text-dark-blue dark:text-white">{{ esp_currency_formated(($pricingDetails['subtotal'] ?? 0) * (get_payment_tax_rate() / 100)) }}</span>
                            </div>
                        @endif

                        <hr class="border-gray-200 dark:border-gray-600">

                        <div class="flex justify-between text-lg font-bold">
                            <span class="text-dark-blue dark:text-white">{{ __('Total') }}</span>
                            <span class="text-dark-blue dark:text-white">{{ esp_currency_formated($pricingDetails['total'] ?? 0) }}</span>
                        </div>
                    </div>
                @endif

                {{-- Purchase Button --}}
                <button type="button"
                    wire:click="processPayment"
                    @if ($isProcessing) disabled @endif
                    class="flex justify-center items-center px-4 py-3 w-full font-medium text-white rounded-md transition-colors duration-200 bg-blue-1200 hover:bg-blue-1200/90 disabled:opacity-50 disabled:cursor-not-allowed">
                    @if ($isProcessing)
                        <svg class="mr-3 -ml-1 w-5 h-5 text-white animate-spin"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 24 24">
                            <circle class="opacity-25"
                                cx="12"
                                cy="12"
                                r="10"
                                stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75"
                                fill="currentColor"
                                d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        {{ __('Processing...') }}
                    @else
                        {{ __('Purchase Credits') }}
                    @endif
                </button>

                {{-- Security Note --}}
                <div class="p-3 mt-4 bg-gray-50 rounded-md dark:bg-gray-700">
                    <div class="flex items-center">
                        <svg class="mr-2 w-4 h-4 text-green-500"
                            fill="currentColor"
                            viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z"
                                clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-xs text-gray-600 dark:text-gray-300">{{ __('Secure SSL encrypted payment') }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
