<div>
    <div class="">
        <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
            Dashboard
        </h4>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
            <div class="relative flex flex-col items-center gap-8 sm:flex-row">

                <span class="absolute sm:right-0 -right-2.5 -top-2.5 sm:top-0 font-medium sm:text-sm text-xs leading-none {{ $user->profile?->status === \App\Enums\UserProfileStatus::Active ? 'text-green-1200 border-green-1200/[0.2] bg-green-1200/[0.1]' : 'text-yellow-1200 border-yellow-1200/[0.2] bg-yellow-1200/[0.1]' }} border border-solid h-[29px] sm:w-[90px] w-[70px] flex items-center justify-center rounded">
                    {{ $user->profile?->status?->getLabel() }}
                </span>
                <div class="relative inline-flex items-center">
                    <img src="{{ $user->getFirstMediaUrl('avatar', 'medium') }}" alt="{{ $user->name }}" class="object-cover w-24 h-24 rounded-full" />
                    <span class="absolute flex items-center justify-center w-5 h-5 border-4 border-white border-solid rounded-full bg-blue-1200 right-1 bottom-1"></span>
                </div>
                <div class="relative flex-1 w-full">
                    <h4 class="font-medium text-xl tracking-[0.3px] leading-none text-dark-blue">
                        {{ $user->name }}
                    </h4>
                    <sap class="flex items-center font-normal my-2.5 text-sm tracking-0.7 text-blue-1200">Senior Product Designer</sap>
                    {{-- <p class="flex items-center font-medium text-sm text-red-1200 gap-1 bg-light-red-1200 rounded-lg max-w-[207px] w-full h-[29px] justify-center">
                        <img src="{{ asset('images/dashboard/images/clock.svg') }}" alt="" /> Trial Expires in 02
                        Days,
                    </p> --}}
                </div>
            </div>
            <div class="border border-solid border-dark-blue/[0.1] rounded-[10px] sm:p-5 sm:pr-10 p-4 mt-6">
                <h4 class="font-medium text-lg mb-3.5 text-dark-blue tracking-default leading-none">
                    {{ __('Your Profile Progress') }}
                </h4>
                <p class="font-normal text-sm sm:leading-none leading-normal tracking-0.24 text-dark-blue/[0.6]">
                    {{ __('Complete your profile to impress recruiters') }}
                </p>
                <div class="flex items-center gap-4 mt-6">
                    <div class="w-full bg-blue-1200/[0.1] h-2.5 rounded-md">
                        <div class="bg-blue-1200 h-2.5 rounded-md" style="width: 45%"></div>
                    </div>
                    <span class="flex items-center flex-1 text-xl font-semibold leading-none text-dark-blue">40%</span>
                </div>
            </div>
            <ul class="flex sm:flex-row flex-col items-center gap-5 mt-[26px]">
                <li class="w-full sm:w-auto">
                    <a href="#" class="sm:w-[227px] w-full font-semibold text-sm text-white border-2 border-solid border-blue-1200 bg-blue-1200 hover:bg-transparent hover:text-blue-1200 flex items-center justify-center rounded-md h-11">{{ __('Complete your profile now') }}</a>
                </li>
                <li class="w-full sm:w-auto">
                    <a href="{{ route('dashboard.profile.basic') }}" class="sm:w-[199px] w-full font-semibold text-sm text-blue-1200 border-2 border-solid border-blue-1200 hover:bg-blue-1200 hover:text-white flex items-center justify-center rounded-md h-11">{{ __('Edit your profile') }}</a>
                </li>

                <li class="w-full sm:w-auto">
                    <a href="{{ route('member.show', ['slug' => $user->slug]) }}" target="_blank" class="sm:w-[199px] w-full font-semibold text-sm text-blue-1200 border-2 border-solid border-blue-1200 hover:bg-blue-1200 hover:text-white flex items-center justify-center rounded-md h-11">{{ __('View public profile') }}</a>
                </li>
            </ul>
        </div>
        <div class="grid grid-cols-1 gap-4 mt-5 md:grid-cols-3 sm:grid-cols-2 xl:gap-8 md:mt-8">
            <div class="bg-white flex items-start justify-between rounded-[14px] bg-whitep xl:p-[30px] p-4">
                <div class="">
                    <span class="flex items-center leading-none font-medium xl:text-base text-sm text-dark-blue/[0.6]">Total User</span>
                    <h4 class="flex xl:mt-4 mt-3 mb-5 items-center leading-none font-bold xl:text-[28px] text-2xl tracking-1 text-dark-blue">
                        40,689
                    </h4>
                    <span class="font-semibold mb-2  xl:text-base text-sm leading-none flex items-center gap-2.5"><img src="{{ asset('images/dashboard/images/ic-trending.svg') }}" /> 8.5%
                    </span>
                    <p class="font-normal xl:text-base text-sm leading-none text-dark-blue/[0.7]">
                        Up from yesterday
                    </p>
                </div>
                <div class="bg-blue-1300/[0.21] xl:w-[60px] w-12 xl:h-[60px] h-12 xl:rounded-3xl rounded-[10px] flex items-center justify-center">
                    <img src="{{ asset('images/dashboard/images/user-shape.svg') }}" alt="" />
                </div>
            </div>
            <div class="bg-white flex items-start justify-between rounded-[14px] bg-whitep xl:p-[30px] p-4">
                <div class="">
                    <span class="flex items-center leading-none font-medium xl:text-base text-sm text-dark-blue/[0.6]">Total User</span>
                    <h4 class="flex xl:mt-4 mt-3 mb-5 items-center leading-none font-bold xl:text-[28px] text-2xl tracking-1 text-dark-blue">
                        40,689
                    </h4>
                    <span class="font-semibold mb-2  xl:text-base text-sm leading-none flex items-center gap-2.5"><img src="{{ asset('images/dashboard/images/ic-trending.svg') }}" /> 8.5%
                    </span>
                    <p class="font-normal xl:text-base text-sm leading-none text-dark-blue/[0.7]">
                        Up from yesterday
                    </p>
                </div>
                <div class="bg-blue-1300/[0.21] xl:w-[60px] w-12 xl:h-[60px] h-12 xl:rounded-3xl rounded-[10px] flex items-center justify-center">
                    <img src="{{ asset('images/dashboard/images/user-shape.svg') }}" alt="" />
                </div>
            </div>
            <div class="bg-white flex items-start justify-between rounded-[14px] bg-whitep xl:p-[30px] p-4">
                <div class="">
                    <span class="flex items-center leading-none font-medium xl:text-base text-sm text-dark-blue/[0.6]">Total User</span>
                    <h4 class="flex xl:mt-4 mt-3 mb-5 items-center leading-none font-bold xl:text-[28px] text-2xl tracking-1 text-dark-blue">
                        40,689
                    </h4>
                    <span class="font-semibold mb-2  xl:text-base text-sm leading-none flex items-center gap-2.5"><img src="{{ asset('images/dashboard/images/ic-trending.svg') }}" /> 8.5%
                    </span>
                    <p class="font-normal xl:text-base text-sm leading-none text-dark-blue/[0.7]">
                        Up from yesterday
                    </p>
                </div>
                <div class="bg-orange-bg-1200/[0.21] xl:w-[60px] w-12 xl:h-[60px] h-12 xl:rounded-3xl rounded-[10px] flex items-center justify-center">
                    <img src="{{ asset('images/dashboard/images/order-box.svg') }}" alt="" />
                </div>
            </div>
            <div class="bg-white flex items-start justify-between rounded-[14px] bg-whitep xl:p-[30px] p-4">
                <div class="">
                    <span class="flex items-center leading-none font-medium xl:text-base text-sm text-dark-blue/[0.6]">Total User</span>
                    <h4 class="flex xl:mt-4 mt-3 mb-5 items-center leading-none font-bold xl:text-[28px] text-2xl tracking-1 text-dark-blue">
                        40,689
                    </h4>
                    <span class="font-semibold mb-2  xl:text-base text-sm leading-none flex items-center gap-2.5"><img src="{{ asset('images/dashboard/images/ic-trending.svg') }}" /> 8.5%
                    </span>
                    <p class="font-normal xl:text-base text-sm leading-none text-dark-blue/[0.7]">
                        Up from yesterday
                    </p>
                </div>
                <div class="bg-orange-bg-1200/[0.21] xl:w-[60px] w-12 xl:h-[60px] h-12 xl:rounded-3xl rounded-[10px] flex items-center justify-center">
                    <img src="{{ asset('images/dashboard/images/order-box.svg') }}" alt="" />
                </div>
            </div>
            <div class="bg-white flex items-start justify-between rounded-[14px] bg-whitep xl:p-[30px] p-4">
                <div class="">
                    <span class="flex items-center leading-none font-medium xl:text-base text-sm text-dark-blue/[0.6]">Total User</span>
                    <h4 class="flex xl:mt-4 mt-3 mb-5 items-center leading-none font-bold xl:text-[28px] text-2xl tracking-1 text-dark-blue">
                        40,689
                    </h4>
                    <span class="font-semibold mb-2  xl:text-base text-sm leading-none flex items-center gap-2.5"><img src="{{ asset('images/dashboard/images/ic-trending.svg') }}" /> 8.5%
                    </span>
                    <p class="font-normal xl:text-base text-sm leading-none text-dark-blue/[0.7]">
                        Up from yesterday
                    </p>
                </div>
                <div class="bg-orange-bg-1200/[0.21] xl:w-[60px] w-12 xl:h-[60px] h-12 xl:rounded-3xl rounded-[10px] flex items-center justify-center">
                    <img src="{{ asset('images/dashboard/images/order-box.svg') }}" alt="" />
                </div>
            </div>
        </div>
        <div class="grid grid-cols-1 gap-4 mt-5 md:grid-cols-2 md:gap-8 md:mt-8">
            <div class="p-5 bg-white rounded-14 xl:p-8">
                <div class="flex items-center justify-between mb-5 xl:mb-8">
                    <h3 class="font-medium tracking-[0.32px] xl:text-22 text-lg leading-none text-dark-blue">
                        Latest Inquiries
                    </h3>
                    <a href="#" class="text-sm font-semibold leading-none underline text-blue-1200">View All</a>
                </div>
                <div class="cursor-pointer border border-solid boredr-dark-blue/[0.10] hover:border-blue-1200 rounded-14 xl:p-[30px] p-4 mb-28">
                    <div class="flex items-start justify-between mb-[19px]">
                        <div class="">
                            <h4 class="text-dark-blue mb-3 font-semibold xl:text-lg text-baseracking-0.06 leading-none">
                                Jason Price
                            </h4>
                            <span class="text-dark-blue/[0.7] font-normal xl:text-sm text-xs leading-none w-full block">jasonprice@waterwells.com</span>
                        </div>
                        <span class="font-normal text-xs leading-none block text-dark-blue/[0.7]">2 hours ago</span>
                    </div>
                    <p class="mb-6 text-sm font-normal leading-normal text-dark-blue">
                        Seeking excavation services for a residential site. Could
                        you provide cost estimates and availability?
                    </p>
                    <a href="#" class="flex items-center text-sm font-semibold leading-none underline text-blue-1200">View Details</a>
                    </ul>
                </div>
                <div class="cursor-pointer border border-solid boredr-dark-blue/[0.10] hover:border-blue-1200 rounded-14 xl:p-[30px] p-4 mb-28">
                    <div class="flex items-start justify-between mb-[19px]">
                        <div class="">
                            <h4 class="text-dark-blue mb-3 font-semibold xl:text-lg text-baseracking-0.06 leading-none">
                                Jason Price
                            </h4>
                            <span class="text-dark-blue/[0.7] font-normal xl:text-sm text-xs leading-none w-full block">jasonprice@waterwells.com</span>
                        </div>
                        <span class="font-normal text-xs leading-none block text-dark-blue/[0.7]">2 hours ago</span>
                    </div>
                    <p class="mb-6 text-sm font-normal leading-normal text-dark-blue">
                        Seeking excavation services for a residential site. Could
                        you provide cost estimates and availability?
                    </p>
                    <a href="#" class="flex items-center text-sm font-semibold leading-none underline text-blue-1200">View Details</a>
                    </ul>
                </div>
                <div class="cursor-pointer border border-solid boredr-dark-blue/[0.10] hover:border-blue-1200 rounded-14 xl:p-[30px] p-4">
                    <div class="flex items-start justify-between mb-[19px]">
                        <div class="">
                            <h4 class="text-dark-blue mb-3 font-semibold xl:text-lg text-baseracking-0.06 leading-none">
                                Jason Price
                            </h4>
                            <span class="text-dark-blue/[0.7] font-normal xl:text-sm text-xs leading-none w-full block">jasonprice@waterwells.com</span>
                        </div>
                        <span class="font-normal text-xs leading-none block text-dark-blue/[0.7]">2 hours ago</span>
                    </div>
                    <p class="mb-6 text-sm font-normal leading-normal text-dark-blue">
                        Seeking excavation services for a residential site. Could
                        you provide cost estimates and availability?
                    </p>
                    <a href="#" class="flex items-center text-sm font-semibold leading-none underline text-blue-1200">View Details</a>
                    </ul>
                </div>
            </div>
            <div class="p-5 bg-white rounded-14 xl:p-8">
                <div class="flex items-center justify-between mb-5 xl:mb-8">
                    <h3 class="font-medium  xl:text-22 text-lg tracking-[0.32px] leading-none text-dark-blue">
                        Latest Reviews
                    </h3>
                    <a href="#" class="text-sm font-semibold leading-none underline text-blue-1200">View All</a>
                </div>
                <div class="border border-solid boredr-dark-blue/[0.10] rounded-14 xl:p-8 p-4 mb-28">
                    <div class="flex items-start justify-between mb-3">
                        <div class="flex items-center gap-3.5">
                            <div class="flex items-center">
                                <img src="{{ asset('images/dashboard/images/ratting-user-img.png') }}" alt="" />
                            </div>
                            <div class="">
                                <h4 class="text-dark-blue mb-1.5 font-bold text-base leading-none">
                                    John Doe
                                </h4>
                                <ul class="flex items-center gap-1">
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                </ul>
                            </div>
                        </div>
                        <span class="font-normal text-xs leading-none block text-dark-blue/[0.7]">Octobar 15, 2024</span>
                    </div>
                    <p class="text-xs font-normal leading-4 xl:leading-normal text-dark-blue">
                        I had the pleasure of working with Integra Water Systems,
                        and I must say, they offer exceptional service. Jason and
                        his team are true experts in the field. They efficiently
                        solved our water well problems, and their professionalism
                        stood out. I highly recommend their services.
                    </p>
                </div>
                <div class="border border-solid boredr-dark-blue/[0.10] rounded-14 xl:p-8 p-4 mb-28">
                    <div class="flex items-start justify-between mb-3">
                        <div class="flex items-center gap-3.5">
                            <div class="flex items-center">
                                <img src="{{ asset('images/dashboard/images/ratting-user-img.png') }}" alt="" />
                            </div>
                            <div class="">
                                <h4 class="text-dark-blue mb-1.5 font-bold text-base leading-none">
                                    John Doe
                                </h4>
                                <ul class="flex items-center gap-1">
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                </ul>
                            </div>
                        </div>
                        <span class="font-normal text-xs leading-none block text-dark-blue/[0.7]">Octobar 15, 2024</span>
                    </div>
                    <p class="text-xs font-normal leading-4 xl:leading-normal text-dark-blue">
                        I had the pleasure of working with Integra Water Systems,
                        and I must say, they offer exceptional service. Jason and
                        his team are true experts in the field. They efficiently
                        solved our water well problems, and their professionalism
                        stood out. I highly recommend their services.
                    </p>
                </div>
                <div class="border border-solid boredr-dark-blue/[0.10] rounded-14 xl:p-8 p-4">
                    <div class="flex items-start justify-between mb-3">
                        <div class="flex items-center gap-3.5">
                            <div class="flex items-center">
                                <img src="{{ asset('images/dashboard/images/ratting-user-img.png') }}" alt="" />
                            </div>
                            <div class="">
                                <h4 class="text-dark-blue mb-1.5 font-bold text-base leading-none">
                                    John Doe
                                </h4>
                                <ul class="flex items-center gap-1">
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                    <li><img src="{{ asset('images/dashboard/images/star.svg') }}" alt="" /></li>
                                </ul>
                            </div>
                        </div>
                        <span class="font-normal text-xs leading-none block text-dark-blue/[0.7]">Octobar 15, 2024</span>
                    </div>
                    <p class="text-xs font-normal leading-4 xl:leading-normal text-dark-blue">
                        I had the pleasure of working with Integra Water Systems,
                        and I must say, they offer exceptional service. Jason and
                        his team are true experts in the field. They efficiently
                        solved our water well problems, and their professionalism
                        stood out. I highly recommend their services.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
