@php use Illuminate\Support\Str; @endphp
<div>
    <div class="relative">
        <x-filament::breadcrumbs :breadcrumbs="[
            '/' => 'Home',
            '/dashboard' => 'Dashboard',
            '/dashboard/favourite' => 'Favourites',
        ]" />
        <x-dashboard.common.loading-overlay-table />
        <x-dashboard.common.page-header>
            <x-slot name="title">{{ __('My Favourites') }}</x-slot>
        </x-dashboard.common.page-header>

        @if (session()->has('message'))
            <div class="p-4 mb-4 text-green-700 bg-green-100 rounded-md border border-green-300">
                {{ session('message') }}
            </div>
        @endif

        @if (session()->has('error'))
            <div class="p-4 mb-4 text-red-700 bg-red-100 rounded-md border border-red-300">
                {{ session('error') }}
            </div>
        @endif

        <!-- Tabs Navigation -->
        <div class="mb-6">
            <div class="border-b border-gray-200">
                <nav class="flex -mb-px space-x-8" aria-label="Tabs">
                    @foreach (['classified' => 'Classified', 'job' => 'Jobs', 'equipment' => 'Equipment', 'users' => 'Members', 'project' => 'Projects', 'product' => 'Products', 'post' => 'Articles'] as $tab => $label)
                        <button wire:click="setActiveTab('{{ $tab }}')" class="py-2 px-1 border-b-2 font-medium text-sm cursor-pointer {{ $activeTab === $tab ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }}">
                            {{ $label }}
                            @if (isset($favoriteTypes[$tab]) && $favoriteTypes[$tab]['count'] > 0)
                                <span class="inline-flex items-center px-2.5 py-0.5 ml-2 text-xs font-medium text-gray-800 bg-gray-100 rounded-full">
                                    {{ $favoriteTypes[$tab]['count'] }}
                                </span>
                            @endif
                        </button>
                    @endforeach
                </nav>
            </div>
        </div>

        <!-- Content -->
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4">
                @if ($favorites->count() > 0)
                    <div class="grid gap-6">
                        @foreach ($favorites as $favorite)
                            @if ($activeTab === 'classified' && $favorite->model)
                                <x-dashboard.favourites.classified-card :favorite="$favorite" />
                            @elseif($activeTab === 'job' && $favorite->model)
                                <x-dashboard.favourites.job-card :favorite="$favorite" />
                            @elseif($activeTab === 'equipment' && $favorite->model)
                                <x-dashboard.favourites.equipment-card :favorite="$favorite" />
                            @elseif($activeTab === 'users' && $favorite->model)
                                <x-dashboard.favourites.user-card :favorite="$favorite" />
                            @elseif($activeTab === 'project' && $favorite->model)
                                <x-dashboard.favourites.project-card :favorite="$favorite" />
                            @elseif($activeTab === 'product' && $favorite->model)
                                <x-dashboard.favourites.product-card :favorite="$favorite" />
                            @elseif($activeTab === 'post' && $favorite->model)
                                <x-dashboard.favourites.post-card :favorite="$favorite" />
                            @endif
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="mt-6">
                        {{ $favorites->links() }}
                    </div>
                @else
                    <div class="py-12 text-center">
                        <svg class="mx-auto w-12 h-12 text-gray-400"
                            fill="none"
                            viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round"
                                stroke-linejoin="round"
                                stroke-width="2"
                                d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                        </svg>
                        <h3 class="mt-2 text-sm font-medium text-gray-900">No {{ ucfirst($activeTab) }} Favourites</h3>
                        <p class="mt-1 text-sm text-gray-500">You haven't added any {{ $activeTab }} to your favourites yet.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
