<div>
    <div class="relative">
        <x-dashboard.common.loading-overlay-table />
        <x-dashboard.common.page-header>
            <x-slot:title>{{ __('Lead Inquiry Details') }}</x-slot:title>
            <x-slot:button>
                <a href="{{ route('dashboard.lead-inquirie') }}" class="text-blue-1200 font-semibold text-sm leading-none flex items-center justify-center h-[43px] gap-3.5 px-6 rounded-md border-2 border-solid border-blue-1200 hover:bg-blue-1200 hover:text-white transition-colors">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    {{ __('Back to Inquiries') }}
                </a>
            </x-slot:button>
        </x-dashboard.common.page-header>

        <!-- Flash Messages -->
        @if (session('success'))
            <div class="mb-6 p-4 bg-green-100 border border-green-200 text-green-700 rounded-md">
                {{ session('success') }}
            </div>
        @endif

        @if (session('error'))
            <div class="mb-6 p-4 bg-red-100 border border-red-200 text-red-700 rounded-md">
                {{ session('error') }}
            </div>
        @endif

        @if ($inquiry)
            <!-- Status and Type Badges -->
            <div class="flex items-center gap-4 mb-6">
                <span class="inline-flex px-4 py-2 items-center justify-center text-{{ $inquiry->inquiry_status->getColor() }}-700 font-semibold text-sm bg-{{ $inquiry->inquiry_status->getColor() }}-100 border border-{{ $inquiry->inquiry_status->getColor() }}-200 rounded-lg">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        @if ($inquiry->inquiry_status->value === 'pending')
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                        @else
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        @endif
                    </svg>
                    {{ $inquiry->inquiry_status->getLabel() }}
                </span>
                <span class="inline-flex px-4 py-2 items-center justify-center text-{{ $inquiry->inquiry_type->getColor() }}-700 font-semibold text-sm bg-{{ $inquiry->inquiry_type->getColor() }}-100 border border-{{ $inquiry->inquiry_type->getColor() }}-200 rounded-lg">
                    <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h8a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 0v12h8V4H6z" clip-rule="evenodd" />
                    </svg>
                    {{ $inquiry->inquiry_type->getLabel() }}
                </span>
            </div>

            <!-- Two Main Sections Grid -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
                <!-- Section 1: Contact User Details -->
                <div class="bg-white border border-solid border-dark-blue/[0.10] shadow-3xl p-[30px] rounded-[14px]">
                    <div class="flex items-center justify-between mb-8">
                        <h4 class="text-dark-blue tracking-[0.32px] text-xl font-medium leading-none flex items-center gap-2">
                            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd" />
                            </svg>
                            {{ __('Contact User Details') }}
                        </h4>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Full Name:') }}</span>
                            <span class="text-dark-blue font-semibold">
                                {{ $inquiry->contact->full_name ?? $inquiry->contact->first_name . ' ' . $inquiry->contact->last_name }}
                            </span>
                        </div>
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Email Address:') }}</span>
                            <span class="text-dark-blue font-semibold">{{ $inquiry->contact->email ?? 'Not provided' }}</span>
                        </div>
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Phone Number:') }}</span>
                            <span class="text-dark-blue font-semibold">{{ $inquiry->contact->phone ?? 'Not provided' }}</span>
                        </div>
                        @if ($inquiry->contact->newsletter_subscription == 1)
                            <div class="flex items-center justify-between py-3 border-b border-gray-100">
                                <span class="text-dark-blue/70 font-medium">{{ __('Newsletter:') }}</span>
                                <span class="inline-flex px-3 py-1 text-xs font-medium text-green-700 bg-green-100 border border-green-200 rounded-full">
                                    {{ __('Subscribed') }}
                                </span>
                            </div>
                        @endif

                        <div class="flex items-center justify-between py-3">
                            <span class="text-dark-blue/70 font-medium">{{ __('Contact Date:') }}</span>
                            <span class="text-dark-blue font-semibold">{{ $inquiry->created_at->format('M d, Y') }}</span>
                        </div>
                    </div>
                </div>

                <!-- Section 2: Inquiry Details -->
                <div class="bg-white border border-solid border-dark-blue/[0.10] shadow-3xl p-[30px] rounded-[14px]">
                    <div class="flex items-center justify-between mb-8">
                        <h4 class="text-dark-blue tracking-[0.32px] text-xl font-medium leading-none flex items-center gap-2">
                            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                            </svg>
                            {{ __('Inquiry Information') }}
                        </h4>
                    </div>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Inquiry ID:') }}</span>
                            <span class="text-dark-blue font-semibold">{{ $inquiry->id }}</span>
                        </div>
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Submitted On:') }}</span>
                            <span class="text-dark-blue font-semibold">{{ $inquiry->created_at->format('M d, Y \a\t h:i A') }}</span>
                        </div>
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Type:') }}</span>
                            <span class="text-dark-blue font-semibold">{{ $inquiry->inquiry_type->getLabel() }}</span>
                        </div>
                        <div class="flex items-center justify-between py-3 border-b border-gray-100">
                            <span class="text-dark-blue/70 font-medium">{{ __('Current Status:') }}</span>
                            <span class="inline-flex px-3 py-1 text-xs font-medium {{ $inquiry->inquiry_status->value === 'contacted' ? 'text-green-700' : 'text-warning-700' }} bg-{{ $inquiry->inquiry_status->value === 'contacted' ? 'green-100' : 'warning-100' }} border border-{{ $inquiry->inquiry_status->value === 'contacted' ? 'green-200' : 'warning-200' }} rounded-full">
                                {{ $inquiry->inquiry_status->getLabel() }}
                            </span>
                        </div>
                        @if ($inquiry->inquiryable)
                            <div class="flex items-center justify-between py-3 border-b border-gray-100">
                                <span class="text-dark-blue/70 font-medium">{{ __('Related To:') }}</span>
                                <span class="text-dark-blue font-semibold">{{ class_basename($inquiry->inquiryable_type) }}</span>
                            </div>
                        @endif
                        @if ($inquiry->user)
                            <div class="flex items-center justify-between py-3">
                                <span class="text-dark-blue/70 font-medium">{{ __('Assigned User:') }}</span>
                                <span class="text-dark-blue font-semibold">{{ $inquiry->user->name ?? 'Not assigned' }}</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Additional Information Section -->
            @if ($inquiry->form_data && count($inquiry->form_data) > 0)
                <div class="bg-white border border-solid border-dark-blue/[0.10] shadow-3xl p-[30px] rounded-[14px] mb-6">
                    <div class="flex items-center justify-between mb-8">
                        <h4 class="text-dark-blue tracking-[0.32px] text-xl font-medium leading-none flex items-center gap-2">
                            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h8a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 0v12h8V4H6z" clip-rule="evenodd" />
                            </svg>
                            {{ __('Additional Information') }}
                        </h4>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        @foreach ($inquiry->form_data as $key => $value)
                            @if ($value && !in_array($key, ['name', 'email', 'phone']))
                                <div class="space-y-1">
                                    <span class="text-dark-blue/70 font-medium text-sm capitalize">{{ str_replace('_', ' ', $key) }}</span>
                                    <div class="text-dark-blue">
                                        @if (is_array($value))
                                            {{ implode(', ', $value) }}
                                        @else
                                            {{ $value }}
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Message Section -->
            @if (isset($inquiry->form_data['message']) && $inquiry->form_data['message'])
                <div class="bg-white border border-solid border-dark-blue/[0.10] shadow-3xl p-[30px] rounded-[14px] mb-6">
                    <div class="flex items-center justify-between mb-8">
                        <h4 class="text-dark-blue tracking-[0.32px] text-xl font-medium leading-none flex items-center gap-2">
                            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 13V5a2 2 0 00-2-2H4a2 2 0 00-2 2v8a2 2 0 002 2h3l3 3 3-3h3a2 2 0 002-2zM5 7a1 1 0 011-1h8a1 1 0 110 2H6a1 1 0 01-1-1zm1 3a1 1 0 100 2h3a1 1 0 100-2H6z" clip-rule="evenodd" />
                            </svg>
                            {{ __('Message') }}
                        </h4>
                    </div>
                    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                        <p class="text-dark-blue text-base leading-relaxed">{{ $inquiry->form_data['message'] }}</p>
                    </div>
                </div>
            @endif

            <!-- Action Buttons -->
            <div class="bg-white border border-solid border-dark-blue/[0.10] shadow-3xl p-[30px] rounded-[14px]">
                <h4 class="text-dark-blue tracking-[0.32px] text-xl font-medium leading-none mb-6 flex items-center gap-2">
                    <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M11.3 1.046A1 1 0 0112 2v5h4a1 1 0 01.82 1.573l-7 10A1 1 0 018 18v-5H4a1 1 0 01-.82-1.573l7-10a1 1 0 011.12-.38z" clip-rule="evenodd" />
                    </svg>
                    {{ __('Quick Actions') }}
                </h4>
                <div class="flex items-center justify-center gap-4 flex-wrap">
                    @if ($inquiry->inquiry_status->value === 'pending')
                        <button wire:click="markAsContacted" class="text-white font-medium text-sm leading-none flex items-center justify-center h-12 px-6 rounded-lg bg-green-600 hover:bg-green-700 transition-colors shadow-md">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            {{ __('Mark as Contacted') }}
                        </button>
                    @endif
                    <a href="mailto:{{ $inquiry->contact->email }}" class="text-blue-1200 border-2 border-solid border-blue-1200 font-medium text-sm leading-none flex items-center justify-center h-12 px-6 rounded-lg hover:bg-blue-1200 hover:text-white transition-colors shadow-md">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 7.89a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        {{ __('Send Email') }}
                    </a>
                    @if ($inquiry->contact->phone)
                        <a href="tel:{{ $inquiry->contact->phone }}" class="text-blue-1200 border-2 border-solid border-blue-1200 font-medium text-sm leading-none flex items-center justify-center h-12 px-6 rounded-lg hover:bg-blue-1200 hover:text-white transition-colors shadow-md">
                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                            </svg>
                            {{ __('Call Now') }}
                        </a>
                    @endif
                </div>
            </div>
        @else
            <div class="bg-white border border-solid border-dark-blue/[0.10] shadow-3xl p-[30px] rounded-[14px] text-center">
                <div class="text-dark-blue text-lg font-medium mb-2">{{ __('Inquiry Not Found') }}</div>
                <p class="text-dark-blue/60 mb-6">{{ __("The inquiry you're looking for doesn't exist or has been removed.") }}</p>
                <a href="{{ route('dashboard.lead-inquiries') }}" class="text-blue-1200 font-semibold text-sm leading-none flex items-center justify-center mx-auto h-11 px-6 rounded-md border-2 border-solid border-blue-1200 hover:bg-blue-1200 hover:text-white transition-colors max-w-xs">
                    {{ __('Back to Inquiries') }}
                </a>
            </div>
        @endif
    </div>
</div>
