<div>
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div>
                <h4 class="font-semibold xl:mb-2 mb-1 tracking-[-0.11px] leading-none xl:text-[32px] md:text-2xl text-base text-black-1200">
                    Edit Lead
                </h4>
                <p class="text-gray-600 text-sm">
                    Update lead information and status.
                </p>
            </div>
            <div class="flex items-center gap-3">
                {{ $this->cancelAction }}
            </div>
        </div>
    </div>

    <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
        <form wire:submit.prevent="save">
            {{ $this->form }}
            
            <div class="flex items-center justify-end gap-4 mt-8 pt-6 border-t border-gray-200">
                <button 
                    type="button" 
                    wire:click="$dispatch('cancel')"
                    class="px-6 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                >
                    Cancel
                </button>
                <button 
                    type="submit"
                    class="px-6 py-2 text-sm font-medium text-white bg-blue-600 border border-transparent rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    wire:loading.attr="disabled"
                    wire:loading.class="opacity-50 cursor-not-allowed"
                >
                    <span wire:loading.remove>Update Lead</span>
                    <span wire:loading>Updating...</span>
                </button>
            </div>
        </form>
    </div>
</div> 