<div class="space-y-6">
    <!-- Lead Information Section -->
    <x-filament::section>
        <x-slot name="heading">
            {{ __('Lead Data') }}
        </x-slot>

        <x-slot name="description">
            {{ __('Basic lead details and contact information') }}
        </x-slot>

        <div class="space-y-6">
            <!-- Contact Information -->
            <div>
                <div>
                    <h4 class="text-base font-bold text-gray-900 dark:text-white mb-5">{{ __('Contact Information') }}</h4>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-8 gap-y-4">
                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('First Name') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $lead->first_name ?? 'N/A' }}
                            </dd>
                        </div>

                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('Last Name') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $lead->last_name ?? 'N/A' }}
                            </dd>
                        </div>

                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('Email') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                @if ($lead->email)
                                    <a href="mailto:{{ $lead->email }}" class="text-primary-600 hover:text-primary-800 dark:text-primary-400 dark:hover:text-primary-300 font-medium">
                                        {{ $lead->email }}
                                    </a>
                                @else
                                    N/A
                                @endif
                            </dd>
                        </div>

                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('Phone') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                @if ($lead->phone)
                                    <a href="tel:{{ $lead->phone }}" class="text-primary-600 hover:text-primary-800 dark:text-primary-400 dark:hover:text-primary-300 font-medium">
                                        {{ $lead->phone }}
                                    </a>
                                @else
                                    N/A
                                @endif
                            </dd>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Lead Information -->
            <div>
                <div>
                    <h4 class="text-base font-bold text-gray-900 dark:text-white mb-5">{{ __('Lead Information') }}</h4>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-8 gap-y-4">
                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('Submitted Date') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                {{ $lead->created_at->format('M d, Y h:i A') }}
                            </dd>
                        </div>

                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('Message') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100 leading-relaxed">
                                @if ($lead->message)
                                    <div class="break-words">
                                        {{ $lead->message }}
                                    </div>
                                @else
                                    <span class="text-gray-500 dark:text-gray-400 italic font-light">
                                        {{ __('No message provided') }}
                                    </span>
                                @endif
                            </dd>
                        </div>

                        <div class="contents">
                            <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                {{ __('Lead Source') }}:
                            </dt>
                            <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                @if ($lead->lead_source)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-sm font-semibold bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                        {{ $lead->lead_source }}
                                    </span>
                                @else
                                    <span class="text-gray-500 dark:text-gray-400 italic font-light">
                                        {{ __('Unknown source') }}
                                    </span>
                                @endif
                            </dd>
                        </div>

                        @if (isset($lead->lead_status))
                            <div class="contents">
                                <dt class="text-sm font-bold text-gray-800 dark:text-gray-200">
                                    {{ __('Lead Status') }}:
                                </dt>
                                <dd class="text-base font-normal text-gray-900 dark:text-gray-100">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-sm font-semibold bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                        {{ $lead->lead_status }}
                                    </span>
                                </dd>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </x-filament::section>

    <!-- Form Data Section -->
    <x-filament::section>
        <x-slot name="heading">
            {{ __('Form Data') }}
        </x-slot>

        <x-slot name="description">
            {{ __('Additional form fields and custom data') }}
        </x-slot>

        <div class="space-y-6">
            @if ($lead->lead_data && is_array($lead->lead_data) && count($lead->lead_data) > 0)
                <!-- Custom Lead Data -->
                <div>
                    <div>
                        <h4 class="text-base font-bold text-gray-900 dark:text-white mb-5">{{ __('Custom Lead Data') }}</h4>

                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-8 gap-y-4">
                            @foreach ($lead->lead_data as $key => $value)
                                @if (!empty($value['value']))
                                    <div class="contents">
                                        <dt class="text-sm font-bold text-gray-800 dark:text-gray-200 capitalize">
                                            {{ str_replace(['_', '-'], ' ', $value['key']) }}:
                                        </dt>
                                        <dd class="text-base font-normal text-gray-900 dark:text-gray-100 leading-relaxed">
                                            @if (is_array($value) && isset($value['value']))
                                                @if (is_array($value['value']))
                                                    <div class="space-y-1">
                                                        @foreach ($value['value'] as $item)
                                                            <span class="inline-block px-2.5 py-0.5 text-sm font-semibold bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200 rounded-full mr-1">
                                                                {{ $item }}
                                                            </span>
                                                        @endforeach
                                                    </div>
                                                @elseif (is_bool($value['value']))
                                                    <span class="inline-flex items-center">
                                                        <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                            @if ($value['value'])
                                                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                                            @else
                                                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                                            @endif
                                                        </svg>
                                                        <span class="text-{{ $value['value'] ? 'green' : 'red' }}-600 dark:text-{{ $value['value'] ? 'green' : 'red' }}-400 font-medium">
                                                            {{ $value['value'] ? __('Yes') : __('No') }}
                                                        </span>
                                                    </span>
                                                @else
                                                    <div class="break-words">
                                                        {{ $value['value'] }}
                                                    </div>
                                                @endif
                                            @elseif (is_bool($value))
                                                <span class="inline-flex items-center">
                                                    <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                        @if ($value)
                                                            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path>
                                                        @else
                                                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                                        @endif
                                                    </svg>
                                                    <span class="text-{{ $value ? 'green' : 'red' }}-600 dark:text-{{ $value ? 'green' : 'red' }}-400 font-medium">
                                                        {{ $value ? __('Yes') : __('No') }}
                                                    </span>
                                                </span>
                                            @else
                                                <div class="break-words">
                                                    {{ $value['value'] ?? $value }}
                                                </div>
                                            @endif
                                        </dd>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            @else
                <div class="text-center py-8">
                    <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100 dark:bg-gray-800">
                        <x-heroicon-o-document-text class="h-6 w-6 text-gray-400" />
                    </div>
                    <h3 class="mt-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('No additional data') }}</h3>
                    <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                        {{ __("This lead doesn't have any additional form data.") }}
                    </p>
                </div>
            @endif
        </div>
    </x-filament::section>

    <!-- User Management Section -->
    <x-filament::section>
        <x-slot name="heading">
            {{ __('User Management') }}
        </x-slot>

        <x-slot name="description">
            {{ __('Manage users assigned to this lead and view available users based on member category matching') }}
        </x-slot>

        <div class="space-y-6">
            <!-- Tab Navigation -->
            <div class="flex space-x-1 bg-gray-100 dark:bg-gray-800 p-1 rounded-lg">
                <button 
                    wire:click="setActiveTab('assigned')"
                    class="flex-1 px-4 py-2 text-sm font-medium rounded-md transition-colors duration-200 {{ $activeTab === 'assigned' ? 'bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 shadow-sm' : 'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' }}"
                >
                    <div class="flex items-center justify-center space-x-2">
                        <x-heroicon-o-users class="w-4 h-4" />
                        <span>Assigned Users</span>
                        <span class="bg-gray-200 dark:bg-gray-600 text-gray-700 dark:text-gray-300 text-xs font-medium px-2 py-1 rounded-full">
                            {{ $lead->users->count() }}
                        </span>
                    </div>
                </button>

                <button 
                    wire:click="setActiveTab('available')"
                    class="flex-1 px-4 py-2 text-sm font-medium rounded-md transition-colors duration-200 {{ $activeTab === 'available' ? 'bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 shadow-sm' : 'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100' }}"
                >
                    <div class="flex items-center justify-center space-x-2">
                        <x-heroicon-o-user-group class="w-4 h-4" />
                        <span>Available Users</span>
                        @if($lead->leadForm && $lead->leadForm->memberCategories->count() > 0)
                            <span class="bg-blue-100 dark:bg-blue-800 text-blue-700 dark:text-blue-300 text-xs font-medium px-2 py-1 rounded-full">
                                {{ $this->getAvailableUsersCount() }}
                            </span>
                            <span class="bg-green-100 dark:bg-green-800 text-green-700 dark:text-green-300 text-xs font-medium px-2 py-1 rounded-full">
                                {{ $lead->leadForm->memberCategories->count() }} {{ $lead->leadForm->memberCategories->count() === 1 ? 'category' : 'categories' }}
                            </span>
                        @else
                            <span class="bg-yellow-100 dark:bg-yellow-800 text-yellow-700 dark:text-yellow-300 text-xs font-medium px-2 py-1 rounded-full">
                                No categories
                            </span>
                        @endif
                    </div>
                </button>
            </div>

            <!-- Category Information for Available Users -->
            @if($activeTab === 'available' && $lead->leadForm && $lead->leadForm->memberCategories->count() > 0)
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                    <div class="flex items-start space-x-3">
                        <x-heroicon-o-information-circle class="w-5 h-5 text-blue-500 dark:text-blue-400 mt-0.5 flex-shrink-0" />
                        <div>
                            <h4 class="text-sm font-medium text-blue-900 dark:text-blue-100">
                                {{ __('Matching Categories') }}
                            </h4>
                            <p class="text-sm text-blue-700 dark:text-blue-200 mt-1">
                                {{ __('Showing users who belong to the following member categories associated with this lead form:') }}
                            </p>
                            <div class="mt-2 flex flex-wrap gap-2">
                                @foreach($lead->leadForm->memberCategories as $category)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-800 dark:text-blue-200">
                                        {{ $category->category_name }}
                                    </span>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @elseif($activeTab === 'available')
                <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 rounded-lg p-4">
                    <div class="flex items-start space-x-3">
                        <x-heroicon-o-exclamation-triangle class="w-5 h-5 text-amber-500 dark:text-amber-400 mt-0.5 flex-shrink-0" />
                        <div>
                            <h4 class="text-sm font-medium text-amber-900 dark:text-amber-100">
                                {{ __('No Categories Set') }}
                            </h4>
                            <p class="text-sm text-amber-700 dark:text-amber-200 mt-1">
                                {{ __('This lead form does not have any member categories associated with it. Please configure the lead form to assign member categories for automatic user matching.') }}
                            </p>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Table Content -->
            <div class="mt-6">
                {{ $this->table }}
            </div>
        </div>
    </x-filament::section>

</div>
