<div>
    <div class="relative">
        <x-filament::breadcrumbs :breadcrumbs="[
            '/' => 'Home',
            '/dashboard' => 'Dashboard',
            '/dashboard/manufacturers-supplier' => 'Manufacturers & Suppliers',
        ]" />
        <x-dashboard.common.loading-overlay-table />

        <x-dashboard.common.page-header>
            <x-slot name="title">{{ __('Manufacturers & Suppliers') }}</x-slot>
        </x-dashboard.common.page-header>

        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
            <div class="sm:mb-9 mb-[26px]">
                <h4 class="text-dark-blue sm:font-medium font-semibold sm:text-[22px] text-base sm:tracking-[0.32px] mb-2">
                    {{ __('Browse Manufacturers & Suppliers') }}
                </h4>
                <p class="text-dark-blue/[0.6] font-normal text-sm leading-normal">
                    {{ __('Find manufacturers and suppliers from your member categories') }}
                </p>
            </div>
            <div class="relative">
                <div class="flex items-center justify-between xl:flex-row md:flex-col flex-row md:border border-0 border-solid border-dark-blue/[0.1] rounded-lg xl:p-4 md:p-2.5 p-0 md:gap-0 gap-3 md:mb-0 mb-[26px]">
                    <div class="relative w-full md:hidden block">
                        <input type="text" wire:model.live.debounce.500ms="search" class="bg-white w-full pl-[41px] border border-solid border-dark-blue/[0.1] rounded-lg h-10 text-gray-1500 placeholder:text-gray-1500 font-normal text-xs shadow-none focus:border-gray-1200 focus:ring-0" placeholder="Search here">
                        <a href="#" class="flex items-center justify-center absolute left-5 top-1/2 -translate-y-1/2"><img src="{{ asset('images/dashboard/images/search-icon2.svg') }}" alt=""></a>
                    </div>
                    <div class="md:flex hidden items-center 2xl:gap-3 gap-2">
                        <a href="#" class="flex items-center justify-center w-[30px] h-[30px]">
                            <x-icon-filter-icon class="w-5 h-5" />
                        </a>
                        <select wire:model.live="category" class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[143px] xl:w-[130px] w-[120px] h-10">
                            <option value="">{{ __('All My Categories') }}</option>
                            @foreach ($categories as $categoryOption)
                                <option value="{{ $categoryOption->slug }}">{{ $categoryOption->category_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="xl:w-auto md:w-full w-auto md:flex-auto flex-1 xl:mt-0 md:mt-4 mt-0">
                        <ul class="flex items-center justify-end 2xl:gap-3 gap-2">
                            @if(!empty($category) || !empty($search))
                                <li class="md:block hidden">
                                    <button type="button" wire:click="resetFilters" class="text-blue-1200 font-normal 2xl:text-xs text-[10px] rounded-lg h-10 2xl:w-[113px] w-[90px] bg-white border border-blue-1200 flex items-center justify-center hover:bg-blue-1200 hover:text-white">
                                        {{ __('Reset Filters') }}
                                    </button>
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
            </div>
            <div class="flex items-center justify-between md:py-[18px] md:mb-0 mb-[26px]">
                <p class="text-dark-blue font-medium text-sm leading-none">
                    {{ $users->count() }} {{ __('Records found') }}
                    @if(!empty($category) || !empty($search))
                        <span class="text-blue-1200 text-xs ml-2">({{ __('Filtered') }})</span>
                    @endif
                </p>
            </div>
            @if ($users->count() > 0)
                <div class="grid xl:grid-cols-3 sm:grid-cols-2 grid-cols-1 md:gap-[30px] sm:gap-4 gap-[26px]">
                    @foreach ($users as $user)
                        <div class="bg-white border border-solid border-dark-blue/[0.1] rounded-[10px] pb-[30px] pt-8 md:px-5 px-2.5">

                            <div class="flex items-center justify-center mb-[50px]">
                                <img src="{{ $user->logoImage() }}" alt="{{ $user->memberName() }}" class="w-full h-full object-cover" />
                            </div>
                            <div class="text-center">
                                <h4 class="text-dark-blue font-semibold text-lg leading-none tracking-[-0.06px]">
                                    {{ $user->memberName() }}
                                </h4>
                                @if ($user->roles()->exists())
                                    <span class="text-blue-1200 my-1.5 font-normal text-sm leading-nones block">{{ $user->roles()->pluck('name')->first() }}</span>
                                @endif

                                @if ($user->address())
                                    <p class="text-dark-blue/[0.65] font-normal text-sm leading-none">{{ $user->address() }}</p>
                                @else
                                    <p class="text-dark-blue/[0.65] font-normal text-sm leading-none">{{ __('N/A') }}</p>
                                @endif

                                <ul class="mt-5 flex items-center justify-center xl:gap-3.5  gap-2.5 sm:w-auto w-full sm:max-w-full max-w-[220px] sm:mx-0 mx-auto">
                                    <li class="">
                                        <a href="#" class="flex items-center justify-center gap-2.5 border-r border-solid border-dark-blue pr-3.5 py-px">
                                            <x-icon-call-icon-2 />
                                            <p class="text-blue-1200 font-normal xl:text-sm sm:text-xs text-sm leading-none flex items-center">
                                                {{ __('Contact') }}
                                            </p>
                                        </a>
                                    </li>
                                    <li class="">
                                        <a href="#" class="flex items-center justify-center gap-2.5 py-px pr-o">
                                            <x-icon-mail-icon />
                                            <p class="text-dark-blue gap-2.5 font-normal xl:text-sm sm:text-xs text-sm leading-none flex items-center">
                                                {{ __('Email') }}
                                            </p>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <x-common.no-records-found>
                    <x-slot name="icon">
                        <x-icon-magnifier-minus class="w-12 h-12" />
                    </x-slot>
                    <x-slot name="title">
                        {{ __('No Manufacturers & Suppliers found') }}
                    </x-slot>
                    <x-slot name="description">
                        {{ __('No Manufacturers & Suppliers found in the system yet. Please try again later.') }}
                    </x-slot>
                </x-common.no-records-found>
            @endif


            @if ($users->count() > 0)
                <div class="flex items-center justify-between mt-[30px]">
                    <p class="text-dark-blue/[0.4] tracking-[-0.16px] font-medium md:text-sm sm:text-xs text-[10px]">
                        <span class="sm:block hidden"> {{ __('Showing data') }} {{ $users->firstItem() }} to {{ $users->lastItem() }} of {{ $users->total() }} {{ __('entries') }}</span>
                        <span class="sm:hidden block">{{ __('Showing data') }} {{ $users->firstItem() }} to {{ $users->lastItem() }} of {{ $users->total() }} {{ __('entries') }}</span>
                    </p>
                    <x-common.pagination :paginator="$users" />
                </div>
            @endif
        </div>
    </div>
</div>
