@php
    $inputClass = 'text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid rounded-md shadow-none focus:ring-transparent w-full h-11';
    $errorInputClass = 'border-red-500 focus:border-red-500';
    $normalInputClass = 'border-dark-blue/[0.2] focus:border-dark-blue/[0.2]';
@endphp

<div>
    <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
        {{ __('Basic Information') }}
    </h4>

    <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
        <div x-data x-cloak x-show="$wire.isDirty" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform -translate-y-2" x-transition:enter-end="opacity-100 transform translate-y-0" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform translate-y-0" x-transition:leave-end="opacity-0 transform -translate-y-2"
            class="flex items-center gap-3 p-4 mb-6 border-l-4 border-yellow-400 rounded-r-lg shadow-sm bg-yellow-50">
            <div class="flex items-center min-w-0 gap-3">
                <svg class="flex-shrink-0 w-5 h-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                </svg>
                <p class="overflow-hidden text-sm text-yellow-700 whitespace-nowrap text-ellipsis">
                    {{ __('You have unsaved changes. Please save your changes before leaving this page.') }}
                </p>
            </div>
        </div>

        <div class="mb-10">
            <h4 class="text-dark-blue font-medium sm:text-22 text-base tracking-32p sm:mb-3.5 mb-2.5 leading-none">
                {{ __('Personal & Business Information') }}
            </h4>
            <p class="text-dark-blue/[0.6] font-normal text-sm leading-none">
                {{ __('Edit Information') }}
            </p>
        </div>
        <div class="flex flex-col items-center justify-center" x-data="{
            previewUrl: null,
            updatePreview: function(event) {
                const file = event.target.files[0];
                if (file) {
                    this.previewUrl = URL.createObjectURL(file);
                }
            }
        }" @avatar-updated.window="$wire.$refresh()">
            <template x-if="previewUrl">
                <img :src="previewUrl" alt="{{ __('Profile Image Preview') }}" class="object-cover w-32 h-32 rounded-full" />
            </template>
            <template x-if="!previewUrl">
                @if ($user->getFirstMediaUrl('avatar'))
                    <img src="{{ $user->getFirstMediaUrl('avatar', 'medium') }}" alt="{{ __('Profile Image') }}" class="object-cover w-32 h-32 rounded-full" />
                @else
                    <img src="{{ asset('images/dashboard/images/info-img.png') }}" alt="{{ __('Profile Image') }}" class="object-cover w-32 h-32 rounded-full" />
                @endif
            </template>

            <div class="flex items-center justify-center gap-3.5 mt-8">
                <label for="avatar-upload" class="cursor-pointer flex items-center gap-2.5 border-r border-solid border-dark-blue py-px pr-3.5">
                    <img src="{{ asset('images/dashboard/images/uplod-icon.svg') }}" alt="{{ __('Upload Icon') }}" />
                    <span class="flex items-center text-sm font-normal leading-none text-dark-blue">
                        {{ __('Upload') }}
                    </span>
                </label>
                @if ($user->getFirstMediaUrl('avatar'))
                    <button type="button" wire:click="deleteAvatar" @click="previewUrl = null" wire:confirm="{{ __('Are you sure you want to remove your profile picture?') }}" class="flex items-center gap-2.5 py-px cursor-pointer group">
                        <img src="{{ asset('images/dashboard/images/delete.svg') }}" alt="{{ __('Delete Icon') }}" />
                        <span class="text-red-500 gap-2.5 font-normal text-sm leading-none flex items-center group-hover:text-red-600">
                            {{ __('Remove') }}
                        </span>
                    </button>
                @endif
                <input type="file" id="avatar-upload" wire:model="avatar" @change="updatePreview($event)" class="hidden" accept="image/*" />
                @error('avatar')
                    <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
        </div>

        <form wire:submit="updateProfile" class="pt-10 sm:pt-70">
            {{-- Personal & Contact Information Section --}}
            <div class="mb-10">
                <x-dashboard.profile.personal-information :user="$user" :inputClass="$inputClass" :errorInputClass="$errorInputClass" :normalInputClass="$normalInputClass" />
            </div>

            {{-- Business Information Section --}}
            <div class="mb-10">
                <x-dashboard.profile.business-information :user="$user" :inputClass="$inputClass" :errorInputClass="$errorInputClass" :normalInputClass="$normalInputClass" :businessHours="$business_hours" :seasonalHours="$seasonal_hours" :profileTags="$profile_tags" :credentials="$credentials" :awardsRecognitions="$awards_recognitions" />
            </div>

            {{-- Social Media Section --}}
            @can('userProfileSocialMediaLinks')
                <div class="mb-10">
                    <x-dashboard.profile.social-media-links :user="$user" :inputClass="$inputClass" :errorInputClass="$errorInputClass" :normalInputClass="$normalInputClass" />
                </div>
            @endcan
            {{-- Submit Button --}}
            <div class="pt-5 md:pt-16">
                <button type="submit" class="text-white font-semibold text-xs leading-none flex items-center justify-center ml-auto h-11 max-w-[189px] w-full rounded-md bg-blue-1200">
                    <span wire:loading.remove wire:target="updateProfile">
                        {{ __('Save changes') }}
                    </span>
                    <span wire:loading wire:target="updateProfile">
                        {{ __('Saving...') }}
                    </span>
                </button>
            </div>
        </form>
    </div>
</div>
