<div>
    <div class="">
        <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] md:text-2xl text-base text-black-1200">
            Business Members
        </h4>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
            <div class="sm:mb-9 mb-[26px]">
                <h4 class="text-dark-blue sm:font-medium font-semibold sm:text-22 text-base tracking-[0.32px] sm:mb-1 mb-0.5 leading-normal">
                    Business Members</h4>
                <p class="text-dark-blue/[0.6] font-normal text-sm leading-normal">For manufacturers and suppliers, Select
                    your business membership category.</p>
            </div>

            <div class="md:mt-10 sm:mt-5 mt-[26px]">
                <label class="text-sm font-medium text-dark-blue leading-none flex items-center gap-2 mb-2.5">Parent Categories <span class="flex items-center text-red-1200">*</span></label>
                <select wire:model.live="selectedParentId" class="text-dark-blue/[0.4] font-normal text-xs bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11">
                    <option value="">{{ __('Select Categories') }}</option>
                    @foreach ($parentCategories as $category)
                        <option value="{{ $category->id }}">{{ $category->category_name }}</option>
                    @endforeach
                </select>
            </div>

            @if (count($selectedParentIds) > 0)
                <div class="mt-4">
                    <div class="flex flex-wrap gap-2">
                        @foreach ($selectedCategories->whereNull('parent_id') as $parent)
                            <div wire:key="parent-{{ $parent->id }}" class="inline-flex items-center px-4 py-2 text-sm rounded-full bg-blue-50 text-blue-1200">
                                <span>{{ $parent->category_name }}</span>
                                <button wire:click.prevent="removeCategory('{{ $parent->id }}')" type="button" class="ml-2 text-blue-1200 hover:text-blue-800 focus:outline-none">
                                    <x-heroicon-o-x-circle class="w-4 h-4 fw-bold" />
                                </button>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            @foreach ($selectedParentIds as $parentId)
                @if (isset($childCategoriesMap[$parentId]))
                    <div class="mt-6 border border-dark-blue/[0.2] rounded-lg p-6 ">
                        <h5 class="mb-4 text-base font-medium text-dark-blue">
                            {{ $selectedCategories->firstWhere('id', $parentId)->category_name }}
                        </h5>
                        <div class="space-y-4">
                            @foreach ($childCategoriesMap[$parentId] as $child)
                                <div class="p-4 border border-blue-100 rounded-lg bg-blue-50/50 bg-blue-50 text-blue-1200">
                                    <div class="flex items-center">
                                        <input type="checkbox" id="child-{{ $child->id }}" wire:click="toggleChildCategory('{{ $child->id }}')" @checked(in_array($child->id, $selectedCategoryIds)) class="w-4 h-4 text-blue-1200 bg-white border-dark-blue/[0.6] rounded focus:ring-blue-1200">
                                        <label for="child-{{ $child->id }}" class="ml-2 text-sm font-medium text-dark-blue">
                                            {{ $child->category_name }}
                                        </label>
                                    </div>

                                    @if (in_array($child->id, $selectedChildIds) && isset($secondLevelCategoriesMap[$child->id]))
                                        <div class="pt-3 mt-3 border-t border-blue-100">
                                            <div class="grid grid-cols-1 gap-3 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4">
                                                @foreach ($secondLevelCategoriesMap[$child->id] as $secondLevel)
                                                    <div class="flex items-center">
                                                        <input type="checkbox" id="second-level-{{ $secondLevel->id }}" wire:click="toggleSecondLevelCategory('{{ $secondLevel->id }}')" @checked(in_array($secondLevel->id, $selectedCategoryIds)) class="w-4 h-4 text-blue-1200 bg-white border-dark-blue/[0.6] rounded focus:ring-blue-1200">
                                                        <label for="second-level-{{ $secondLevel->id }}" class="ml-2 text-sm font-normal text-dark-blue/[0.7]">
                                                            {{ $secondLevel->category_name }}
                                                        </label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            @endforeach

            <div class="md:pt-9 sm:pt-5 pt-14">
                <button type="button" wire:click="saveCategories" wire:loading.attr="disabled" wire:loading.class="opacity-75 cursor-wait" class="text-white font-semibold text-xs leading-none flex items-center justify-center ml-auto h-11 sm:max-w-[189px] max-w-full w-full rounded-md bg-blue-1200">
                    <span wire:loading.remove>{{ __('Save changes') }}</span>
                    <span wire:loading>
                        {{ __('Saving...') }}
                    </span>
                </button>
            </div>
        </div>
    </div>
</div>
