<div>
    <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
        {{ __('Gallery Images') }}
    </h4>
    <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
        <div class="mb-6 sm:mb-10">
            <h4 class="text-dark-blue font-medium sm:text-[22px] text-base tracking-[0.32px] mb-1 leading-normal">
                {{ __('Upload and Manage Your Gallery Images') }}
            </h4>
            <p class="text-dark-blue/[0.6] font-normal sm:text-sm text-xs leading-normal">
                {{ __('Upload images showcasing your services, projects or portfolio to your gallery. Note: Minimum 4 images required.') }}
            </p>

            @error('images')
                <div class="flex items-center p-4 mt-4 text-red-800 border border-red-300 rounded-lg bg-red-50">
                    <svg class="flex-shrink-0 w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                    </svg>
                    <div class="ml-3 text-sm font-medium">
                        {{ $message }}
                    </div>
                </div>
            @enderror
        </div>
        <div class="w-full">
            <label class="flex flex-col items-center cursor-pointer {{ count($images) >= 10 ? 'opacity-50 cursor-not-allowed' : '' }}">
                <input type="file" wire:model="newImages" multiple accept="image/*" class="hidden" {{ count($images) >= 10 ? 'disabled' : '' }}>
                <div class="relative border-dashed w-full border border-text-blue/[0.4] rounded-md flex items-center justify-center flex-col py-8">
                    <span class="text-dark-blue/[0.7] font-normal text-xs flex items-center absolute right-5 top-5">
                        {{ count($images) }}/10
                        @if (count($images) < 10)
                            <span class="ml-1 text-green-600">({{ 10 - count($images) }} remaining)</span>
                        @else
                            <span class="ml-1 text-red-600">(Limit reached)</span>
                        @endif
                    </span>
                    <img src="{{ asset('images/dashboard/images/picture-img.png') }}" alt="{{ __('Gallery upload icon') }}">
                    <h4 class="flex items-center justify-center gap-1 mt-5 mb-2 text-xs font-normal leading-none text-dark-blue">
                        @if (count($images) < 10)
                            {{ __('Drop your image here, or') }},
                            <span class="font-semibold text-blue-1200">{{ __('Browse') }}</span>
                        @else
                            {{ __('Maximum image limit reached') }}
                        @endif
                    </h4>
                    <p class="text-dark-blue/[0.4] font-normal text-[8px] text-center leading-none mb-2">
                        {{ __('Minimum Size 100x100') }}
                    </p>
                    <p class="text-dark-blue/[0.4] font-normal text-[8px] text-center leading-none">
                        {{ __('Supports: PNG, JPG, JPEG, WEBP') }}
                    </p>
                    <div wire:loading wire:target="newImages" class="absolute inset-0 flex items-center justify-center rounded-md bg-white/80">
                        <div class="flex flex-col items-center gap-2">
                            <div class="w-8 h-8 border-b-2 rounded-full animate-spin border-blue-1200"></div>
                            <span class="text-xs text-dark-blue">{{ __('Uploading...') }}</span>
                        </div>
                    </div>
                </div>
            </label>
        </div>
        <div class="mt-9">
            <ul wire:sortable="updateImageOrder" wire:sortable.options="{ animation: 150, handle: '.drag-handle', dragClass: 'opacity-50' }" class="grid grid-cols-2 gap-4 xl:grid-cols-6 md:grid-cols-5 sm:grid-cols-3">
                @foreach ($images as $index => $image)
                    <li wire:key="image-{{ $image['id'] ?? 'new-' . $index }}" wire:sortable.item="{{ $image['id'] ?? 'temp_' . uniqid() }}" class="relative transition-transform duration-200">
                        <div class="relative group">
                            <img src="{{ $image['url'] }}" alt="{{ $image['name'] }}" class="object-cover w-full h-32 rounded-xl" />
                            <ul class="flex items-center justify-between absolute top-0 left-0 w-full p-2.5">
                                @if (isset($image['temp']))
                                    <li><span class="flex items-center justify-center px-2 py-1 text-xs text-white bg-yellow-500 rounded-md">{{ __('Pending') }}</span></li>
                                @else
                                    <li class="cursor-move drag-handle">
                                        <div class="flex items-center justify-center rounded-md bg-white/80 border border-solid border-dark-blue/[0.1] w-[30px] h-[30px] shadow-6xl hover:bg-gray-50">
                                            <x-heroicon-o-bars-4 class="w-4 h-4 text-gray-600" />
                                        </div>
                                    </li>
                                @endif
                                <li>
                                    <button wire:click="deleteImage({{ $index }})" class="flex items-center justify-center rounded-md bg-white border border-solid border-dark-blue/[0.1] w-[30px] h-[30px] shadow-6xl hover:bg-red-50">
                                        <img src="{{ asset('images/dashboard/images/delete-icon.svg') }}" alt="{{ __('Delete icon') }}" />
                                    </button>
                                </li>
                            </ul>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>
        @if ($newImages)
            @foreach ($newImages as $image)
                <img src="{{ $image->temporaryUrl() }}" loading="lazy" alt="{{ $image}}" />
            @endforeach
        @endif
        <div class="pt-5 md:pt-16">
            <button wire:click="save" wire:loading.attr="disabled" wire:target="save" class="text-white font-semibold text-xs leading-none flex items-center justify-center ml-auto h-11 max-w-[189px] w-full rounded-md bg-blue-1200 hover:bg-blue-dark transition-colors disabled:opacity-70 disabled:cursor-not-allowed">
                <span wire:loading.remove wire:target="save">
                    {{ __('Save Changes') }}
                </span>
                <span wire:loading wire:target="save" class="flex items-center gap-2">
                    {{ __('Saving...') }}
                </span>
            </button>
        </div>


    </div>
</div>
