<div>
    <div class="">
        <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
            {{ __('Locations') }}
        </h4>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
            <div class="max-w-[535px] w-full">
                <h4 class="text-dark-blue font-medium text-[22px] tracking-[0.32px] mb-1 leading-normal">
                    {{ $isEditing ? __('Edit') : __('Add') }} {{ __('Location') }}
                </h4>
                <p class="text-dark-blue/[0.6] font-normal text-sm leading-normal">
                    {{ __('Set Location') }}
                </p>
            </div>

            <div x-data x-cloak x-show="$wire.isDirty" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 transform -translate-y-2" x-transition:enter-end="opacity-100 transform translate-y-0" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100 transform translate-y-0" x-transition:leave-end="opacity-0 transform -translate-y-2" class="flex items-center gap-3 p-4 mt-6 mb-6 border-l-4 border-yellow-400 rounded-r-lg shadow-sm bg-yellow-50" wire:key="dirty-alert">
                <div class="flex items-center min-w-0 gap-3">
                    <svg class="flex-shrink-0 w-5 h-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                    </svg>
                    <p class="overflow-hidden text-sm text-yellow-700 whitespace-nowrap text-ellipsis">
                        {{ __('You have unsaved changes. Please save your changes before leaving this page.') }}
                    </p>
                </div>
            </div>

            @if ($errors->any())
                <div class="p-4 mt-6 text-sm text-red-800 border border-red-300 rounded-lg bg-red-50" role="alert">
                    <div class="flex items-center gap-2">
                        <svg class="w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM10 15a1 1 0 1 1 0-2 1 1 0 0 1 0 2Zm1-4a1 1 0 0 1-2 0V6a1 1 0 0 1 2 0v5Z" />
                        </svg>
                        <span class="font-medium">{{ __('Please fix the following errors:') }}</span>
                    </div>
                    <ul class="mt-1.5 ml-4 list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="">
                <form wire:submit="save">
                    <div class="pt-6 md:mt-9">
                        <h5 class="mb-4 text-lg font-medium text-dark-blue">{{ __('Basic Information') }}</h5>
                        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                            <div class="flex items-center gap-4 pt-6 pb-6">
                                <label class="relative inline-flex items-center cursor-pointer">
                                    <input type="checkbox" wire:model="primary_location" class="sr-only peer">
                                    <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-1200"></div>
                                    <span class="text-sm font-medium ms-3 text-dark-blue">{{ __('Set as Primary Location') }}</span>
                                </label>
                            </div>
                        </div>
                        <div class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Location Name') }}
                                    <span class="flex items-center text-red-1200">*</span>
                                </label>
                                <input type="text" wire:model.live="location_name" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Enter location name') }}" />
                                @error('location_name')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Contact Person Name') }}
                                </label>
                                <input type="text" wire:model.live="contact_person_name" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Enter contact person name') }}" />
                                @error('contact_person_name')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="grid grid-cols-1 gap-6 mt-6 sm:grid-cols-3">
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Phone') }}
                                    <span class="flex items-center text-red-1200">*</span>
                                </label>
                                <input type="tel" wire:model.live="phone" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Enter phone number') }}" />
                                @error('phone')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Email') }}
                                    <span class="flex items-center text-red-1200">*</span>
                                </label>
                                <input type="email" wire:model.live="email" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Enter email address') }}" />
                                @error('email')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Fax') }}
                                </label>
                                <input type="text" wire:model.live="fax" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Enter fax number') }}" />
                                @error('fax')
                                    <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="pt-6 md:mt-9">
                        <h5 class="mb-6 text-lg font-medium text-dark-blue">{{ __('Address Information') }}</h5>
                        <div class="max-w-[535px] w-full">
                            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                {{ __('Search Location') }}
                                <span class="flex items-center text-red-1200">*</span>
                            </label>
                            <div class="relative">
                                <input type="text" wire:model="map_address" id="google-places-input" value="{{ $map_address }}" class="text-blue-1200 pl-10 font-medium text-xs placeholder:text-blue-1200 bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Search for a location...') }}" />
                                <span class="flex items-center absolute left-3.5 top-1/2 -translate-y-1/2">
                                    <svg width="21" height="25" viewBox="0 0 21 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M17.9247 3.62618C19.8524 5.55367 20.955 8.15532 20.9992 10.881C21.0434 13.6067 20.0258 16.2427 18.1616 18.2317L17.9247 18.4767L12.9746 23.4257C12.3465 24.0534 11.5033 24.4189 10.6157 24.4481C9.72824 24.4774 8.86279 24.1682 8.19473 23.5832L8.02673 23.4257L3.0754 18.4755C1.10625 16.5064 0 13.8356 0 11.0508C0 8.26605 1.10625 5.59532 3.0754 3.62618C5.04454 1.65703 7.71527 0.550781 10.5001 0.550781C13.2849 0.550781 15.9556 1.65703 17.9247 3.62618ZM10.5001 7.55085C10.0404 7.55085 9.58531 7.64138 9.16067 7.81727C8.73603 7.99316 8.3502 8.25097 8.02519 8.57597C7.70019 8.90098 7.44238 9.28681 7.26649 9.71145C7.09059 10.1361 7.00006 10.5912 7.00006 11.0508C7.00006 11.5105 7.09059 11.9656 7.26649 12.3902C7.44238 12.8149 7.70019 13.2007 8.02519 13.5257C8.3502 13.8507 8.73603 14.1085 9.16067 14.2844C9.58531 14.4603 10.0404 14.5508 10.5001 14.5508C11.4283 14.5508 12.3186 14.1821 12.9749 13.5257C13.6313 12.8693 14.0001 11.9791 14.0001 11.0508C14.0001 10.1226 13.6313 9.23235 12.9749 8.57597C12.3186 7.91959 11.4283 7.55085 10.5001 7.55085Z"
                                            fill="#0172B1" />
                                    </svg>
                                </span>
                            </div>
                        </div>

                        <div class="mt-5">
                            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                {{ __('Street Address') }}
                                <span class="flex items-center text-red-1200">*</span>
                            </label>
                            <input type="text" wire:model.live="address_line_1" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Enter street address') }}" />
                            @error('address_line_1')
                                <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="grid grid-cols-1 gap-6 mt-5 sm:grid-cols-2">
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Latitude') }}
                                </label>
                                <input type="text" wire:model.live="latitude" readonly class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-gray-50 border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Latitude will be filled automatically') }}" />
                            </div>
                            <div>
                                <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                    {{ __('Longitude') }}
                                </label>
                                <input type="text" wire:model.live="longitude" readonly class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-gray-50 border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('Longitude will be filled automatically') }}" />
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 gap-6 mt-5 sm:grid-cols-3 md:mt-8">
                        <div class="">
                            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                {{ __('Country') }}
                                <span class="flex items-center text-red-1200">*</span>
                            </label>
                            <input type="text" wire:model.live="country_name" readonly class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-gray-50 border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="Country will be filled automatically" />
                            <input type="hidden" wire:model.live="country_code">
                            @error('country_name')
                                <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="">
                            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                {{ __('State/Province') }}
                                <span class="flex items-center text-red-1200">*</span>
                            </label>
                            <input type="text" wire:model.live="state_name" readonly class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-gray-50 border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('State will be filled automatically') }}" />
                            <input type="hidden" wire:model.live="state_code">
                            @error('state_name')
                                <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="">
                            <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                                {{ __('City') }}
                                <span class="flex items-center text-red-1200">*</span>
                            </label>
                            <input type="text" wire:model.live="city_name" readonly class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-gray-50 border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-11" placeholder="{{ __('City will be filled automatically') }}" />
                            @error('city_name')
                                <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="mt-5 md:mt-8">
                        <div wire:ignore>
                            <!-- Map component will be initialized here -->
                            <div id="location-map" class="w-full h-[300px]"></div>
                        </div>
                    </div>

                    {{-- Service Areas Section --}}
                    <div class="mt-6">
                        <label class="text-sm font-normal text-dark-blue leading-none flex items-center gap-2 mb-2.5">
                            {{ __('Service Areas') }}
                        </label>
                        <div class="flex flex-col gap-4">
                            <div>
                                <div class="relative">
                                    <div wire:loading wire:target="addServiceArea" class="absolute z-10 -translate-y-1/2 right-3 top-1/2">
                                        <div class="w-4 h-4 border-2 border-blue-600 border-t-transparent rounded-full animate-spin"></div>
                                    </div>
                                    <input type="text" id="service-area-input" x-data @keydown.enter.prevent="$wire.addServiceArea($el.value); $el.value = ''" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] w-full h-11 pr-10" placeholder="{{ __('Add service area and press Enter') }}" />
                                </div>
                                <p class="mt-1.5 text-xs text-dark-blue/60">{{ __('Type service area and press Enter. Areas will be linked to this location.') }}</p>
                            </div>
                            @if (!empty($service_areas))
                                <div class="flex flex-wrap items-center gap-4">
                                    @foreach ($service_areas as $index => $area)
                                        <div class="inline-flex items-center px-4 py-2 text-sm rounded-full bg-blue-50 text-blue-1200">
                                            <span>{{ $area }}</span>
                                            <button type="button" wire:click="removeServiceArea({{ $index }})" class="ml-2 text-blue-1200 hover:text-blue-800 focus:outline-none">
                                                <svg class="w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                                                </svg>
                                            </button>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                            @error('service_areas')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="pt-5 md:pt-16">
                        <button type="submit" wire:loading.attr="disabled" class="text-white font-semibold text-xs leading-none flex items-center justify-center ml-auto h-11 max-w-[189px] w-full rounded-md bg-blue-1200 disabled:opacity-50">
                            <span wire:loading.remove>{{ __('Save changes') }}</span>
                            <span wire:loading>{{ __('Saving...') }}</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('after_scripts')
    <script>
        let autocomplete;
        let map;
        let marker;

        function initializeMap() {
            // Get initial values from Livewire component
            const initialLat = {{ $latitude ?? 'null' }};
            const initialLng = {{ $longitude ?? 'null' }};

            const defaultLocation = {
                lat: initialLat || -34.397,
                lng: initialLng || 150.644
            };

            map = new google.maps.Map(document.getElementById('location-map'), {
                center: defaultLocation,
                zoom: 15
            });

            marker = new google.maps.Marker({
                map: map,
                position: defaultLocation,
                draggable: false
            });

            if (initialLat && initialLng) {
                marker.setVisible(true);
            }

            // Initialize Places Autocomplete
            autocomplete = new google.maps.places.Autocomplete(
                document.getElementById('google-places-input'), {
                    types: ['address']
                }
            );

            // Bind autocomplete to map
            autocomplete.bindTo('bounds', map);

            // Handle place selection
            autocomplete.addListener('place_changed', function() {
                const place = autocomplete.getPlace();

                if (!place.geometry) {
                    return;
                }

                // Update map
                if (place.geometry.viewport) {
                    map.fitBounds(place.geometry.viewport);
                } else {
                    map.setCenter(place.geometry.location);
                    map.setZoom(17);
                }

                // Update marker
                marker.setPosition(place.geometry.location);
                marker.setVisible(true);

                // Prepare data for Livewire
                const placeData = {
                    formatted_address: place.formatted_address,
                    latitude: place.geometry.location.lat(),
                    longitude: place.geometry.location.lng(),
                    address_components: place.address_components.map(component => ({
                        long_name: component.long_name,
                        short_name: component.short_name,
                        types: component.types
                    }))
                };

                // Send to Livewire
                @this.call('handlePlaceSelected', placeData);
            });
        }

        // Load Google Maps script
        function loadGoogleMapsScript() {
            const script = document.createElement('script');
            script.src = `https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}&libraries=places&callback=initializeMap`;
            script.defer = true;
            document.head.appendChild(script);
        }

        document.addEventListener('livewire:initialized', () => {
            loadGoogleMapsScript();
        });
    </script>
@endpush
