<div>
    <div class="">
        <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
            {{ __('Locations') }}
        </h4>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
            <div class="flex flex-col items-center justify-between md:flex-row mb-9">
                <div class="max-w-[535px] w-full md:mb-0 mb-4">
                    <h4 class="text-dark-blue font-medium sm:text-[22px] text-base tracking-[0.32px] mb-1 leading-normal">
                        {{ __('Manage Your Locations') }}
                    </h4>
                    <p class="text-dark-blue/[0.6] font-normal sm:text-sm text-xs leading-normal">
                        {{ __('Here you can add, edit, or remove the locations where you offer your services.') }}
                    </p>
                </div>
                @can('create', 'App\Models\User\UserLocation')
                    <a href="{{ route('dashboard.profile.location.create') }}" class="text-white font-semibold text-sm leading-none flex items-center justify-center ml-auto h-11 max-w-[216px] w-full rounded-md bg-blue-1200">
                        {{ __('Add New Location') }}
                    </a>
                @endcan
            </div>

            <div class="grid md:grid-cols-2 grid-cols-1 xl:gap-[30px] gap-4">
                @foreach ($locations as $location)
                    <div class="relative flex items-start p-4 bg-white {{ $location->primary_location ? 'border border-solid border-blue-1200' : '' }} rounded-14 shadow-7xl xl:p-8">
                        @if ($location->primary_location)
                            <span class="absolute right-3 top-3 text-blue-1200 border-[1.4px] border-solid border-blue-1200/[0.2] bg-blue-1200/[0.1] rounded-[4px] h-[19px] w-[60px] flex item-center justify-center font-medium text-[10px]">Primary</span>
                        @endif
                        <span class="flex justify-center item-center">
                            <img src="{{ asset('images/dashboard/images/location-icon.svg') }}" alt="" />
                        </span>
                        <div class="flex-1 w-full pl-3">
                            <h4 class="xl:text-2xl text-lg xl:max-w-full max-w-[205px] font-semibold leading-none text-dark-blue">
                                {{ $location->location_name }}
                            </h4>
                            <ul class="flex gap-4 mt-3 mb-4 item-center">
                                @if ($location->postal_code)
                                    <li><span class="flex text-xs font-normal leading-none text-blue-1200 md:text-sm item-center">{{ $location->postal_code }}</span></li>
                                @endif
                                <li><span class="flex text-xs font-normal leading-none text-blue-1200 md:text-sm item-center">{{ $location->address_line_1 }}</span></li>
                            </ul>
                            <ul class="mb-5">
                                <li class="flex items-center gap-2 mb-3 text-sm font-medium leading-none text-dark-blue">
                                    <strong class="inline-flex font-medium">{{ __('Contact :') }}</strong>
                                    <span class="inline-flex font-normal text-text-dark-blue">{{ $location->phone }}</span>
                                </li>
                                <li class="flex items-center gap-2 text-sm font-medium leading-none text-dark-blue">
                                    <strong class="inline-flex font-medium">{{ __('Email :') }}</strong>
                                    <span class="inline-flex font-normal text-text-dark-blue">{{ $location->email }}</span>
                                </li>
                            </ul>
                            <ul class="flex items-center gap-3.5">
                                @can('update', ['App\Models\User\UserLocation', $location->uuid])
                                    <li>
                                        <a href="{{ route('dashboard.profile.location.edit', $location->uuid) }}" class="flex items-center gap-2.5 border-r border-solid border-dark-blue py-px pr-3.5">
                                            <img src="{{ asset('images/dashboard/images/edit-icon.svg') }}" alt="">
                                            <p class="text-dark-blue gap-2.5 font-normal text-sm leading-none flex items-center">
                                                {{ __('Edit') }}
                                            </p>
                                        </a>
                                    </li>
                                @endcan
                                @can('delete',['App\Models\User\UserLocation',$location->uuid])
                                <li>
                                    <button type="button" wire:click="mountAction('delete', { uuid: '{{ $location->uuid }}' })" class="text-red-1200 font-normal text-sm leading-none flex items-center md:gap-2.5 gap-1">
                                        <x-heroicon-o-trash class="w-4 h-4" />
                                        {{ __('Remove') }}
                                    </button>
                                </li>
                                @endcan
                            </ul>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    {{-- Add Filament Actions --}}
    <x-filament-actions::modals />
</div>
