<div>
    <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
        {{ __('Profile Photos') }}
    </h4>
    <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
        <div class="mb-8 lg:mb-20 sm:mb-12">
            <h4 class="text-dark-blue font-medium sm:text-22 text-base tracking-32p sm:mb-3.5 mb-2 leading-none">
                {{ __('Upload and Manage Your Profile Photos') }}
            </h4>
            <p class="text-dark-blue/[0.6] font-normal sm:text-sm text-xs sm:leading-none leading-normal">
                {{ __('Upload your company logo and cover image to your profile.') }}
            </p>
        </div>
        <form wire:submit="saveChanges">
            <div class="flex md:flex-row flex-col items-center gap-[30px]">
                <!-- Logo Upload Section -->
                <div class="md:max-w-[262px] max-w-full w-full">
                    <h5 class="mb-4 text-base font-medium text-dark-blue">{{ __('Logo Image') }}</h5>
                    <label class="flex flex-col items-center cursor-pointer">
                        <input type="file" wire:model="logo" class="hidden" accept="image/png,image/jpeg,image/jpg,image/webp" />
                        <div class="border-dashed w-full border border-text-blue/[0.4] rounded-md flex items-center justify-center flex-col pt-4 pb-8">
                            <div class="relative w-full h-[193px]">
                                @if (!$tempLogoUrl && !$existingLogoUrl)
                                    <div class="absolute inset-0 flex items-center justify-center">
                                        <img src="{{ asset('images/dashboard/images/picture-img.png') }}" alt="{{ __('Upload logo') }}" class="w-[80px] h-[80px] object-contain" />
                                    </div>
                                @endif
                                <img src="{{ $tempLogoUrl ?? ($existingLogoUrl ?? asset('images/dashboard/images/default-logo.png')) }}" alt="{{ __('Profile Logo') }}" class="absolute inset-0 w-full h-full object-cover rounded-xl {{ !$tempLogoUrl && !$existingLogoUrl ? 'hidden' : '' }}" wire:loading.class="opacity-50" />
                                @if ($existingLogoUrl || $tempLogoUrl)
                                    <button type="button" wire:click="{{ $tempLogoUrl ? 'clearTemporaryLogo' : 'deleteLogo' }}" wire:loading.attr="disabled" class="absolute top-2.5 left-2.5 flex items-center justify-center rounded-md bg-white border border-solid border-dark-blue/[0.1] w-[30px] h-[30px] shadow-6xl hover:bg-red-50">
                                        <img src="{{ asset('images/dashboard/images/delete-icon.svg') }}" alt="{{ __('Delete icon') }}" />
                                    </button>
                                @endif
                                <div wire:loading wire:target="logo" class="absolute inset-0 flex items-center justify-center bg-white/80 rounded-xl">
                                    <div class="flex flex-col items-center gap-2">
                                        <div class="w-8 h-8 border-b-2 rounded-full animate-spin border-blue-1200"></div>
                                        <span class="text-xs text-dark-blue">{{ __('Uploading...') }}</span>
                                    </div>
                                </div>
                            </div>

                            <h4 class="flex items-center justify-center gap-1 mt-5 mb-2 text-xs font-normal leading-none text-dark-blue">
                                {{ __('Drop your image here, or') }}
                                <span class="font-semibold text-blue-1200">{{ __('Browse') }}</span>
                            </h4>
                            <p class="text-dark-blue/[0.4] font-normal text-[8px] text-center leading-none mb-2">
                                {{ __('Minimum Size 100x100') }}
                            </p>
                            <p class="text-dark-blue/[0.4] font-normal text-[8px] text-center leading-none">
                                {{ __('Supports: PNG, JPG, JPEG, WEBP') }}
                            </p>
                        </div>
                        @error('logo')
                            <div class="flex items-center p-4 mt-4 text-red-800 border border-red-300 rounded-lg bg-red-50">
                                <svg class="flex-shrink-0 w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                </svg>
                                <div class="ml-3 text-sm font-medium">
                                    {{ $message }}
                                </div>
                            </div>
                        @enderror
                    </label>

                    <div class="w-full mb-6 mt-5 flex items-center justify-center relative after:absolute after:content='' after:w-full after:h-px after:bg-dark-blue/[0.2] after:left-0 after:top-1/2 after:-translate-y-1/2">
                        <span class="text-dark-blue/[0.2] font-normal text-[10px] leading-none bg-white px-2 relative z-[9]">{{ __('Or') }}</span>
                    </div>

                    <div class="w-full">
                        <h4 class="mb-2 text-xs font-normal leading-none text-dark-blue">
                            {{ __('Import from URL') }}
                        </h4>
                        <div class="relative">
                            <input type="text" wire:model="logoUrl" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.25] bg-blue-1200/[0.04] border border-solid border-dark-blue/[0.10] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-10" placeholder="{{ __('Add file URL') }}" />
                        </div>
                        @error('logoUrl')
                            <span class="mt-2 text-sm text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <!-- Cover Upload Section -->
                <div class="flex-1 w-full">
                    <h5 class="mb-4 text-base font-medium text-dark-blue">{{ __('Cover Image') }}</h5>
                    <label class="flex flex-col items-center cursor-pointer">
                        <input type="file" wire:model="cover" class="hidden" accept="image/png,image/jpeg,image/jpg,image/webp" />
                        <div class="border-dashed w-full border border-text-blue/[0.4] rounded-md flex items-center justify-center flex-col pt-4 pb-8">
                            <div class="relative w-full h-[193px]">
                                @if (!$tempCoverUrl && !$existingCoverUrl)
                                    <div class="absolute inset-0 flex items-center justify-center">
                                        <img src="{{ asset('images/dashboard/images/picture-img.png') }}" alt="{{ __('Upload cover') }}" class="w-[80px] h-[80px] object-contain" />
                                    </div>
                                @endif
                                <img src="{{ $tempCoverUrl ?? ($existingCoverUrl ?? asset('images/dashboard/images/default-cover.png')) }}" alt="{{ __('Cover Image') }}" class="absolute inset-0 w-full h-full object-cover rounded-xl {{ !$tempCoverUrl && !$existingCoverUrl ? 'hidden' : '' }}" wire:loading.class="opacity-50" />
                                @if ($existingCoverUrl || $tempCoverUrl)
                                    <button type="button" wire:click="{{ $tempCoverUrl ? 'clearTemporaryCover' : 'deleteCover' }}" wire:loading.attr="disabled" class="absolute top-2.5 left-2.5 flex items-center justify-center rounded-md bg-white border border-solid border-dark-blue/[0.1] w-[30px] h-[30px] shadow-6xl hover:bg-red-50">
                                        <img src="{{ asset('images/dashboard/images/delete-icon.svg') }}" alt="{{ __('Delete icon') }}" />
                                    </button>
                                @endif
                                <div wire:loading wire:target="cover" class="absolute inset-0 flex items-center justify-center bg-white/80 rounded-xl">
                                    <div class="flex flex-col items-center gap-2">
                                        <div class="w-8 h-8 border-b-2 rounded-full animate-spin border-blue-1200"></div>
                                        <span class="text-xs text-dark-blue">{{ __('Uploading...') }}</span>
                                    </div>
                                </div>
                            </div>

                            <h4 class="flex items-center justify-center gap-1 mt-5 mb-2 text-xs font-normal leading-none text-dark-blue">
                                {{ __('Drop your image here, or') }}
                                <span class="font-semibold text-blue-1200">{{ __('Browse') }}</span>
                            </h4>
                            <p class="text-dark-blue/[0.4] font-normal text-[8px] text-center leading-none mb-2">
                                {{ __('Minimum Size 100x100') }}
                            </p>
                            <p class="text-dark-blue/[0.4] font-normal text-[8px] text-center leading-none">
                                {{ __('Supports: PNG, JPG, JPEG, WEBP') }}
                            </p>
                        </div>
                        @error('cover')
                            <div class="flex items-center p-4 mt-4 text-red-800 border border-red-300 rounded-lg bg-red-50">
                                <svg class="flex-shrink-0 w-4 h-4" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                                </svg>
                                <div class="ml-3 text-sm font-medium">
                                    {{ $message }}
                                </div>
                            </div>
                        @enderror
                    </label>

                    <div class="w-full mb-6 mt-5 flex items-center justify-center relative after:absolute after:content='' after:w-full after:h-px after:bg-dark-blue/[0.2] after:left-0 after:top-1/2 after:-translate-y-1/2">
                        <span class="text-dark-blue/[0.2] font-normal text-[10px] leading-none bg-white px-2 relative z-[9]">{{ __('Or') }}</span>
                    </div>

                    <div class="w-full">
                        <h4 class="mb-2 text-xs font-normal leading-none text-dark-blue">
                            {{ __('Import from URL') }}
                        </h4>
                        <div class="relative">
                            <input type="text" wire:model="coverUrl" class="text-dark-blue font-normal text-xs placeholder:text-dark-blue/[0.25] bg-blue-1200/[0.04] border border-solid border-dark-blue/[0.10] rounded-md shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-10" placeholder="{{ __('Add file URL') }}" />
                        </div>
                        @error('coverUrl')
                            <span class="mt-2 text-sm text-red-500">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="flex justify-end mt-8">
                <button type="submit" wire:loading.attr="disabled" class="text-white font-semibold text-xs leading-none flex items-center justify-center h-11 max-w-[189px] w-full rounded-md bg-blue-1200 hover:bg-blue-1300 transition-colors disabled:opacity-70">
                    <span wire:loading.remove wire:target="saveChanges">{{ __('Save Changes') }}</span>
                    <span wire:loading wire:target="saveChanges">{{ __('Saving...') }}</span>
                </button>
            </div>
        </form>
    </div>
</div>
