<div>
    <div class="">
        <h4 class="font-semibold xl:mb-11 mb-6 tracking-[-0.11px] leading-none xl:text-[32px] text-2xl text-black-1200">
            {{ __('Services') }}
        </h4>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6 mb-6">
            <div class="flex flex-col justify-between mb-5 sm:flex-row sm:items-center sm:mb-6">
                <div>
                    <h4 class="text-dark-blue font-medium sm:text-22 text-base tracking-[0.32px] mb-1 leading-normal">
                        {{ __('Profile Highlights') }}
                    </h4>
                    <p class="text-dark-blue/[0.6] font-normal sm:text-sm text-xs leading-normal">
                        {{ __('Showcase your expertise and unique selling points') }}
                    </p>
                </div>
            </div>
            <form wire:submit="saveProfileMeta">
                {{ $this->form }}

                <div class="flex justify-end mt-6">
                    <button type="submit" class="inline-flex items-center px-4 py-2 text-sm font-medium text-white rounded-md border border-transparent shadow-sm bg-blue-1200 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        {{ __('Save Highlights') }}
                    </button>
                </div>
            </form>
        </div>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 p-6">
            <div class="flex flex-col justify-between mb-5 sm:flex-row sm:items-center sm:mb-9">
                <div class="mb-5 sm:mb-0">
                    <h4 class="text-dark-blue font-medium sm:text-22 text-base tracking-[0.32px] mb-1 leading-normal">
                        {{ __('Add/Edit Service') }}
                    </h4>
                    <p class="text-dark-blue/[0.6] font-normal sm:text-sm text-xs leading-normal">
                        {{ __('Add or edit your service information') }}
                    </p>
                </div>
                <button type="button"
                    x-data
                    @click="$dispatch('open-modal', 'add-service-modal')"
                    class="text-white font-semibold text-sm gap-2.5 leading-none flex items-center justify-center ml-auto h-11 sm:max-w-[178px] max-w-full w-full rounded-md bg-blue-1200">
                    <x-heroicon-s-plus-circle class="w-6 h-6" />
                    {{ __('Add New') }}
                </button>
            </div>

            <div wire:sortable="reorder"
                wire:sortable.options="{ animation: 150, handle: '.drag-handle', dragClass: 'opacity-50' }"
                class="space-y-4">
                @foreach ($services as $service)
                    <div wire:key="service-{{ $service->uuid }}"
                        wire:sortable.item="{{ $service->uuid }}"
                        class="transition-all duration-200">
                        <div class="flex border border-solid border-dark-blue/[0.1] rounded-14 hover:shadow-lg transition-shadow duration-200">
                            <div class="drag-handle md:max-w-[87px] sm:max-w-[60px] max-w-9 w-full border-r border-solid border-dark-blue/[0.1] flex items-center justify-center cursor-move hover:bg-gray-50">
                                <x-heroicon-o-bars-4 class="w-6 h-6 text-gray-400 pointer-events-none" />
                            </div>
                            <div class="flex-1 w-full md:px-[22px] md:py-8 sm:p-5 p-2.5" wire:sortable.handle.stop>
                                <div class="flex flex-col-reverse justify-between items-start mb-2.5 sm:flex-row sm:items-center sm:mb-4">
                                    <h4 class="text-sm font-medium leading-normal text-black-1300 md:text-lg sm:text-base sm:leading-none">
                                        {{ $service->service_title }}</h4>
                                    <ul class="flex gap-3.5 items-center">
                                        <li>
                                            <button type="button"
                                                wire:click.stop="editService('{{ $service->uuid }}')"
                                                class="flex gap-2.5 items-center py-px pr-3.5 border-r border-solid border-dark-blue">
                                                <img src="{{ asset('images/dashboard/images/edit-icon.svg') }}" alt="">
                                                <p class="flex gap-2.5 items-center text-sm font-normal leading-none text-dark-blue">
                                                    {{ __('Edit') }}
                                                </p>
                                            </button>
                                        </li>
                                        <li>
                                            <button type="button"
                                                wire:click.stop="mountAction('delete', { uuid: '{{ $service->uuid }}' })"
                                                class="flex gap-1 items-center text-sm font-normal leading-none text-red-1200 md:gap-2.5">
                                                <x-heroicon-o-trash class="w-4 h-4" />
                                                {{ __('Remove') }}
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <p class="text-black-1300 md:text-base sm:text-xs text-[10px] font-normal leading-normal">
                                    {{ str()->limit($service->service_description, 200) }}
                                </p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Service Modal -->
    <div x-data="{
        show: false,
        closeModal() {
            this.show = false;
            $wire.resetForm();
        }
    }"
        x-show="show"
        x-on:open-modal.window="$event.detail == 'add-service-modal' ? show = true : null"
        x-on:close-modal.window="closeModal"
        x-on:close.window="closeModal"
        x-on:keydown.escape.window="closeModal"
        class="overflow-y-auto fixed inset-0 z-50"
        style="display: none;">
        <div class="flex justify-center items-center px-4 pt-4 pb-20 min-h-screen text-center sm:block sm:p-0">
            <div x-show="show"
                x-transition:enter="ease-out duration-300"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in duration-200"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity"
                aria-hidden="true">
            </div>

            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <div x-show="show"
                x-transition:enter="ease-out duration-300"
                x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                x-transition:leave="ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                class="inline-block overflow-hidden px-4 pt-5 pb-4 text-left align-bottom bg-white rounded-lg shadow-xl transition-all transform sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full sm:p-6">

                <div class="hidden absolute top-0 right-0 pt-4 pr-4 sm:block">
                    <button type="button"
                        @click="closeModal"
                        class="text-gray-400 bg-white rounded-md hover:text-gray-500 focus:outline-none">
                        <span class="sr-only">{{ __('Close') }}</span>
                        <svg class="w-6 h-6"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round"
                                stroke-linejoin="round"
                                stroke-width="2"
                                d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>

                <div class="sm:flex sm:items-start">
                    <div class="mt-3 w-full text-center sm:mt-0 sm:text-left">
                        <h3 class="text-lg font-medium leading-6 text-gray-900">
                            {{ $editingService ? 'Edit Service' : 'Add New Service' }}
                        </h3>

                        <form wire:submit="save" class="mt-6">
                            <div class="space-y-6">
                                <div>
                                    <label for="service_title" class="block text-sm font-medium text-dark-blue">
                                        {{ __('Service Title') }}
                                        <span class="text-red-1200">*</span>
                                    </label>
                                    <input type="text"
                                        id="service_title"
                                        wire:model="service_title"
                                        class="block w-full h-11 px-3 mt-1 text-dark-blue placeholder-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-sm focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                        placeholder="Enter service title"
                                        required>
                                    @error('service_title')
                                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="service_description" class="block text-sm font-medium text-dark-blue">
                                        {{ __('Service Description') }}
                                        <span class="text-red-1200">*</span>
                                    </label>
                                    <textarea id="service_description"
                                        wire:model="service_description"
                                        rows="6"
                                        class="block w-full px-3 py-2 mt-1 text-dark-blue placeholder-dark-blue/[0.4] bg-white border border-solid border-dark-blue/[0.2] rounded-md shadow-sm focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                                        placeholder="Enter service description"
                                        required></textarea>
                                    @error('service_description')
                                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div class="flex justify-end mt-6 space-x-3">
                                <button type="button"
                                    @click="closeModal"
                                    class="px-4 py-2 text-sm font-medium text-gray-700 bg-white rounded-md border border-gray-300 shadow-sm hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    {{ __('Cancel') }}
                                </button>
                                <button type="submit" class="px-4 py-2 text-sm font-medium text-white rounded-md border border-transparent shadow-sm bg-blue-1200 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                                    {{ $editingService ? __('Update') : __('Save') }}
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Add Filament Actions --}}
    <x-filament-actions::modals />
</div>
