<div>
    <div class="">
        <div class="flex sm:itesms-center items-start sm:flex-row flex-col justify-between xl:mb-11 mb-6">
            <h4 class="font-semibold  tracking-[-0.11px] leading-none xl:text-[32px] md:text-2xl text-base text-black-1200">
                {{ __('Client Reviews') }}
            </h4>
        </div>
        <div class="bg-white rounded-[14px] shadow-3xl xl:p-8 sm:p-6 p-[30px]">
            <h4 class="text-dark-blue font-semibold md:text-[22px] text-base tracking-[0.32px] leading-none sm:mb-10 mb-[26px]">Customer Feedback
            </h4>
            <div class="relative sm:mb-[18px] mb-[26px]">
                <form>
                    <div class="flex items-center justify-between xl:flex-row md:flex-col flex-row md:border border-0 border-solid border-dark-blue/[0.1] rounded-lg xl:p-4 md:p-2.5 p-0 md:gap-0 gap-3 md:mb-0 mb-[26px]">
                        <div class="relative w-full md:hidden block">
                            <input type="text" class="bg-white w-full pl-[41px] border border-solid border-dark-blue/[0.1] rounded-lg h-10 text-gray-1500 placeholder:text-gray-1500 font-normal text-xs shadow-none focus:border-gray-1200 focus:ring-0" placeholder="Search here">
                            <a href="#" class="flex items-center justify-center absolute left-5 top-1/2 -translate-y-1/2">
                                <img src="{{ asset('images/dashboard/images/search-icon2.svg') }}" alt="">
                            </a>
                        </div>
                        <div class="md:flex hidden items-center 2xl:gap-3 gap-2">
                            <a href="#" class="flex items-center justify-center w-[30px] h-[30px]"><img src="{{ asset('images/dashboard/images/filter-icon.svg') }}" alt="" /></a>
                            <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[143px] xl:w-[130px] w-[120px] h-10">
                                <option>Select Package</option>
                            </select>
                            <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[131px] w-[115px] h-10">
                                <option>Custom Date</option>
                            </select>
                            <div class="relative 2xl:w-[161px] w-[145px]">
                                <input type="text" id="dateRangeInput" class="text-dark-blue/[0.7]  font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 w-full h-10 pl-10" placeholder="Select Date Range" />
                                <span class="flex items-center absolute left-3.5 top-1/2 -translate-y-1/2"><img src="{{ asset('images/dashboard/images/calendar-icon.svg') }}" alt="" /><span>
                            </div>
                            <ul class="flex items-center 2xl:gap-x-4 gap-x-2">
                                <li>
                                    <div class="flex items-center">
                                        <input id="checked-checkbox" type="checkbox" value="" class="w-[18px] h-[18px] text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="checked-checkbox" class="2xl:ms-3 ms-2 2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">Check
                                            box</label>
                                    </div>
                                </li>
                                <li>
                                    <div class="flex items-center">
                                        <input checked id="checked-checkbox2" type="checkbox" value="" class="w-[18px] h-[18px] text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                        <label for="checked-checkbox2" class="2xl:ms-3 ms-2  2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">Check
                                            box</label>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <div class="xl:w-auto md:w-full w-auto md:flex-auto flex-1 xl:mt-0 md:mt-4 mt-0">
                            <ul class="flex items-center justify-end 2xl:gap-3 gap-2">
                                <li><a href="#." class="filter-btn rounded-lg h-10 w-[43px] bg-blue-1200/[0.2] flex items-center justify-center">
                                        <img src="{{ asset('images/dashboard/images/filter-icon2.svg') }}" alt="" /> </a></li>
                                <li class="md:block hidden"><a href="#" class="text-white font-normal 2xl:text-xs text-[10px] rounded-lg h-10 2xl:w-[113px] w-[90px] bg-blue-1200 flex items-center justify-center">Appy
                                        Filters</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="advance-filter z-20 absolute left-0 xl:top-[74px] md:top-[120px] top-11  w-full rounded-b-lg border mt-[-5px] hidden border-solid border-dark-blue/[0.1] bg-white shadow-8xl p-4">
                        <h4 class="text-dark-blue/[0.7] font-medium text-xs leading-none mb-4">More Filters</h4>
                        <div class="flex md:flex-nowrap flex-wrap items-center md:gap-3 sm:gap-0 gap-4 md:mb-2.5 mb-5 md:mx-0 sm:-mx-1.5">
                            <div class="md:w-auto sm:w-4/12 w-full md:px-0 sm:px-1.5">
                                <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 md:w-[130px] w-full h-10">
                                    <option>Select option</option>
                                </select>
                            </div>
                            <div class="md:w-auto sm:w-4/12 w-full md:px-0 sm:px-1.5 px-0">
                                <input type="text" class="text-dark-blue/[0.7]  !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[183px] xl:w-[130px] md:w-[120px] w-full h-10" placeholder="Another Field" />
                            </div>
                            <div class="md:w-auto sm:w-4/12 w-full md:px-0 sm:px-1.5 px-0">
                                <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 2xl:w-[140px] xl:w-[130px] md:w-[120px] w-full h-10">
                                    <option>Select option 2</option>
                                </select>
                            </div>
                            <div class="md:w-auto w-full md:mt-0 mt-3 md:px-0 sm:px-1.5 px-0">
                                <ul class="flex items-center gap-4">
                                    <li>
                                        <div class="flex items-center">
                                            <input id="default-radio-1" type="radio" value="" name="default-radio" class="w-4 h-4 cursor-pointer text-blue-600 bg-white border-[1.5px] border-solid border-dark-blue/[0.2] focus:ring-transparent focus:ring-0 ">
                                            <label for="default-radio-1" class="ms-3 text-sm cursor-pointer  font-normal text-dark-blue/[0.7] leading-none">Option
                                                1</label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex items-center">
                                            <input id="default-radio-2" type="radio" value="" name="default-radio" class="w-4 h-4 cursor-pointer text-blue-600 bg-white border-[1.5px] border-solid border-dark-blue/[0.2] focus:ring-transparent focus:ring-0 ">
                                            <label for="default-radio-2" class="ms-3 text-sm cursor-pointer  font-normal text-dark-blue/[0.7] leading-none">Option
                                                1</label>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="flex md:flex-row flex-col items-center gap-3">
                            <div class="md:w-auto w-full">
                                <select class="text-dark-blue/[0.7] !pr-6 font-normal 2xl:text-xs text-[10px] bg-white border border-solid border-dark-blue/[0.1] rounded-lg shadow-none focus:ring-transparent focus:border-dark-blue/[0.2] focus-ringo-0 md:w-[130px] w-full h-10">
                                    <option>Select option</option>
                                </select>
                            </div>
                            <div class="md:w-auto w-full">
                                <ul class="flex sm:flex-nowrap flex-wrap items-center gap-4">
                                    <li>
                                        <div class="flex items-center">
                                            <input id="checked-checkbox3" type="checkbox" value="" class="w-[18px] h-[18px] cursor-pointer text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="checked-checkbox3" class="2xl:ms-3 cursor-pointer ms-2 2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">Check
                                                One</label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex items-center">
                                            <input checked="" id="checked-checkbox4" type="checkbox" value="" class="w-[18px] cursor-pointer h-[18px] text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="checked-checkbox4" class="2xl:ms-3 ms-2 cursor-pointer  2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">Check
                                                Two</label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="flex items-center">
                                            <input id="checked-checkbox5" type="checkbox" value="" class="w-[18px] cursor-pointer h-[18px] text-blue-1200 bg-white border-dark-blue/[0.2] rounded-[2.25px] focus:ring-transparent dark:focus:ring-transparent focus:ring-0">
                                            <label for="checked-checkbox5" class="2xl:ms-3 ms-2 cursor-pointer  2xl:text-sm text-xs font-normal leading-none text-dark-blue/[0.7] dark:text-gray-300">Check
                                                Three</label>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="flex items-center justify-end gap-3 mt-5">
                            <a href="#" class="filter-close text-blue-1200 hover:bg-blue-1200 hover:text-white border-2 border-solid border-blue-1200 font-normal text-sm leading-none flex items-center justify-center h-[34px] max-w-[78px] w-full rounded-lg">Close</a>
                            <a href="#" class="text-white border-2 hover:bg-transparent hover:text-black-1200 border-solid border-blue-1200 font-normal text-sm leading-none flex items-center justify-center h-[34px] max-w-[78px] w-full rounded-lg bg-blue-1200">Appy</a>
                        </div>
                    </div>
                </form>
            </div>

            <p class="text-dark-blue sm:mb-0 mb-[26px] font-medium text-sm leading-normal sm:hidden block">{{ $reviews->total() }} {{ __('Records found') }}</p>
            @if ($reviews->count() > 0)
                @foreach ($reviews as $review)
                    <x-dashboard.reviews.review-card-v1 :review="$review" />
                @endforeach
            @else
                <x-common.no-records-found>
                    <x:slot name="icon">
                        <x-icon-magnifier-minus class="w-12 h-12" />
                    </x:slot>
                    <x:slot name="title">
                        {{ __('No reviews found') }}
                    </x:slot>
                    <x:slot name="description">
                        {{ __('No reviews found') }}
                    </x:slot>
                </x-common.no-records-found>
            @endif
            @if ($reviews->isNotEmpty())
                <div class="flex items-center justify-center">
                    {{ $reviews->links('vendor.livewire.esp-theme-simple-pagination') }}
                </div>
            @endif
        </div>
    </div>
</div>
