<div>
    <div class="flow-root">
        <ul role="list">
            @foreach($audits as $audit)
                <li class="">
                    <div class="relative pb-8">
                        @if(!$loop->last)
                            <span class="absolute left-4 top-4 -ml-px h-full w-0.5 bg-gray-200" aria-hidden="true"></span>
                        @endif
                        <div class="relative flex items-start">
                            <div class="relative">
                                <div class="flex items-center justify-center w-8 h-8">
                                    <div class="w-3 h-3 bg-gray-300 rounded-full"></div>
                                </div>
                            </div>
                            <div class="flex-grow ml-4">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <div class="text-sm font-medium text-info-700">
                                            @if(isset($audit->event))
                                                @if($audit->event === 'created')
                                                    {{ __('Added') }} {{ count($audit->new_values) }} {{ __('fields') }}
                                                @elseif($audit->event === 'deleted')
                                                    {{ __('Removed') }} {{ count($audit->old_values) }} {{ __('fields') }}
                                                @else   
                                                    {{ __('Modified') }} {{ count($audit->new_values) }} {{ __('attributes/settings') }}
                                                @endif
                                            @endif
                                        </div>
                                        <div class="text-sm font-semibold text-gray-600">
                                            {{ __('By') }} {{ $audit->user->name ?? 'System' }} | {{ $audit->created_at->diffForHumans() }}
                                        </div>
                                    </div>
                                    {{-- <div>
                                        <button class="flex px-3 py-1 text-sm font-medium text-white border rounded-md border-warning-300 bg-warning-300 hover:bg-warning-100 hover:text-gray-900">
                                            <x-heroicon-o-arrow-uturn-left class="flex w-4 h-4 mr-2" /> {{ __('Revert') }}
                                        </button>
                                    </div> --}}
                                </div>
                                
                                @if($audit->event === 'updated')
                                    <div class="mt-2 space-y-2">
                                        @foreach($audit->new_values as $field => $value)
                                            <div class="text-sm text-gray-600">
                                                {{ __('Modified') }} {{ str_replace('_', ' ', $field) }} {{ __('value from') }} <span class="font-semibold text-gray-900">"{{ $audit->old_values[$field] ?? 'empty' }}"</span> {{ __('to') }} <span class="font-semibold text-gray-900">"{{ $value }}"</span>
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </li>
            @endforeach
        </ul>
    </div>
</div>
