@php
    use Illuminate\Support\Arr;
@endphp
<div>
    <div class="space-y-6">
        {{-- Contact Information --}}
        <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
            <div class="flex items-center gap-3 mb-6">
                <div class="p-2 rounded-lg bg-blue-50">
                    <x-heroicon-m-user class="w-5 h-5 text-blue-500" />
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900">{{ __('Personal Information') }}</h3>
                    <p class="text-sm text-gray-500">{{ __('Member\'s contact details') }}</p>
                </div>
            </div>

            <div class="grid gap-6 sm:grid-cols-2">
                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-user class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Full Name') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->name }}</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-envelope class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Email') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->email }}</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-phone class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Phone') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->profile?->phone ?? 'Not provided' }}</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-device-phone-mobile class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Mobile') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->profile?->mobile ?? 'Not provided' }}</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-phone class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Fax') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->profile?->fax ?? 'Not provided' }}</div>
                    </div>
                </div>

                <div class="flex items-start gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-map-pin class="h-5 w-5 text-gray-400 mt-0.5" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Address') }}</div>
                        <div class="text-sm font-medium text-gray-900">
                            <a href="{{ $member->mapUrl ?? '#' }}" target="_blank" class="text-primary-blue">{{ $member->address() ?? 'Not provided' }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Basic Company Information --}}
        <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
            <div class="flex items-center gap-3 mb-6">
                <div class="p-2 rounded-lg bg-blue-50">
                    <x-heroicon-m-building-office class="w-5 h-5 text-blue-500" />
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900">{{ __('Company Information') }}</h3>
                    <p class="text-sm text-gray-500">{{ __('Business details and profile') }}</p>
                </div>
            </div>

            <div class="grid gap-6 sm:grid-cols-2">
                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-building-office class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Company Name') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->profile?->company_name ?? 'Not provided' }}</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-globe-alt class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Website') }}</div>
                        <div class="text-sm font-medium text-gray-900">
                            @if ($member->profile?->website)
                                <a href="{{ $member->profile->website }}" target="_blank" class="text-primary-blue hover:underline">
                                    {{ str($member->profile->website)->after('://')->limit(30) }}
                                </a>
                            @else
                                Not provided
                            @endif
                        </div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-calendar class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Year Established') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->profile?->year_established ?? 'Not provided' }}</div>
                    </div>
                </div>

                <div class="flex items-center gap-3 p-3 rounded-lg bg-gray-50/50">
                    <x-heroicon-m-chat-bubble-left-right class="w-5 h-5 text-gray-400" />
                    <div>
                        <div class="text-sm font-medium text-gray-500">{{ __('Company Slogan') }}</div>
                        <div class="text-sm font-medium text-gray-900">{{ $member->profile?->slogan ?? 'Not provided' }}</div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Company Description & Services --}}
        <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
            <div class="flex items-center gap-3 mb-6">
                <div class="p-2 rounded-lg bg-green-50">
                    <x-heroicon-m-document-text class="w-5 h-5 text-green-500" />
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900">{{ __('Company Description & Services') }}</h3>
                    <p class="text-sm text-gray-500">{{ __('Detailed description and service areas') }}</p>
                </div>
            </div>

            <div class="space-y-6">
                <div class="p-4 rounded-lg bg-gray-50/50">
                    <div class="prose-sm prose text-gray-900 max-w-none">{!! $member->profile?->about ?? 'No company description provided' !!}</div>
                </div>

                <div class="p-4 rounded-lg bg-gray-50/50">
                    <div class="mb-2 text-sm font-medium text-gray-500">{{ __('Service Areas') }}</div>
                    <div class="mt-1">
                        @if ($member->profile?->service_areas && count($member->profile->service_areas) > 0)
                            <div class="flex flex-wrap gap-2">
                                @foreach ($member->profile->service_areas as $area)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-50 text-blue-700">
                                        {{ $area }}
                                    </span>
                                @endforeach
                            </div>
                        @else
                            <span class="text-sm font-medium text-gray-900">{{ __('No service areas specified') }}</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        {{-- Professional Credentials & Awards --}}
        <div class="grid gap-6 lg:grid-cols-2">
            {{-- Credentials --}}
            <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
                <div class="flex items-center gap-3 mb-6">
                    <div class="p-2 rounded-lg bg-indigo-50">
                        <x-heroicon-m-academic-cap class="w-5 h-5 text-indigo-500" />
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-gray-900">{{ __('Professional Credentials') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Certifications and qualifications') }}</p>
                    </div>
                </div>

                <div class="space-y-3">
                    @if ($member->profile?->credentials && count($member->profile->credentials) > 0)
                        @foreach ($member->profile->credentials as $credential)
                            @if (isset($credential['credential_type']) && isset($credential['credential_value']))
                                <div class="p-3 rounded-lg bg-gray-50/50 ring-1 ring-gray-100">
                                    <div class="flex items-center gap-2">
                                        <x-heroicon-m-check-badge class="w-5 h-5 text-indigo-500" />
                                        <div class="flex-1">
                                            <span class="text-xs text-gray-500 font-medium uppercase tracking-wide">
                                                {{ $credential['credential_type'] }}
                                            </span>
                                            <div class="text-sm font-medium text-gray-900">
                                                {{ $credential['credential_value'] }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                {{-- Support old format as fallback --}}
                                <div class="p-3 rounded-lg bg-gray-50/50 ring-1 ring-gray-100">
                                    <div class="flex items-center gap-2">
                                        <x-heroicon-m-check-badge class="w-5 h-5 text-indigo-500" />
                                        <span class="text-sm font-medium text-gray-900">
                                            {{ $credential['credential'] ?? '' }}
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @else
                        <div class="p-4 rounded-lg bg-gray-50/50">
                            <div class="flex items-center justify-center text-center">
                                <div class="max-w-sm space-y-1">
                                    <div class="flex justify-center">
                                        <div class="p-3 bg-gray-100 rounded-full">
                                            <x-heroicon-o-academic-cap class="w-6 h-6 text-gray-400" />
                                        </div>
                                    </div>
                                    <h4 class="text-sm font-medium text-gray-900">{{ __('No Credentials Listed') }}</h4>
                                    <p class="text-sm text-gray-500">{{ __('No professional credentials have been specified.') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Awards & Recognitions --}}
            <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
                <div class="flex items-center gap-3 mb-6">
                    <div class="p-2 rounded-lg bg-yellow-50">
                        <x-heroicon-m-trophy class="w-5 h-5 text-yellow-500" />
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-gray-900">{{ __('Awards & Recognitions') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Accomplishments and honors') }}</p>
                    </div>
                </div>

                <div class="space-y-3">
                    @if ($member->profile?->getMeta('awards_recognitions') && count($member->profile->getMeta('awards_recognitions')) > 0)
                        @foreach ($member->profile->getMeta('awards_recognitions') as $award)
                            <div class="p-3 rounded-lg bg-gray-50/50 ring-1 ring-gray-100">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <x-heroicon-m-trophy class="w-5 h-5 text-yellow-500" />
                                        <span class="text-sm font-medium text-gray-900">
                                            {{ $award['title'] ?? '' }}
                                        </span>
                                    </div>
                                    <span class="px-2 py-1 text-xs font-medium text-yellow-700 rounded bg-yellow-50">
                                        {{ $award['year'] ?? '' }}
                                    </span>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="p-4 rounded-lg bg-gray-50/50">
                            <div class="flex items-center justify-center text-center">
                                <div class="max-w-sm space-y-1">
                                    <div class="flex justify-center">
                                        <div class="p-3 bg-gray-100 rounded-full">
                                            <x-heroicon-o-trophy class="w-6 h-6 text-gray-400" />
                                        </div>
                                    </div>
                                    <h4 class="text-sm font-medium text-gray-900">{{ __('No Awards Listed') }}</h4>
                                    <p class="text-sm text-gray-500">{{ __('No awards or recognitions have been specified.') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Operating Hours --}}
        <div class="grid gap-6 lg:grid-cols-2">
            {{-- Regular Business Hours --}}
            <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
                <div class="flex items-center gap-3 mb-6">
                    <div class="p-2 rounded-lg bg-amber-50">
                        <x-heroicon-m-clock class="w-5 h-5 text-amber-500" />
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-gray-900">{{ __('Regular Business Hours') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Standard operating hours') }}</p>
                    </div>
                </div>

                <div class="space-y-3">
                    @if ($member->businessHours && $member->businessHours->count() > 0)
                        @foreach ($member->businessHours->sortBy(fn($hour) => array_search($hour->day_of_week->value, ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'])) as $businessHour)
                            <div class="flex items-center justify-between p-3 rounded-lg {{ $businessHour->is_open ? 'bg-success-50/50 ring-1 ring-success-100' : 'bg-red-50/50 ring-1 ring-red-100' }} ">
                                <div class="flex items-center gap-2">
                                    <span class="text-sm font-medium text-gray-900">
                                        {{ $businessHour->day_of_week->getLabel() }}
                                    </span>
                                    @if ($businessHour->hours_label)
                                        <span class="text-xs text-gray-500 font-regular px-1.5 py-0.5 bg-gray-100 rounded">
                                            {{ $businessHour->hours_label }}
                                        </span>
                                    @endif
                                </div>
                                <span class="text-sm text-gray-600 {{ $businessHour->is_open ? 'text-success-600' : 'text-red-600' }}">
                                    @if ($businessHour->is_open)
                                        {{ $businessHour->formatted_hours }}
                                    @else
                                        {{ __('Closed') }}
                                    @endif
                                </span>
                            </div>
                        @endforeach
                    @else
                        <div class="p-4 rounded-lg bg-gray-50/50">
                            <div class="flex items-center justify-center text-center">
                                <div class="max-w-sm space-y-1">
                                    <div class="flex justify-center">
                                        <div class="p-3 bg-gray-100 rounded-full">
                                            <x-heroicon-o-clock class="w-6 h-6 text-gray-400" />
                                        </div>
                                    </div>
                                    <h4 class="text-sm font-medium text-gray-900">{{ __('No Business Hours Set') }}</h4>
                                    <p class="text-sm text-gray-500">{{ __('Regular business hours have not been specified.') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Seasonal Hours --}}
            <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
                <div class="flex items-center gap-3 mb-6">
                    <div class="p-2 rounded-lg bg-orange-50">
                        <x-heroicon-m-calendar class="w-5 h-5 text-orange-500" />
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-gray-900">{{ __('Seasonal Hours') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Special hours for specific periods') }}</p>
                    </div>
                </div>

                <div class="space-y-3">
                    @if ($member->profile?->getMeta('seasonal_hours') && count($member->profile->getMeta('seasonal_hours')) > 0)
                        @foreach ($member->profile->getMeta('seasonal_hours') as $schedule)
                            <div class="p-3 rounded-lg {{ $schedule['is_open'] ? 'bg-success-50/50 ring-1 ring-success-100' : 'bg-red-50/50 ring-1 ring-red-100' }}">
                                <div class="flex items-center justify-between mb-2">
                                    <span class="text-sm font-medium text-gray-900">{{ $schedule['season_name'] }}</span>
                                    <span class="text-xs font-medium bg-gray-100 text-gray-700 px-2 py-0.5 rounded">
                                        {{ \Carbon\Carbon::parse($schedule['start_date'])->format('M d') }} - {{ \Carbon\Carbon::parse($schedule['end_date'])->format('M d, Y') }}
                                    </span>
                                </div>
                                @foreach($schedule['seasonal_days_with_hours'] as $hours)
                                    <div class="flex items-center justify-between">
                                        <span class="text-sm text-gray-600">{{ $hours['day'] }}</span>
                                        <span class="text-sm text-gray-600 {{ $schedule['is_open'] ? 'text-success-600' : 'text-red-600' }}">
                                            @if ($schedule['is_open'])
                                                {{ $hours['start_time'] }} - {{ $hours['end_time'] }}
                                            @else
                                                {{ __('Closed') }}
                                            @endif
                                        </span>
                                    </div>
                                @endforeach
                            </div>
                        @endforeach
                    @else
                        <div class="p-4 rounded-lg bg-gray-50/50">
                            <div class="flex items-center justify-center text-center">
                                <div class="max-w-sm space-y-1">
                                    <div class="flex justify-center">
                                        <div class="p-3 bg-gray-100 rounded-full">
                                            <x-heroicon-o-calendar class="w-6 h-6 text-gray-400" />
                                        </div>
                                    </div>
                                    <h4 class="text-sm font-medium text-gray-900">{{ __('No Seasonal Hours Set') }}</h4>
                                    <p class="text-sm text-gray-500">{{ __('No seasonal hours have been specified.') }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Membership Details --}}
        <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center gap-3">
                    <div class="p-2 rounded-lg bg-green-50">
                        <x-heroicon-m-credit-card class="w-5 h-5 text-green-500" />
                    </div>
                    <div>
                        <h3 class="text-base font-semibold text-gray-900">{{ __('Membership Details') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Current subscription and plan information') }}</p>
                    </div>
                </div>
                @php
                    $activeSubscription = $member->subscriptions()->where('is_active', true)->first();
                @endphp
                @if ($activeSubscription)
                    <div class="inline-flex items-center px-3 py-1 text-sm font-medium rounded-full bg-success-50 text-success-700">
                        <x-heroicon-m-check-circle class="mr-1.5 h-4 w-4" />
                        {{ __('Active Plan') }}
                    </div>
                @endif
            </div>

            <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
                <div class="p-4 rounded-lg bg-gray-50/50">
                    <div class="text-sm font-medium text-gray-500">{{ __('Current Plan') }}</div>
                    <div class="mt-1 text-sm font-medium text-gray-900">{{ $activeSubscription?->membershipPlan?->package_title ?? 'No Active Plan' }}</div>
                </div>

                <div class="p-4 rounded-lg bg-gray-50/50">
                    <div class="text-sm font-medium text-gray-500">{{ __('Status') }}</div>
                    <div class="mt-1 text-sm font-medium text-gray-900">{{ $activeSubscription?->status ?? 'Inactive' }}</div>
                </div>

                @if ($activeSubscription)
                    <div class="p-4 rounded-lg bg-gray-50/50">
                        <div class="text-sm font-medium text-gray-500">{{ __('Period Start') }}</div>
                        <div class="mt-1 text-sm font-medium text-gray-900">{{ $activeSubscription->current_period_start?->format('M d, Y') }}</div>
                    </div>
                    <div class="p-4 rounded-lg bg-gray-50/50">
                        <div class="text-sm font-medium text-gray-500">{{ __('Period End') }}</div>
                        <div class="mt-1 text-sm font-medium text-gray-900">{{ $activeSubscription->current_period_end?->format('M d, Y') }}</div>
                    </div>
                @endif

                <div class="p-4 rounded-lg bg-gray-50/50 @if (!$activeSubscription) sm:col-span-2 lg:col-span-2 @else lg:col-span-4 @endif">
                    <div class="text-sm font-medium text-gray-500">{{ __('Member Categories') }}</div>
                    <div class="mt-1">
                        @if ($member->memberCategories && $member->memberCategories->count() > 0)
                            <div class="flex flex-wrap gap-2">
                                @foreach ($member->memberCategories as $category)
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-50 text-green-700">
                                        {{ $category->category_name }}
                                    </span>
                                @endforeach
                            </div>
                        @else
                            <span class="text-sm font-medium text-gray-900">{{ __('No categories assigned') }}</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        {{-- Online Presence --}}
        <div class="p-6 bg-white shadow-sm rounded-xl ring-1 ring-gray-200">
            <div class="flex items-center gap-3 mb-6">
                <div class="p-2 rounded-lg bg-purple-50">
                    <x-heroicon-m-globe-alt class="w-5 h-5 text-purple-500" />
                </div>
                <div>
                    <h3 class="text-base font-semibold text-gray-900">{{ __('Online Presence') }}</h3>
                    <p class="text-sm text-gray-500">{{ __('Website and social media links') }}</p>
                </div>
            </div>

            <div class="grid gap-3 sm:grid-cols-2 lg:grid-cols-3">
                @if ($member->profile?->website)
                    <a href="{{ $member->profile->website }}" target="_blank" class="flex items-center justify-between p-3 transition-all duration-200 border border-transparent rounded-lg group bg-gray-50/50 hover:border-primary-100 hover:bg-primary-50/50">
                        <div class="flex items-center gap-3">
                            <div class="flex items-center justify-center w-10 h-10 bg-white rounded-lg shadow-sm ring-1 ring-gray-200/40">
                                <x-heroicon-m-globe-alt class="w-5 h-5 text-gray-400 group-hover:text-primary-500" />
                            </div>
                            <div class="flex flex-col">
                                <span class="text-sm font-medium text-gray-900">{{ __('Website') }}</span>
                                <span class="text-xs text-gray-500">{{ str($member->profile->website)->after('://')->limit(30) }}</span>
                            </div>
                        </div>
                        <div class="flex items-center gap-2">
                            <span class="text-xs font-medium transition-opacity duration-200 opacity-0 text-primary-600 group-hover:opacity-100">Visit Site</span>
                            <x-heroicon-m-arrow-top-right-on-square class="w-5 h-5 text-gray-400 transition-colors duration-200 group-hover:text-primary-500" />
                        </div>
                    </a>
                @endif

                @if ($member->profile?->social_media_links)
                    @php
                        $socialLinks = is_array($member->profile->social_media_links) ? $member->profile->social_media_links : json_decode($member->profile->social_media_links, true) ?? [];
                    @endphp

                    @foreach ($socialLinks as $platform => $url)
                        @if (!empty($url))
                            <a href="{{ $url }}" target="_blank" class="flex items-center justify-between p-3 transition-all duration-200 border border-transparent rounded-lg group bg-gray-50/50 hover:border-primary-100 hover:bg-primary-50/50">
                                <div class="flex items-center gap-3">
                                    <div class="flex items-center justify-center w-10 h-10 bg-white rounded-lg shadow-sm ring-1 ring-gray-200/40">
                                        @switch(strtolower($platform))
                                            @case('facebook')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#1877F2]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                                                </svg>
                                            @break

                                            @case('twitter')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#1DA1F2]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z" />
                                                </svg>
                                            @break

                                            @case('linkedin')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#0A66C2]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z" />
                                                </svg>
                                            @break

                                            @case('instagram')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#E4405F]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path
                                                        d="M12 0C8.74 0 8.333.015 7.053.072 5.775.132 4.905.333 4.14.63c-.789.306-1.459.717-2.126 1.384S.935 3.35.63 4.14C.333 4.905.131 5.775.072 7.053.012 8.333 0 8.74 0 12s.015 3.667.072 4.947c.06 1.277.261 2.148.558 2.913.306.788.717 1.459 1.384 2.126.667.666 1.336 1.079 2.126 1.384.766.296 1.636.499 2.913.558C8.333 23.988 8.74 24 12 24s3.667-.015 4.947-.072c1.277-.06 2.148-.262 2.913-.558.788-.306 1.459-.718 2.126-1.384.666-.667 1.079-1.335 1.384-2.126.296-.765.499-1.636.558-2.913.06-1.28.072-1.687.072-4.947s-.015-3.667-.072-4.947c-.06-1.277-.262-2.149-.558-2.913-.306-.789-.718-1.459-1.384-2.126C21.319 1.347 20.651.935 19.86.63c-.765-.297-1.636-.499-2.913-.558C15.667.012 15.26 0 12 0zm0 2.16c3.203 0 3.585.016 4.85.071 1.17.055 1.805.249 2.227.415.562.217.96.477 1.382.896.419.42.679.819.896 1.381.164.422.36 1.057.413 2.227.057 1.266.07 1.646.07 4.85s-.015 3.585-.074 4.85c-.061 1.17-.256 1.805-.421 2.227-.224.562-.479.96-.899 1.382-.419.419-.824.679-1.38.896-.42.164-1.065.36-2.235.413-1.274.057-1.649.07-4.859.07-3.211 0-3.586-.015-4.859-.074-1.171-.061-1.816-.256-2.236-.421-.569-.224-.96-.479-1.379-.899-.421-.419-.69-.824-.9-1.38-.165-.42-.359-1.065-.42-2.235-.045-1.26-.061-1.649-.061-4.844 0-3.196.016-3.586.061-4.861.061-1.17.255-1.814.42-2.234.21-.57.479-.96.9-1.381.419-.419.81-.689 1.379-.898.42-.166 1.051-.361 2.221-.421 1.275-.045 1.65-.06 4.859-.06l.045.03zm0 3.678c-3.405 0-6.162 2.76-6.162 6.162 0 3.405 2.76 6.162 6.162 6.162 3.405 0 6.162-2.76 6.162-6.162 0-3.405-2.76-6.162-6.162-6.162zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm7.846-10.405c0 .795-.646 1.44-1.44 1.44-.795 0-1.44-.646-1.44-1.44 0-.794.646-1.439 1.44-1.439.793-.001 1.44.645 1.44 1.439z" />
                                                </svg>
                                            @break

                                            @case('youtube')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#FF0000]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z" />
                                                </svg>
                                            @break

                                            @case('tiktok')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#000000]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path d="M19.59 6.69a4.83 4.83 0 0 1-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 0 1-5.2 1.74 2.89 2.89 0 0 1 2.31-4.64c.298-.002.595.042.88.13V9.4A6.33 6.33 0 0 0 5 20.1a6.34 6.34 0 0 0 10.86-4.43v-7a8.16 8.16 0 0 0 4.77 1.52v-3.4a4.85 4.85 0 0 1-1-.1z" />
                                                </svg>
                                            @break

                                            @case('pinterest')
                                                <svg class="h-5 w-5 text-gray-400 transition-colors duration-200 group-hover:text-[#E60023]" fill="currentColor" viewBox="0 0 24 24">
                                                    <path d="M12 0C5.373 0 0 5.372 0 12c0 5.084 3.163 9.426 7.627 11.174-.105-.949-.2-2.405.042-3.441.218-.937 1.407-5.965 1.407-5.965s-.359-.719-.359-1.782c0-1.668.967-2.914 2.171-2.914 1.023 0 1.518.769 1.518 1.69 0 1.029-.655 2.568-.994 3.995-.283 1.194.599 2.169 1.777 2.169 2.133 0 3.772-2.249 3.772-5.495 0-2.873-2.064-4.882-5.012-4.882-3.414 0-5.418 2.561-5.418 5.207 0 1.031.397 2.138.893 2.738.098.119.112.224.083.345l-.333 1.36c-.053.22-.174.267-.402.161-1.499-.698-2.436-2.889-2.436-4.649 0-3.785 2.75-7.262 7.929-7.262 4.163 0 7.398 2.967 7.398 6.931 0 4.136-2.607 7.464-6.227 7.464-1.216 0-2.359-.631-2.75-1.378l-.748 2.853c-.271 1.043-1.002 2.35-1.492 3.146C9.57 23.812 10.763 24 12 24c6.627 0 12-5.373 12-12 0-6.628-5.373-12-12-12z" />
                                                </svg>
                                            @break

                                            @default
                                                <x-heroicon-m-globe-alt class="w-5 h-5 text-gray-400 group-hover:text-primary-500" />
                                        @endswitch
                                    </div>
                                    <div class="flex flex-col">
                                        <span class="text-sm font-medium text-gray-900">{{ ucfirst($platform) }}</span>
                                        <span class="text-xs text-gray-500">{{ str($url)->after('://')->limit(30) }}</span>
                                    </div>
                                </div>
                                <div class="flex items-center gap-2">
                                    <span class="text-xs font-medium transition-opacity duration-200 opacity-0 text-primary-600 group-hover:opacity-100">Visit Profile</span>
                                    <x-heroicon-m-arrow-top-right-on-square class="w-5 h-5 text-gray-400 transition-colors duration-200 group-hover:text-primary-500" />
                                </div>
                            </a>
                        @endif
                    @endforeach
                @endif

                @if (!$member->profile?->website && empty(array_filter($member->profile?->social_media_links ?? [])))
                    <div class="p-4 rounded-lg bg-gray-50/50 sm:col-span-2 lg:col-span-3">
                        <div class="flex items-center justify-center text-center">
                            <div class="max-w-sm space-y-1">
                                <div class="flex justify-center">
                                    <div class="p-3 bg-gray-100 rounded-full">
                                        <x-heroicon-o-globe-alt class="w-6 h-6 text-gray-400" />
                                    </div>
                                </div>
                                <h4 class="text-sm font-medium text-gray-900">{{ __('No Online Presence') }}</h4>
                                <p class="text-sm text-gray-500">{{ __('This member hasn\'t added any website or social media links yet.') }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
