@props(['paginator', 'elements', 'scrollTo' => null])

@php
    if ($scrollTo === false) {
        $scrollIntoViewJs = '';
    } elseif (is_string($scrollTo)) {
        $scrollIntoViewJs = "document.querySelector('{$scrollTo}').scrollIntoView()";
    } else {
        $scrollIntoViewJs = 'document.body.scrollIntoView()';
    }
@endphp

{{-- only render pagination if there's at least one record --}}
@if ($paginator->total() > 0)
    <ul class="flex gap-2 justify-center items-center">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
            <li>
                <span class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid opacity-50 cursor-not-allowed group shadow-3xl border-gray-1200">
                    <x-icon-left-arrow2 />
                </span>
            </li>
        @else
            <li>
                <button wire:click="previousPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJs }}" class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl border-gray-1200 hover:bg-black-1200 hover:border-black-1200 hover:text-white cursor-pointer">
                    <x-icon-left-arrow2 class="group-hover:brightness-[100%] transition-all duration-500 ease-in-out" />
                </button>
            </li>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- Array Of Links --}}
            @if (is_array($element))
                @php
                    $currentPage = $paginator->currentPage();
                    $lastPage = $paginator->lastPage();
                @endphp

                @foreach ($element as $page => $url)
                    @php
                        // Show first 3, current page, and last 2 for both mobile and desktop
                        $showPage = $page <= 3 || 
                                  $page > ($lastPage - 2) || 
                                  $page == $currentPage;
                                         
                        // Show dots only once between visible page ranges
                        $showDots = $page == ($currentPage < ($lastPage - 2) ? $currentPage + 1 : $lastPage - 2) 
                                  && $currentPage < ($lastPage - 2);
                    @endphp
                    
                    @if ($showPage)
                        <li class="flex">
                            @if ($page == $currentPage)
                                <span class="flex justify-center items-center w-9 h-9 text-white rounded-full border border-solid group bg-black-1200 shadow-3xl border-black-1200 cursor-pointer">
                                    {{ $page }}
                                </span>
                            @else
                                <button wire:click="gotoPage({{ $page }}, '{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJs }}" class="flex justify-center items-center w-9 h-9 rounded-full border border-solid transition-all duration-500 ease-in-out group bg-gray-1400 text-mid-gray shadow-3xl hover:bg-black-1200 hover:text-white hover:border-black-1200 border-gray-1400 cursor-pointer hover:scale-110">
                                    {{ $page }}
                                </button>
                            @endif
                        </li>
                    @endif

                    {{-- Single set of dots between page ranges --}}
                    @if ($showDots && !$loop->last)
                        <li class="flex">
                            <span class="flex justify-center items-center w-9 h-9 rounded-full border border-solid group bg-gray-1400 text-mid-gray shadow-3xl border-gray-1400">
                                ...
                            </span>
                        </li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
            <li>
                <button wire:click="nextPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJs }}" class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out group shadow-3xl border-gray-1200 hover:bg-black-1200 hover:border-black-1200 hover:text-white cursor-pointer">
                    <x-icon-right-arrow2 class="group-hover:brightness-[100%] transition-all duration-500 ease-in-out" />
                </button>
            </li>
        @else
            <li>
                <span class="flex justify-center items-center w-9 h-9 bg-white rounded-full border border-solid opacity-50 cursor-not-allowed group shadow-3xl border-gray-1200">
                    <x-icon-right-arrow2 />
                </span>
            </li>
        @endif
    </ul>
@endif
