@php
    $pageName = $paginator->getPageName();
    $current = $paginator->currentPage();
    $last = $paginator->lastPage();
@endphp

@if ($paginator->hasPages())
    <nav role="navigation"
        aria-label="Pagination Navigation"
        class="flex items-center justify-center">

        {{-- ← Previous --}}
        @if ($paginator->onFirstPage())
            <span aria-disabled="true" class="flex items-center justify-center w-8 h-8 rounded-lg opacity-50 cursor-not-allowed page-link bg-gray-1300 sm:w-9 sm:h-9 text-gray-1500">
                <img src="{{ asset('images/left-arrow2.svg') }}" alt="Previous" />
            </span>
        @else
            <button type="button"
                wire:click="previousPage('{{ $pageName }}')"
                x-on:click="document.body.scrollIntoView()"
                class="flex items-center justify-center w-8 h-8 rounded-lg page-link bg-gray-1300 sm:w-9 sm:h-9 text-gray-1500 hover:bg-red-1300 hover:text-white">
                <img src="{{ asset('images/left-arrow2.svg') }}" alt="Previous" />
            </button>
        @endif

        {{-- Page Numbers --}}
        <ul class="flex items-center justify-center gap-2 mx-3">
            {{-- MOBILE ONLY: First --}}
            <li class="sm:hidden">
                @if ($current === 1)
                    <span class="pag-link bg-red-1300 text-white rounded-lg flex items-center justify-center w-8 h-8 font-bold text-[13px]">1</span>
                @else
                    <button wire:click="gotoPage(1,'{{ $pageName }}')" class="pag-link bg-gray-1300 text-gray-1500 rounded-lg flex items-center justify-center w-8 h-8 font-bold text-[13px] hover:bg-red-1300 hover:text-white">
                        1
                    </button>
                @endif
            </li>

            {{-- MOBILE ONLY: … before current --}}
            @if ($current > 2)
                <li class="px-1 font-bold text-gray-500 sm:hidden">…</li>
            @endif

            {{-- MOBILE ONLY: Current (if not 1 or last) --}}
            @if ($current !== 1 && $current !== $last)
                <li class="sm:hidden">
                    <span class="pag-link bg-red-1300 text-white rounded-lg flex items-center justify-center w-8 h-8 font-bold text-[13px]">
                        {{ $current }}
                    </span>
                </li>
            @endif

            {{-- MOBILE ONLY: … after current --}}
            @if ($current < $last - 1)
                <li class="px-1 font-bold text-gray-500 sm:hidden">…</li>
            @endif

            {{-- MOBILE ONLY: Last --}}
            @if ($last > 1)
                <li class="sm:hidden">
                    @if ($current === $last)
                        <span class="pag-link bg-red-1300 text-white rounded-lg flex items-center justify-center w-8 h-8 font-bold text-[13px]">
                            {{ $last }}
                        </span>
                    @else
                        <button wire:click="gotoPage({{ $last }},'{{ $pageName }}')" class="pag-link bg-gray-1300 text-gray-1500 rounded-lg flex items-center justify-center w-8 h-8 font-bold text-[13px] hover:bg-red-1300 hover:text-white">
                            {{ $last }}
                        </button>
                    @endif
                </li>
            @endif

            {{-- DESKTOP+ (≥640px): full pagination --}}
            @foreach ($elements as $element)
                @if (is_string($element))
                    <li class="hidden sm:flex text-gray-1500 font-bold sm:text-[15px] text-[13px] flex items-center justify-center sm:w-9 w-8 sm:h-9 h-8 rounded-lg">
                        {{ $element }}
                    </li>
                @endif

                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        <li wire:key="paginator-{{ $pageName }}-page{{ $page }}" class="hidden sm:flex">
                            @if ($page == $current)
                                <span aria-current="page" class="pag-link bg-red-1300 text-white rounded-lg flex items-center justify-center sm:w-9 w-8 sm:h-9 h-8 font-bold sm:text-[15px] text-[13px]">
                                    {{ $page }}
                                </span>
                            @else
                                <button type="button"
                                    wire:click="gotoPage({{ $page }},'{{ $pageName }}')"
                                    x-on:click="document.body.scrollIntoView()"
                                    wire:loading.attr="disabled"
                                    class="pag-link bg-gray-1300 text-gray-1500 rounded-lg flex items-center justify-center sm:w-9 w-8 sm:h-9 h-8 font-bold sm:text-[15px] text-[13px] hover:bg-red-1300 hover:text-white transition-all duration-200">
                                    {{ $page }}
                                </button>
                            @endif
                        </li>
                    @endforeach
                @endif
            @endforeach
        </ul>

        {{-- Next → --}}
        @if ($paginator->hasMorePages())
            <button type="button"
                wire:click="nextPage('{{ $pageName }}')"
                x-on:click="document.body.scrollIntoView()"
                class="flex items-center justify-center w-8 h-8 rounded-lg page-link bg-gray-1300 sm:w-9 sm:h-9 text-gray-1500 hover:bg-red-1300 hover:text-white">
                <img src="{{ asset('images/right-arrow2.svg') }}" alt="Next" />
            </button>
        @else
            <span aria-disabled="true" class="flex items-center justify-center w-8 h-8 rounded-lg opacity-50 cursor-not-allowed page-link bg-gray-1300 sm:w-9 sm:h-9 text-gray-1500">
                <img src="{{ asset('images/right-arrow2.svg') }}" alt="Next" />
            </span>
        @endif

    </nav>
@endif
