@props(['paginator', 'elements', 'scrollTo' => null])

@php
    if ($scrollTo === false) {
        $scrollIntoViewJs = '';
    } elseif (is_string($scrollTo)) {
        $scrollIntoViewJs = "document.querySelector('{$scrollTo}').scrollIntoView()";
    } else {
        $scrollIntoViewJs = 'document.body.scrollIntoView()';
    }
@endphp

{{-- only render pagination if there’s at least one record --}}
@if ($paginator->total() > 0)
    <ul class="flex gap-2 justify-center items-center">
        {{-- Prev --}}
        @if ($paginator->onFirstPage())
            <li>
                <span class="page-link group bg-white rounded-lg border border-solid border-gray-1600 flex items-center justify-center h-8 font-bold sm:text-[15px] text-[13px] text-gray-1500 gap-2.5 px-[15px] opacity-50 cursor-not-allowed transition-all duration-500 ease-in-out">
                    <x-icon-left-arrow2 class="transition-all duration-500 ease-in-out" />
                    {{ __('Prev') }}
                </span>
            </li>
        @else
            <li>
                <button wire:click="previousPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJs }}" class="page-link group bg-white rounded-lg border border-solid border-gray-1600 hover:border-gray-1500 flex items-center justify-center h-8 font-bold sm:text-[15px] text-[13px] text-gray-1500 hover:bg-gray-1500 hover:text-white transition-all duration-500 ease-in-out gap-2.5 px-[15px]">
                    <x-icon-left-arrow2 class="group-hover:brightness-[1000%] transition-all duration-500 ease-in-out" />
                    {{ __('Prev') }}
                </button>
            </li>
        @endif

        {{-- Page Links --}}
        @foreach ($elements as $element)
            {{-- “...” Separator --}}
            @if (is_string($element))
                <li class="hidden sm:inline-flex">
                    <span class="pag-link bg-white rounded-lg flex border border-solid border-gray-1600 hover:border-gray-1500 items-center justify-center w-8 h-8 font-bold sm:text-[15px] text-[13px] text-gray-1500 hover:bg-gray-1500 hover:text-white transition-all duration-500 ease-in-out">
                        {{ $element }}
                    </span>
                </li>
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @php
                        $always = in_array($page, [1, $paginator->currentPage(), $paginator->lastPage()]);
                    @endphp
                    <li class="{{ $always ? '' : 'hidden sm:inline-flex' }}">
                        @if ($page == $paginator->currentPage())
                            <span class="pag-link bg-gray-1500 rounded-lg border border-solid border-gray-1500 flex items-center justify-center w-8 h-8 font-bold sm:text-[15px] text-[13px] text-white transition-all duration-500 ease-in-out">
                                {{ $page }}
                            </span>
                        @else
                            <button wire:click="gotoPage({{ $page }}, '{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJs }}" class="pag-link bg-white rounded-lg flex border border-solid border-gray-1600 hover:border-gray-1500 items-center justify-center w-8 h-8 font-bold sm:text-[15px] text-[13px] text-gray-1500 hover:bg-gray-1500 hover:text-white transition-all duration-500 ease-in-out">
                                {{ $page }}
                            </button>
                        @endif
                    </li>
                @endforeach
            @endif
        @endforeach

        {{-- Next --}}
        @if ($paginator->hasMorePages())
            <li>
                <button wire:click="nextPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJs }}" class="page-link group bg-white rounded-lg border border-solid border-gray-1600 hover:border-gray-1500 flex items-center justify-center h-8 font-bold sm:text-[15px] text-[13px] text-gray-1500 hover:bg-gray-1500 hover:text-white transition-all duration-500 ease-in-out gap-2.5 px-[15px]">
                    {{ __('Next') }}
                    <x-icon-right-arrow2 class="group-hover:brightness-[1000%] transition-all duration-500 ease-in-out" />
                </button>
            </li>
        @else
            <li>
                <span class="page-link group bg-white rounded-lg border border-solid border-gray-1600 flex items-center justify-center h-8 font-bold sm:text-[15px] text-[13px] text-gray-1500 gap-2.5 px-[15px] opacity-50 cursor-not-allowed transition-all duration-500 ease-in-out">
                    {{ __('Next') }}
                    <x-icon-right-arrow2 class="transition-all duration-500 ease-in-out" />
                </span>
            </li>
        @endif
    </ul>
@endif
