@php
if (! isset($scrollTo)) {
    $scrollTo = 'body';
}

$scrollIntoViewJsSnippet = ($scrollTo !== false)
    ? <<<JS
       (\$el.closest('{$scrollTo}') || document.querySelector('{$scrollTo}')).scrollIntoView()
    JS
    : '';
@endphp

<div>
    @if ($paginator->hasPages())
        <nav role="navigation" aria-label="Pagination Navigation" class="flex items-center justify-between">
            {{-- Mobile View (Only Next/Previous) --}}
            <div class="flex justify-between w-full sm:hidden">
                {{-- Previous Page Link --}}
                @if ($paginator->onFirstPage())
                    <span class="flex items-center gap-3 text-sm font-medium text-gray-400 cursor-not-allowed font-Inter">
                        {{-- <img src="{{ asset('images/left-long-arrow.svg') }}" alt="" class="h-3 opacity-50" /> --}}
                        {!! __('pagination.previous') !!}
                    </span>
                @else
                    <button type="button" wire:click="previousPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJsSnippet }}" class="flex items-center gap-3 text-sm font-medium transition-colors duration-200 text-dark-blue font-Inter hover:text-light-blue">
                        {{-- <img src="{{ asset('images/left-long-arrow.svg') }}" alt="" class="h-3" /> --}}
                        {!! __('pagination.previous') !!}
                    </button>
                @endif

                {{-- Next Page Link --}}
                @if ($paginator->hasMorePages())
                    <button type="button" wire:click="nextPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJsSnippet }}" class="flex items-center gap-3 text-sm font-medium transition-colors duration-200 text-dark-blue font-Inter hover:text-light-blue">
                        {!! __('pagination.next') !!}
                        {{-- <img src="{{ asset('images/right-long-arrow.svg') }}" alt="" class="h-3" /> --}}
                    </button>
                @else
                    <span class="flex items-center gap-3 text-sm font-medium text-gray-400 cursor-not-allowed font-Inter">
                        {!! __('pagination.next') !!}
                        {{-- <img src="{{ asset('images/right-long-arrow.svg') }}" alt="" class="h-3 opacity-50" /> --}}
                    </span>
                @endif
            </div>

            {{-- Desktop View (Full Pagination) --}}
            <div class="hidden sm:flex sm:justify-between sm:flex-1">
                {{-- Previous Page Link --}}
                @if ($paginator->onFirstPage())
                    <span class="flex items-center gap-3 text-sm font-medium text-gray-400 cursor-not-allowed font-Inter">
                        {{-- <img src="{{ asset('images/left-long-arrow.svg') }}" alt="" class="h-auto" /> --}}
                        {!! __('pagination.previous') !!}
                    </span>
                @else
                    <button type="button" wire:click="previousPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJsSnippet }}" class="flex items-center gap-3 text-sm font-medium transition-colors duration-200 text-dark-blue font-Inter hover:text-light-blue">
                        {{-- <img src="{{ asset('images/left-long-arrow.svg') }}" alt="" class="h-auto" /> --}}
                        {!! __('pagination.previous') !!}
                    </button>
                @endif

                {{-- Pagination Elements --}}
                <ul class="flex items-center gap-px">
                    @foreach ($elements as $element)
                        {{-- Array Of Links --}}
                        @if (is_array($element))
                            @foreach ($element as $page => $url)
                                <li wire:key="paginator-{{ $paginator->getPageName() }}-page{{ $page }}">
                                    @if ($page == $paginator->currentPage())
                                        <span class="text-light-blue bg-light-blue/[0.1] font-medium font-Inter text-sm flex items-center justify-center w-10 h-10 rounded-[8px]">
                                            {{ $page }}
                                        </span>
                                    @else
                                        <button type="button" wire:click="gotoPage({{ $page }}, '{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJsSnippet }}" class="text-dark-blue hover:text-light-blue hover:bg-light-blue/[0.1] font-medium font-Inter text-sm flex items-center justify-center w-10 h-10 rounded-[8px] transition-colors duration-200">
                                            {{ $page }}
                                        </button>
                                    @endif
                                </li>
                            @endforeach
                        @endif

                        {{-- "Three Dots" Separator --}}
                        @if (is_string($element))
                            <li class="text-dark-blue font-medium font-Inter text-sm flex items-center justify-center w-10 h-10 rounded-[8px]">
                                {{ $element }}
                            </li>
                        @endif
                    @endforeach
                </ul>

                {{-- Next Page Link --}}
                @if ($paginator->hasMorePages())
                    <button type="button" wire:click="nextPage('{{ $paginator->getPageName() }}')" x-on:click="{{ $scrollIntoViewJsSnippet }}" class="flex items-center gap-3 text-sm font-medium transition-colors duration-200 text-dark-blue font-Inter hover:text-light-blue">
                        {!! __('pagination.next') !!}
                        {{-- <img src="{{ asset('images/right-long-arrow.svg') }}" alt="" class="h-auto" /> --}}
                    </button>
                @else
                    <span class="flex items-center gap-3 text-sm font-medium text-gray-400 cursor-not-allowed font-Inter">
                        {!! __('pagination.next') !!}
                        {{-- <img src="{{ asset('images/right-long-arrow.svg') }}" alt="" class="h-auto opacity-50" /> --}}
                    </span>
                @endif
            </div>
        </nav>
    @endif
</div>
