@php
    use Illuminate\Support\Facades\Route;
    use Illuminate\Support\Str;
@endphp

@extends('layouts.app')
@section('content')
    <div class="flex justify-center items-center px-6 py-12 min-h-screen bg-gradient-to-br from-blue-50 via-white to-indigo-100 dark:from-gray-900 dark:via-gray-800 dark:to-gray-900">
        <div class="mx-auto max-w-2xl text-center">
            <!-- Main Heading -->
            <div class="mb-12">
                <h1 class="mb-6 text-5xl font-bold text-gray-800 md:text-7xl dark:text-white">
                    Coming Soon
                </h1>
                <div class="mx-auto mb-8 w-24 h-1 bg-gradient-to-r from-blue-500 to-indigo-600 rounded-full"></div>
                <p class="mb-4 text-xl leading-relaxed text-gray-600 md:text-2xl dark:text-gray-300">
                    We're working hard to bring you something amazing.
                </p>
                <p class="text-lg text-gray-500 dark:text-gray-400">
                    Our team is putting the finishing touches on our new platform. Stay tuned for updates!
                </p>
            </div>

            <!-- Email Subscription -->
            <div class="mb-16">
                <div class="mx-auto max-w-md">
                    <div class="flex flex-col gap-4 sm:flex-row">
                        <input type="email"
                            placeholder="Enter your email"
                            class="flex-1 px-4 py-3 placeholder-gray-500 text-gray-900 bg-white rounded-lg border border-gray-300 transition-all duration-200 dark:border-gray-600 dark:bg-gray-800 dark:text-white dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                        <button class="px-6 py-3 font-semibold text-white bg-gradient-to-r from-blue-500 to-indigo-600 rounded-lg transition-all duration-200 transform hover:from-blue-600 hover:to-indigo-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 hover:scale-105">
                            Notify Me
                        </button>
                    </div>
                </div>
            </div>

            <!-- Footer -->
            <div class="pt-8 border-t border-gray-200 dark:border-gray-700">
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    © {{ date('Y') }} {{ config('app.name') }}. {{ Str::title('All rights reserved.') }}
                </p>
            </div>
        </div>
    </div>
@endsection
