<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\Auth\AuthController;
use App\Http\Controllers\Api\V1\Lead\LeadFormController;
use App\Http\Controllers\Api\V1\Lead\LeadFormFieldController;
use App\Http\Controllers\Api\V1\Lead\LeadFormVisitController;
use App\Http\Controllers\Api\V1\Lead\LeadController;
use App\Http\Controllers\Api\V1\Lead\LeadSubmissionController;
use App\Http\Controllers\Api\V1\Lead\LeadAssignmentController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

/*
|--------------------------------------------------------------------------
| API Version 1 Routes
|--------------------------------------------------------------------------
*/

Route::prefix('v1')->name('api.v1.')->group(function () {

    /*
    |--------------------------------------------------------------------------
    | Authentication Routes (Public)
    |--------------------------------------------------------------------------
    */

    Route::middleware(['throttle:60,1'])->group(function () {
        Route::post('auth/login', [AuthController::class, 'login'])
            ->name('auth.login');
        Route::post('auth/register', [AuthController::class, 'register'])
            ->name('auth.register');
        Route::post('auth/verify-token', [AuthController::class, 'verifyToken'])
            ->name('auth.verify-token');
    });

    /*
    |--------------------------------------------------------------------------
    | Public Lead Form & Lead Submission Routes
    |--------------------------------------------------------------------------
    */

    Route::middleware(['auth:sanctum', 'throttle:60,1'])->group(function () {
        // Get public lead form (for rendering)
        Route::get('lead-forms/{uuid}', [LeadFormController::class, 'show'])
            ->name('lead-forms.show');

        // Submit lead to form (public)
        Route::post('lead-forms/{uuid}/leads', [LeadSubmissionController::class, 'submit'])
            ->name('lead-forms.submit');

        // Track form visit (public)
        Route::post('lead-forms/{uuid}/track-visit', [LeadSubmissionController::class, 'trackVisit'])
            ->name('lead-forms.track-visit');
    });

    /*
    |--------------------------------------------------------------------------
    | Protected Lead Form Routes (Require Authentication)
    |--------------------------------------------------------------------------
    */

    Route::middleware(['auth:sanctum', 'throttle:200,1'])->group(function () {

        // Authentication Routes (Protected)
        Route::post('auth/logout', [AuthController::class, 'logout'])
            ->name('auth.logout');
        Route::post('auth/logout-all', [AuthController::class, 'logoutAll'])
            ->name('auth.logout-all');
        Route::get('auth/me', [AuthController::class, 'me'])
            ->name('auth.me');
        Route::post('auth/refresh', [AuthController::class, 'refresh'])
            ->name('auth.refresh');

        // Lead Forms CRUD
        Route::get('lead-forms', [LeadFormController::class, 'index'])
            ->name('lead-forms.index');
        Route::post('lead-forms', [LeadFormController::class, 'store'])
            ->name('lead-forms.store');
        Route::put('lead-forms/{uuid}', [LeadFormController::class, 'update'])
            ->name('lead-forms.update');
        Route::delete('lead-forms/{uuid}', [LeadFormController::class, 'destroy'])
            ->name('lead-forms.destroy');
        Route::get('lead-forms/{uuid}/stats', [LeadFormController::class, 'stats'])
            ->name('lead-forms.stats');

        // Lead Form Fields Management
        Route::prefix('lead-forms/{uuid}')->name('lead-forms.')->group(function () {
            Route::get('fields', [LeadFormFieldController::class, 'index'])
                ->name('fields.index');
            Route::post('fields', [LeadFormFieldController::class, 'store'])
                ->name('fields.store');
            Route::put('fields/{fieldId}', [LeadFormFieldController::class, 'update'])
                ->name('fields.update');
            Route::delete('fields/{fieldId}', [LeadFormFieldController::class, 'destroy'])
                ->name('fields.destroy');

            // Lead Form Visits CRUD
            Route::get('visits', [LeadFormVisitController::class, 'index'])
                ->name('visits.index');
            Route::post('visits', [LeadFormVisitController::class, 'store'])
                ->name('visits.store');
            Route::get('visits/{visitUuid}', [LeadFormVisitController::class, 'show'])
                ->name('visits.show');
            Route::put('visits/{visitUuid}', [LeadFormVisitController::class, 'update'])
                ->name('visits.update');
            Route::delete('visits/{visitUuid}', [LeadFormVisitController::class, 'destroy'])
                ->name('visits.destroy');
        });

        // Leads Management
        Route::get('leads', [LeadController::class, 'index'])
            ->name('leads.index');
        Route::post('leads', [LeadController::class, 'store'])
            ->name('leads.store');
        Route::get('leads/{uuid}', [LeadController::class, 'show'])
            ->name('leads.show');
        Route::put('leads/{uuid}', [LeadController::class, 'update'])
            ->name('leads.update');
        Route::delete('leads/{uuid}', [LeadController::class, 'destroy'])
            ->name('leads.destroy');

        // Lead Assignment & Status
        Route::prefix('leads/{uuid}')->name('leads.')->group(function () {
            Route::post('assign', [LeadAssignmentController::class, 'assign'])
                ->name('assign');
            Route::put('status', [LeadAssignmentController::class, 'updateStatus'])
                ->name('update-status');
        });
    });
});
