<?php
// Note: Laravel will automatically resolve `Breadcrumbs::` without
// this import. This is nice for IDE syntax and refactoring.
use Diglactic\Breadcrumbs\Breadcrumbs;
use App\Models\Blog\Post;

// This import is also not required, and you could replace `BreadcrumbTrail $trail`
//  with `$trail`. This is nice for IDE type checking and completion.
use Diglactic\Breadcrumbs\Generator as BreadcrumbTrail;

// Home
Breadcrumbs::for('home', function (BreadcrumbTrail $trail) {
    $trail->push('Home', route('home'));
});

// Home > Blog
Breadcrumbs::for('journal', function (BreadcrumbTrail $trail) {
    $trail->parent('home', route('home'));
    $trail->push('Journals', route('journal.index'));
});
// Home > Blog
Breadcrumbs::for('journals-search', function (BreadcrumbTrail $trail, array $params) {
    $trail->parent('home', route('home'));
    $trail->push('Journals', route('journal.index'));
    if ($params['query']) {
        $trail->push('Search Results for: ' . $params['query']);
    } else {
        $trail->push('Search Results');
    }
});

// Home > Blog > [Category] > [Title]
Breadcrumbs::for('journal-category', function (BreadcrumbTrail $trail, array $params) {
    $category = $params['category'];
    $trail->parent('home', route('home'));
    $trail->push('Journal', route('journal.index'));
    $trail->push('Category: ' . $category->name);
});

// Home > Blog > [Title]
Breadcrumbs::for('blog-detail', function (BreadcrumbTrail $trail, array $params) {
    $post = $params['post'];
    $trail->parent('home', route('home'));
    $trail->push('Journal', route('journal.index'));
    $trail->push($post->post_title);
});

// Home > Blog > [Author]
Breadcrumbs::for('blog-author', function (BreadcrumbTrail $trail, array $params) {
    $author = $params['author'];
    $trail->parent('home', route('home'));
    $trail->push('Journal', route('journal.index'));
    $trail->push('Author: ' . $author->name);
});

// Home > Blog > [Tag]
Breadcrumbs::for('blog-tag', function (BreadcrumbTrail $trail, array $params) {
    $tag = $params['tag'];
    $trail->parent('home', route('home'));
    $trail->push('Journal', route('journal.index'));
    $trail->push('Tag: ' . $tag->name);
});

Breadcrumbs::for('member-list', function (BreadcrumbTrail $trail) {
    $trail->parent('home', route('home'));
    $trail->push('Directory');
    $trail->push('Results');
});
// Home > Member > [Member]
Breadcrumbs::for('member', function (BreadcrumbTrail $trail, array $params) {
    $member = $params['member'];
    $trail->parent('home', route('home'));
    $trail->push($member->name);
});

// Home > Classified > [Classified]
Breadcrumbs::for('classified-detail', function (BreadcrumbTrail $trail, array $params) {
    $classified = $params['classified'];
    $trail->parent('home', route('home'));
    $trail->push('Classified', route('classified.index'));
    // $trail->push($classified->name);
});

// Home > Jobs
Breadcrumbs::for('job-list', function (BreadcrumbTrail $trail) {
    $trail->parent('home', route('home'));
    $trail->push('Jobs');
});

// Home > Classifieds
Breadcrumbs::for('classifieds', function (BreadcrumbTrail $trail) {
    $trail->parent('home', route('home'));
    $trail->push('Classified Ads');
});

Breadcrumbs::for('job-apply', function (BreadcrumbTrail $trail, array $params) {
    $title = $params['title'];
    $member = $params['member'];
    $memberName = $member->memberName();
    $memberLink = $member->permalink;
    $jobTitle = $params['jobTitle'];
    // dump($title, $location, $user);
    $trail->parent('home', route('home'));
    $trail->push('Jobs', route('job.index'));

    if ($member) {
        $trail->push($memberName, $memberLink);
    }
    if ($jobTitle) {
        $trail->push($jobTitle);
    }
});
Breadcrumbs::for('project', function (BreadcrumbTrail $trail, array $params) {
    $project = $params['project'];
    $trail->parent('home', route('home'));
    $trail->push('Projects');
    $trail->push($project->title);
});
Breadcrumbs::for('equipment-detail', function (BreadcrumbTrail $trail, array $params) {
    $equipment = $params['equipment'];
    $trail->parent('home', route('home'));
    $trail->push('Equipment', route('equipment.index'));
    $trail->push($equipment->title);
});