<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\Dashboard\Dashboard;
use App\Livewire\Dashboard\Profile\ProfileBasic;
use App\Livewire\Dashboard\Profile\ProfileGallaryImages;
use App\Livewire\Dashboard\Profile\ProfileLocation;
use App\Livewire\Dashboard\Profile\ProfileLocationAddEdit;
use App\Livewire\Dashboard\Profile\ProfilePhoto;
use App\Livewire\Dashboard\Profile\ProfilePhoto3;
use App\Livewire\Dashboard\Profile\ProfileService;
use App\Livewire\Dashboard\Profile\ProfileCategory;
use App\Livewire\Dashboard\Profile\ProfileBusinessMember;
use App\Livewire\Dashboard\ManageLead\ManageLead;
use App\Livewire\Dashboard\LeadInquiries\LeadInquiries;
use App\Livewire\Dashboard\Classified\ClassifiedList;
use App\Livewire\Dashboard\Classified\CreateClassified;
use App\Livewire\Dashboard\Classified\EditClassified;
use App\Livewire\Dashboard\Job\ListJob;
use App\Livewire\Dashboard\Job\CreateJob;
use App\Livewire\Dashboard\Job\EditJob;
use App\Livewire\Dashboard\Equipment\ListEquipment;
use App\Livewire\Dashboard\Equipment\CreateEquipment;
use App\Livewire\Dashboard\Equipment\EditEquipment;
use App\Livewire\Dashboard\Project\ListProject;
use App\Livewire\Dashboard\Project\CreateProject;
use App\Livewire\Dashboard\Project\EditProject;
use App\Livewire\Dashboard\Team\ListTeam;
use App\Livewire\Dashboard\Team\CreateTeam;
use App\Livewire\Dashboard\Team\EditTeam;
use App\Livewire\Dashboard\Applicants\Applicants;
use App\Livewire\Dashboard\Applicants\ViewApplicants;
use App\Livewire\Dashboard\AccountSubscription\AccountSubscription;
use App\Livewire\Dashboard\CreditsTransactionHistory\CreditsTransactionHistory;
use App\Livewire\Dashboard\ManufacturersSuppliers\ManufacturersSuppliers;
use App\Livewire\Dashboard\Product\ListProduct;
use App\Livewire\Dashboard\Product\CreateProduct;
use App\Livewire\Dashboard\Product\EditProduct;
use App\Livewire\Dashboard\Reviews\Reviews;
use App\Livewire\Dashboard\SubscriptionsTransactionHistory\SubscriptionsTransactionHistory;
use App\Livewire\Dashboard\Videos\Videos;
use App\Livewire\Dashboard\Videos\CreateVideo;
use App\Livewire\Dashboard\Videos\EditVideo;
use App\Http\Controllers\Dashboard\AccountSubscriptionController;
use App\Livewire\Dashboard\Setting\Setting;
use App\Livewire\Dashboard\Favourite\UserFavorite;
use App\Http\Controllers\Dashboard\InvoiceController;
use Illuminate\Http\Request;

Route::get('invoice/print/{uuid}/', [InvoiceController::class, 'generateInvoice'])->name('dashboard.invoice.generate');
Route::group(['prefix' => 'dashboard', 'middleware' => 'auth'], function () {

    Route::get('/', Dashboard::class)->name('dashboard');

    // Profile Routes
    Route::prefix('profile')->name('dashboard.profile.')->group(function () {
        Route::get('/basic', ProfileBasic::class)->name('basic');
        Route::get('/gallery', ProfileGallaryImages::class)->name('gallery')->can('userGalleryUploadImages');
        Route::get('/photo', ProfilePhoto::class)->name('photo');
        Route::get('/photo3', ProfilePhoto3::class)->name('photo3');
        Route::get('/service', ProfileService::class)->name('service');

        Route::get('/category', ProfileCategory::class)->name('category')->middleware(['can:isService', 'can:viewAny,App\Models\User\MemberCategory']);

        Route::get('/business-member', ProfileBusinessMember::class)->name('business-member')->middleware(['can:isMfgSupplier']);

        // Profile Location Routes
        Route::prefix('location')->name('location.')->group(function () {
            Route::get('/', ProfileLocation::class)->name('index')->middleware('can:viewAny,App\Models\User\UserLocation');
            Route::get('/create', ProfileLocationAddEdit::class)->name('create')->middleware('can:create,App\Models\User\UserLocation');
            Route::get('/edit/{uuid}', ProfileLocationAddEdit::class)->name('edit')->middleware('can:update,App\Models\User\UserLocation,uuid');
        });
    });

    Route::get('manage-lead', manageLead::class)->name('dashboard.manage-lead')->can('viewAny,App\Models\Lead\Lead');

    
    // Lead Routes
    Route::get('lead-inquirie', LeadInquiries::class)->name('dashboard.lead-inquirie')->can('viewAny,App\Models\User\Inquiry');
    Route::get('leads/edit/{uuid}', \App\Livewire\Dashboard\ManageLead\EditLead::class)->name('dashboard.leads.edit')->middleware('can:update,App\Models\Lead\Lead,uuid');
    // Route::get('lead/view/{uuid}', \App\Livewire\Dashboard\ManageLead\ViewLead::class)->name('dashboard.inquiries.view');

    // Classified 
    Route::get('classified', ClassifiedList::class)->name('dashboard.classified')->can('viewAny,App\Models\Classified\Classified');
    Route::get('classified/create', CreateClassified::class)->name('dashboard.classified.add')->middleware('can:create,App\Models\Classified\Classified');
    Route::get('classified/edit/{uuid}', EditClassified::class)->name('dashboard.classified.edit')->middleware('can:update,App\Models\Classified\Classified,uuid');

    // Job
    Route::get('job', ListJob::class)->name('dashboard.job')->can('viewAny,App\Models\Job\Job');
    Route::get('job/create', CreateJob::class)->name('dashboard.job.add')->middleware('can:create,App\Models\Job\Job');
    Route::get('job/edit/{uuid}', EditJob::class)->name('dashboard.job.edit')->middleware('can:update,App\Models\Job\Job,uuid');

    // Equipment
    Route::get('equipment', ListEquipment::class)->name('dashboard.equipment')->can('viewAny,App\Models\Equipment\Equipment');
    Route::get('equipment/create', CreateEquipment::class)->name('dashboard.equipment.create');
    Route::get('equipment/edit/{uuid}', EditEquipment::class)->name('dashboard.equipment.edit');
    Route::get('equipment/view/{uuid}', ListEquipment::class)->name('dashboard.equipment.view');

    /// Project 
    Route::get('project', ListProject::class)->name('dashboard.project')->can('viewAny,App\Models\Project\Project');
    Route::get('project/create', CreateProject::class)->name('dashboard.project.add')->middleware('can:create,App\Models\Project\Project');
    Route::get('project/edit/{uuid}', EditProject::class)->name('dashboard.project.edit')->middleware('can:update,App\Models\Project\Project,uuid');

    // Team
    Route::get('team', ListTeam::class)->name('dashboard.team')->can('viewAny,App\Models\Team\TeamMember');
    Route::get('team/create', CreateTeam::class)->name('dashboard.team.add')->middleware('can:create,App\Models\Team\TeamMember');
    Route::get('team/edit/{uuid}', EditTeam::class)->name('dashboard.team.edit')->middleware('can:update,App\Models\Team\TeamMember,uuid');


    // Blog
    Route::get('article', \App\Livewire\Dashboard\Article\ListArticle::class)->name('dashboard.article')->can('viewAny,App\Models\Blog\Post');
    Route::get('article/create', \App\Livewire\Dashboard\Article\CreateArticle::class)->name('dashboard.article.add')->middleware('can:create,App\Models\Blog\Post');
    Route::get('article/edit/{uuid}', \App\Livewire\Dashboard\Article\EditArticle::class)->name('dashboard.article.edit')->middleware('can:update,App\Models\Blog\Post,uuid');

    Route::get('job/application', Applicants::class)->name('dashboard.job.application')->can('viewAny,App\Models\Job\JobApplication');
    Route::get('job/application/{uuid}', ViewApplicants::class)->name('dashboard.job.application.show')->can('view,App\Models\Job\JobApplication,uuid');

    Route::get('account-subscription', [AccountSubscriptionController::class, 'index'])->name('dashboard.account-subscription')->can('account&Subscription');

    Route::get('credits-transaction-history', CreditsTransactionHistory::class)->name('dashboard.credits-transaction-history')->can('viewAny,App\Models\User\UserCreditHistory');
    Route::get('credits/purchase', \App\Livewire\Dashboard\Credits\CreditPurchase::class)->name('dashboard.credits.purchase');
    Route::get('credits/paypal/success', [\App\Livewire\Dashboard\Credits\CreditPurchase::class, 'handlePayPalSuccess'])->name('dashboard.credits.paypal.success');
    Route::get('credits/paypal/cancel', [\App\Livewire\Dashboard\Credits\CreditPurchase::class, 'handlePayPalCancellation'])->name('dashboard.credits.paypal.cancel');
    Route::get('credits/stripe/success', [\App\Livewire\Dashboard\Credits\CreditPurchase::class, 'handlePaymentSuccess'])->name('dashboard.credits.stripe.success');
    Route::get('manufacturers-supplier', ManufacturersSuppliers::class)->name('dashboard.manufacturers-supplier');

    ////////// Product 
    Route::get('product', ListProduct::class)->name('dashboard.product')->can('viewAny,App\Models\Product\Product');
    Route::get('product/create', CreateProduct::class)->name('dashboard.product.add')->middleware('can:create,App\Models\Product\Product');
    Route::get('product/edit/{uuid}', EditProduct::class)->name('dashboard.product.edit')->middleware('can:update,App\Models\Product\Product,uuid');

    Route::get('review', Reviews::class)->name('dashboard.review')->can('viewAny,App\Models\Review');
    Route::get('favourite', UserFavorite::class)->name('dashboard.favourite');
    Route::get('subscriptions-transaction-history', SubscriptionsTransactionHistory::class)->name('dashboard.subscriptions-transaction-history');

    // Video
    Route::get('video', Videos::class)->name('dashboard.video')->can('viewAny,App\Models\User\UserVideo');
    Route::get('video/create', CreateVideo::class)->name('dashboard.video.create')->middleware('can:create,App\Models\User\UserVideo');
    Route::get('video/edit/{uuid}', EditVideo::class)->name('dashboard.video.edit')->middleware('can:update,App\Models\User\UserVideo,uuid');


    // Equipment
    Route::get('equipment', ListEquipment::class)->name('dashboard.equipments')->can('viewAny,App\Models\Equipment\Equipment');
    Route::get('equipment/create', CreateEquipment::class)->name('dashboard.equipments.create');
    Route::get('equipment/edit/{uuid}', EditEquipment::class)->name('dashboard.equipments.edit');
    Route::get('equipment/view/{uuid}', ListEquipment::class)->name('dashboard.equipments.view');
    // Equipment Category
    // Route::get('equipment-category', ListEquipmentCategory::class)->name('dashboard.equipment-category');
    // Route::get('equipment-category/create', CreateEquipmentCategory::class)->name('dashboard.equipment-category.create');
    // Route::get('equipment-category/edit/{uuid}', EditEquipmentCategory::class)->name('dashboard.equipment-category.edit');

    // Settings
    Route::get('settings', Setting::class)->name('dashboard.setting');
});
