<?php

use App\Http\Controllers\Auth\EmailVerificationController;
use App\Http\Controllers\Auth\LogoutController;
use App\Livewire\Auth\Login;
use App\Livewire\Auth\Passwords\Confirm;
use App\Livewire\Auth\Passwords\Email;
use App\Livewire\Frontend\Auth\PasswordReset;
use App\Livewire\Auth\Register;
use App\Livewire\Auth\Verify;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\Blog\PostController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\TemplateController;
use App\Models\Page;
use Illuminate\Support\Facades\App;
use App\Http\Middleware\PageSeoMiddleware;
use App\Http\Middleware\PreviewMiddleware;
use App\Http\Controllers\Frontend\Classified\ClassifiedController;
use App\Http\Controllers\Frontend\Job\JobController;
use App\Http\Controllers\Frontend\Member\MemberController;
use App\Http\Controllers\Frontend\ComingSoonController;
use App\Http\Controllers\Frontend\Eqiupment\EquipmentController;
use App\Http\Controllers\Frontend\Project\ProjectController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\AjaxController;
use App\Http\Controllers\Frontend\CityController;
use App\Http\Controllers\Frontend\Lead\LeadController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Stripe Webhook Route (outside themed middleware)
Route::post('/webhook/cashier', [WebhookController::class, 'handleWebhook'])->name('cashier.webhook');

Route::middleware(['theme:' . env('ACTIVE_THEME', 'esp_sleek'), PageSeoMiddleware::class])->group(function () {

    // Coming Soon Page - Uncomment to enable
    Route::get('/', [ComingSoonController::class, 'index'])->name('coming-soon');
    
    // Notify Me Form Submission
    Route::post('/notify-me', [ComingSoonController::class, 'notifyMe'])->name('notify-me');

    // Regular Home Page - Comment to enable coming soon
    // Route::get('/', function () {
    //     $homePageSlug = 'home';
    //     $homePage = Page::where('slug', $homePageSlug)->first();
    //     if($homePage) {
    //         return App::call('App\Http\Controllers\Frontend\TemplateController@index', ['slug' => $homePageSlug]);
    //     } else {
    //         // return redirect()->route('blog.index');
    //         return App::call('App\Http\Controllers\Frontend\HomeController@index');
    //     }
    // })->name('home');

    // Home route for accessing the actual homepage while coming soon is active
    Route::get('/', function () {
        $homePageSlug = 'home';
        $homePage = Page::where('slug', $homePageSlug)->first();
        if ($homePage) {
            return App::call('App\Http\Controllers\Frontend\TemplateController@index', ['slug' => $homePageSlug]);
        } else {
            // return redirect()->route('blog.index');
            return App::call('App\Http\Controllers\Frontend\HomeController@index');
        }
    })->name('home');

    // Blog Routes
    Route::prefix('journal')->name('journal.')->controller(PostController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/search', 'search')->name('search');
        Route::get('/category/{slug}', 'category')->name('category');
        Route::get('/tag/{slug}', 'tag')->name('tag');
        Route::get('/author/{slug}', 'author')->name('author');
        Route::get('/{slug}', 'show')->name('show')->middleware([PreviewMiddleware::class]);
    });

    // Member Routes
    Route::prefix('member')->name('member.')->controller(MemberController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/{slug}', 'show')->name('show')->middleware([PreviewMiddleware::class]);
    });

    Route::get('/video/{uuid}', [MemberController::class, 'showVideo'])->name('member.video');

    // Project Routes
    Route::prefix('project')->name('project.')->controller(ProjectController::class)->group(function () {
        Route::get('/{slug}', 'show')->name('show')->middleware([PreviewMiddleware::class]);
    });

    // Classified Routes
    Route::prefix('classified')->name('classified.')->controller(ClassifiedController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/{slug}', 'show')->name('show')->middleware([PreviewMiddleware::class]);
    });


    // Job Routes
    Route::prefix('job')->name('job.')->controller(JobController::class)->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/{slug}', 'show')->name('show')->middleware([PreviewMiddleware::class]);
        Route::get('/{slug}/apply', 'apply')->name('apply')->middleware([PreviewMiddleware::class]);
    });


    // Equipment Routes
    Route::get('equipment/{slug}', [EquipmentController::class, 'show'])
        ->name('equipment.show')
        ->middleware([PreviewMiddleware::class]);

    Route::middleware('guest')->group(function () {
        Route::get('login', Login::class)
            ->name('login');

        Route::get('register', Register::class)
            ->name('register');
    });

    //Leadform route
    Route::prefix('lead')->name('lead.')->controller(LeadController::class)->group(function () {
        Route::get('/lead-form', 'LeadForm')->name('lead-form');
        Route::get('/lead-summary/{uuid}', 'LeadSummary')->name('lead-summary');
    });



    Route::get('password/reset', Email::class)
        ->name('password.request');

    Route::get('password/reset/{token}', PasswordReset::class)
        ->name('password.reset');

    Route::middleware('auth')->group(function () {
        Route::get('email/verify', Verify::class)
            ->middleware('throttle:6,1')
            ->name('verification.notice');

        Route::get('password/confirm', Confirm::class)
            ->name('password.confirm');
    });

    // Email verification route - no auth required
    Route::get('email/verify/{id}/{hash}', EmailVerificationController::class)
        ->middleware('signed')
        ->name('verification.verify');

    Route::middleware('auth')->group(function () {
        Route::post('logout', LogoutController::class)
            ->name('logout');
    });

    Route::controller(CityController::class)->group(function () {
        Route::get('/city/{slug}', 'show')->name('city.show');
    });

    // Do not add any routes below this line
    Route::get('{slug}', [TemplateController::class, 'index'])->name('template.index');

    Route::post('/actions/handle', [AjaxController::class, 'handle'])->name('actions.handle');
});
