<?php

namespace Tests\Feature\Commands;

use Tests\TestCase;
use App\Models\Blog\Post;
use App\Enums\PostStatus;
use Illuminate\Foundation\Testing\RefreshDatabase;

class PublishScheduledPostsTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_publishes_scheduled_posts(): void
    {
        // Create a scheduled post due for publication
        $scheduledPost = Post::factory()->create([
            'post_status' => PostStatus::Scheduled->value,
            'published_at' => now()->subMinute(),
        ]);

        // Create a scheduled post for future publication
        $futurePost = Post::factory()->create([
            'post_status' => PostStatus::Scheduled->value,
            'published_at' => now()->addDay(),
        ]);

        // Run the command
        $this->artisan('posts:publish-scheduled')
            ->expectsOutput("Publishing scheduled posts...")
            ->assertSuccessful();

        // Assert the past scheduled post was published
        $this->assertEquals(
            PostStatus::Published->value,
            $scheduledPost->fresh()->post_status
        );

        // Assert the future post remains scheduled
        $this->assertEquals(
            PostStatus::Scheduled->value,
            $futurePost->fresh()->post_status
        );
    }
} 