// Import IMask for phone masking
import IMask from 'imask';

// Initialize phone input functionality for lead form
export function initLeadFormPhoneInput() {
    const phoneInput = document.querySelector('.lead-wizard-form input.phone, .lead-wizard-form input[wire\\:model="phoneNumber"]');

    if (!phoneInput) {
        return null;
    }

    // Check if already initialized
    if (phoneInput.dataset.imaskInitialized) {
        return null;
    }

    // Mark as initialized
    phoneInput.dataset.imaskInitialized = 'true';

    // Initialize IMask with Canadian phone format (XXX) XXX-XXXX
    const maskInstance = IMask(phoneInput, {
        mask: '(000) 000-0000',
        lazy: false, // Show mask immediately
        placeholderChar: '_'
    });

    // Update Livewire model when mask value changes
    maskInstance.on('accept', () => {
        phoneInput.dispatchEvent(new Event('input', { bubbles: true }));
    });

    return maskInstance;
}

// Auto-initialize when module loads
if (typeof window !== 'undefined') {
    // Initialize on DOMContentLoaded
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initLeadFormPhoneInput);
    } else {
        initLeadFormPhoneInput();
    }

    // Re-initialize on Livewire updates
    document.addEventListener('livewire:initialized', () => {
        setTimeout(initLeadFormPhoneInput, 100);
    });

    // Re-initialize when lead form wizard steps change
    window.addEventListener('leadform-refresh', () => {
        setTimeout(initLeadFormPhoneInput, 100);
    });

    window.addEventListener('leadform-go-next', () => {
        setTimeout(initLeadFormPhoneInput, 100);
    });

    window.addEventListener('leadform-go-prev', () => {
        setTimeout(initLeadFormPhoneInput, 100);
    });
}
