// Import the library from node_modules

import intlTelInput from 'intl-tel-input';

// Initialize phone input functionality
export function initPhoneInput() {
    const input = document.querySelector("#phone");
    if (!input) return;

    const iti = intlTelInput(input, {
        initialCountry: "US",
        separateDialCode: true,
        autoHideDialCode: false,
        nationalMode: false,
        preferredCountries: ['us', 'gb', 'ca'],
        // (A) import utils module from a CDN
        loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),

    });

    // Optional: Add validation and formatting
    input.addEventListener('blur', () => {
        if (input.value.trim()) {
            if (iti.isValidNumber()) {
                input.classList.remove('error');
            } else {
                input.classList.add('error');
            }
        }
    });

    // Optional: Get the full number on form submission
    const form = input.closest('form');
    if (form) {
        form.addEventListener('submit', (e) => {
            const fullNumber = iti.getNumber();
            // You can set this to a hidden input if needed
            input.value = fullNumber;
        });
    }

    return iti;
}
