@extends('layouts.app')

@php
    $heading = $page->heading ?? __('Journal');
    $description = $page->content ? $page->contentText : __('Journal');
    $libraries = 'places,marker';
    $breadcrumbs = ['name' => 'journal'];
@endphp
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@section('content')
    <section Class="pt-8 pb-0 lg:py-8">
        <div class="max-w-[1310px] w-full mx-auto lg:px-4 px-0">
            <div>
                <div class="px-6 lg:px-0">
                    <x-frontend.common.breadcrumb-v2 :name="$breadcrumbs['name']" :params="$breadcrumbs['params'] ?? null" />
                    <div class="mt-3 w-full">
                        <h6>{{ $heading }}</h6>
                        <p class="mt-1 text-xs font-medium leading-4 text-mid-gray">
                            {{ $description }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="flex flex-col-reverse gap-6 px-6 py-6 lg:flex-row xl:gap-8 lg:gap-4 lg:mt-8 lg:px-0 lg:py-0" x-data="initBlogSearch()">
                <div class="lg:w-[318px] w-full">
                    <div class="bg-white lg:shadow-5xl lg:rounded-2xl lg:mb-8 filter-box transition-all duration-700 ease-in-out lg:static lg:h-auto fixed -left-full top-0 w-full h-full z-[100]">
                        <div :class="{ 'active': openFilter }" class="bg-white lg:shadow-5xl lg:rounded-2xl lg:mb-8 filter-box transition-all duration-700 ease-in-out lg:static lg:h-auto fixed -left-full top-0 w-full h-full z-[100]">
                            <div>
                                <div class="bg-white border-solid lg:border border-gray-1200 lg:shadow-5xl lg:rounded-2xl">
                                    <div class="flex justify-between items-center px-6 pt-6 pb-3 border-b border-solid lg:pb-0 lg:border-0 border-gray-1200">
                                        <h6 class="hidden lg:block">
                                            {{ __('Categories') }}
                                        </h6>
                                        <h6 class="flex gap-3 items-center lg:hidden">
                                            <x-icon-list-bars />
                                            {{ __('Filter') }}
                                        </h6>
                                        <div class="block lg:hidden">
                                            <a href="javascript:void(0)"
                                                @click="openFilter = false"
                                                class="flex justify-center items-center w-6 h-6 filter-close">
                                                <x-icon-close-icon />
                                            </a>
                                        </div>
                                    </div>
                                    <div class="lg:px-px lg:h-auto lg:overflow-y-auto h-[calc(100vh_-_154px)] overflow-y-scroll">
                                        <div class="px-6 py-8 lg:py-6">
                                            <form id="jorunalSearch"
                                                method="get"
                                                action="{{ route('journal.search') }}">
                                                <x-frontend.blog.sidebar.search-sidebar-v2 />
                                                 {{-- <div class="hidden lg:block">
                                                    <button type="button" class="hidden px-6 py-2 my-3 w-full cursor-pointer btn_search_posts primary-btn lg:block">{{ __('Search') }}</button>
                                                </div>
                                                <div class="block absolute bottom-0 left-0 p-6 w-full bg-white border-t border-solid lg:hidden border-gray-1200">
                                                    <button type="button" class="block px-6 py-2 my-3 w-full cursor-pointer btn_search_posts primary-btn lg:hidden">{{ __('Search') }}</button>
                                                </div>  --}}
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="lg:w-[calc(100%_-_350px)] w-full">
                    <div class="lg:max-w-[320px] max-w-full w-full mb-8">
                        <h4 class="text-sm text-black-1200 lg:block hidden font-medium leading-5 tracking-[-0.096px]">
                            {{ __('Search') }}
                        </h4>
                        <div class="flex gap-3 items-center w-full">
                            
                                <div class="relative flex-1 mt-1 w-full">
                                    <input type="text"
                                        id="querySearch"
                                        name="q"
                                        class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full pl-10"
                                        placeholder="Search by keyword, topic or author">
                                    <a href="javascript:void(0)" class="flex absolute left-3.5 top-1/2 justify-center items-center -translate-y-1/2">
                                        <x-icon-search-icon />
                                    </a>
                                </div>

                
                            <a href="javascript:void(0)"
                                @click="openFilter = !openFilter"
                                class="inline-flex justify-center items-center w-10 h-10 bg-white rounded-full border border-solid transition-all duration-500 ease-in-out cursor-pointer filter-btn border-gray-1200 shadow-3xl lg:hidden hover:bg-gray-1400 hover:border-gray-1400">
                                <x-icon-list-bars />
                            </a>
                        </div>
                    </div>
                    <div class="pb-8 border-b border-solid border-gray-1600">
                        <livewire:frontend.blog.widget.post-widget type="feautred-first" />
                    </div>
                    <div class="py-8 border-b border-solid border-gray-1600">
                        <livewire:frontend.blog.widget.post-widget :perPage="4" type="latest-first" />
                    </div>
                    <div class="pt-8">
                        <livewire:frontend.blog.widget.post-widget :perPage="4" type="most-popular" />
                    </div>

                </div>
            </div>
        </div>
    </section>
@endsection
