@extends('layouts.app')
@php
    $socialMedia = $post->author->profile->social_media_links ?? [];
    $author = $post->author;
@endphp
@section('content')
    <!----- TOP SEC ------>
    <section Class="pb-12">
        <div class="max-w-[1310px] w-full  mx-auto md:px-4 px-6">
            @if ($post->getMedia('featured_image')->isNotEmpty())
                <div class="py-8">
                    <img src="{{ $post->getFirstMediaUrl('featured_image', 'cover_image') }}"
                        alt="{{ $post->post_title }}"
                        class="w-full h-[300px] object-center object-cover rounded-3xl"
                        style="height: 300px"
                        loading="lazy" />
                </div>
            @endif
            <div class="{{ $post->getMedia('featured_image')->isEmpty() ? 'py-8' : '' }}">
                <div class="flex md:flex-row flex-col lg:gap-8 gap-4">
                    <div class="xl:w-[calc(100%_-_350px)] md:w-[calc(100%_-_250px)] w-full">
                        <div class="article-content-wrap">
                            <div class="article-content">
                                <h1>{{ $post->post_title }}</h1>
                                {!! tiptap_converter()->asHtml($post->post_description) !!}
                            </div>
                        </div>
                        <div class="md:my-8 my-6">
                        </div>
                    </div>
                    <div class="xl:max-w-[350px] md:max-w-[250px] w-full">
                        <div class="pb-4 hidden lg:block">
                            <x-frontend.sidebar.blog-author-sidebar :user="$author" :reviewsStats="$reviewsStats" />
                        </div>
                        <div>
                            <img src="{{ asset('/images/image_placeholder.webp') }}"
                                alt=""
                                class="w-full rounded-3xl mb-6"
                                 />
                            <img src="{{ asset('/images/image_placeholder.webp') }}"
                                alt=""
                                class="w-full rounded-3xl mb-6" />
                            <img src="{{ asset('/images/image_placeholder.webp') }}"
                                alt=""
                                class="w-full rounded-3xl mb-6" />
                            <img src="{{ asset('/images/image_placeholder.webp') }}"
                                alt=""
                                class="w-full rounded-3xl mb-6" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="bg-white">
        <div class="max-w-[1310px] w-full  mx-auto lg:px-4 px-6">
            @if ($post->tags->isNotEmpty())
                <div class="border-t border-solid border-gray-1200 py-12">
                    <h6>{{ __('Article Tags') }}</h6>
                    <ul class="mt-5 flex items-center gap-2 flex-wrap">
                        @foreach ($post->tags as $tag)
                            <li><a href="#" class="tags !border-0">{{ $tag->name }}</a></li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <div class="border-t border-solid border-gray-1200 py-12">
                <x-frontend.blog.related-posts :post="$post" />
            </div>
            <div class="block lg:hidden pb-4">
                <x-frontend.sidebar.blog-author-sidebar :user="$author" :reviewsStats="$reviewsStats" />
            </div>
        </div>
    </section>
    <!----- GALLERY  SEC ------>
@endsection
