@extends('layouts.app')
@php

    $heading = !empty($city->heading) ? $city->heading : __('ESP Marketplace City: Expert Advice, Industry Insights & Innovation in Groundwater');
    $description = !empty($city->description) ? $city->description : __('Vancouver Water Well and Pump contractors provide a broad scope of services, from water well drilling, well pump repair, well water testing, water treatment systems, water storage, and more.');
    $pageData = !empty($city->page_data) ? $city->page_data : [];
    $media = !empty($city->getMedia('featured_image')) ? $city->getMedia('featured_image') : [];
    if ($media) {
        $featuredImage = $city->getFirstMediaUrl('featured_image', 'large');
    }
@endphp
{{-- @push('seo')
    {!! seo($page ?? null) !!}
@endpush --}}
@section('content')
    <section class="pb-12">
        <div class="max-w-[1310px] w-full mx-auto lg:px-4 px-0">
            <div class="px-6 pt-8 pb-6 sm:py-8 lg:px-0">
                @if ($media->isNotEmpty())
                    <div>
                        <img src="{{ $featuredImage }}"
                            alt="{{ $city->heading }}"
                            class="w-full md:h-[220px] h-[160px] object-center object-cover rounded-xl"
                            loading="lazy" />
                    </div>
                @endif
                <div class="mt-3 md:mt-8">
                    <h4 class="text-black-1200 font-medium lg:text-[32px] md:text-2xl text-xl lg:leading-10 leading-7 tracking-[-0.08px] md:mb-6 mb-1">
                        {{ $heading }}
                    </h4>
                    @if (!empty($description))
                        <div class="article-content">
                            {!! $description !!}
                        </div>
                    @endif
                </div>
            </div>
            <livewire:frontend.member.listing.search-result.member-city-grid :citySlug="$city->slug" />
        </div>
    </section>

    @if (!empty($pageData['components']))
        @foreach ($pageData['components'] as $key => $component)
            <section Class="mt-12 mb-12 pt-12 pb-12 {{ $loop->even ? 'bg-gray-1400' : '' }}">
                <div class="max-w-[1276px] w-full  mx-auto md:px-4 px-6">
                    <livewire:dynamic-component :component="$component['data']['component']"
                        :pageData="$component['data']"
                        :key="'component-' . $key"
                        lazy />
                </div>
            </section>
        @endforeach
    @endif
@endsection
