@extends('layouts.app')
@php
    use Illuminate\Support\Str;
    use ProtoneMedia\LaravelFFMpeg\Support\FFMpeg;
    use Illuminate\Support\Facades\Storage;
    use Illuminate\Support\Number;
    // Get featured and gallery images
    $featuredImage = $classified->getMedia('featured_image')->first();
    $galleryImages = $classified->getMedia('gallery');

    // Create unified collection of all images (video first, featured, then gallery)
    $allImages = collect();
    $videoMedia = $classified->getMedia('video')->first();

    // Add video first if exists
    if ($videoMedia) {
        $allImages->push($videoMedia);
    }

    // Add featured image
    if ($featuredImage) {
        $allImages->push($featuredImage);
    }

    // Add gallery images
    $allImages = $allImages->concat($galleryImages);

    // Determine main image and check if we have any images
    $hasImages = $allImages->isNotEmpty();
    $mainImage = $allImages->first();

    $mainImageUrl = $mainImage ? $mainImage->getUrl('medium') : '';
    $thumbnailImages = $allImages->skip(1)->take(4);
    $videoFileUrl = $videoMedia ? $videoMedia->getFullUrl() : null;
    $totalImages = $allImages->count();
    $duration = 0;

    if ($videoMedia) {
        $duration = FFMpeg::fromDisk($videoMedia->disk)->open($videoMedia->getPathRelativeToRoot())->getDurationInSeconds();
        $duration = gmdate('i:s', $duration);
    }

    // Price calculations
    $price = $classified->price ? $classified->price : 0;
    $reducedPrice = $classified->discount_price ? $classified->discount_price : 0;
    $isReduced = $reducedPrice > 0 && $reducedPrice < $price;
    $priceFormatted = esp_currency_formated(price: $price);
    $reducedPriceFormatted = esp_currency_formated(price: $reducedPrice);
    $files = $classified->getMedia('maintenance_docs');
    $seller = $classified->user;
    $email = $seller?->email;
    $seller_profile = $seller?->profile;
    $phone = $seller_profile?->phone;

    $socialMedia = $seller_profile?->social_media_links ?? [];
    $website = $seller_profile?->website ?? null;
    // Decode and strip HTML tags
    $plainDescription = strip_tags(html_entity_decode($classified->description, ENT_QUOTES | ENT_HTML5, 'UTF-8'));
    // Limit for preview - approx 300 characters to simulate 3 lines
    $preview = Str::limit($plainDescription, 300);

@endphp
@section('content')
    <!----- PROJECT DETAIL ------>
    <div class="bg-gray-1800">
        <section class="md:pt-8 pt-6">
            <div class="max-w-[1312px] w-full mx-auto md:px-4">
                <div class="flex md:flex-row flex-col md:items-center items-start justify-between md:px-0 px-6 ">
                    <div class="relative md:w-auto w-full">
                        <h4 class="lg:text-2xl text-xl text-black-1200 font-medium md:leading-8 leading-6">
                            {{ $classified->title }}
                        </h4>
                        @if ($reducedPrice > 0)
                            <h5 class="text-black-1200 md:text-[32px] text-[28px] font-semibold md:mt-1 mt-3 md:leading-10 leading-8 md:tracking-[-0.16px] tracking-[-0.14px] flex items-center gap-2">
                                {{ $reducedPrice > 0 ? $reducedPriceFormatted : $priceFormatted }}
                                <span class="text-base font-medium leading-6 tracking-[-0.176px] text-gray-1500 line-through flex items-center">
                                    {{ $reducedPrice > 0 ? $priceFormatted : $reducedPriceFormatted }}
                                </span>
                            </h5>
                        @else
                            <h5 class="text-black-1200 md:text-[32px] text-[28px] font-semibold md:mt-1 mt-3 md:leading-10 leading-8 md:tracking-[-0.16px] tracking-[-0.14px] flex items-center gap-2">
                                {{ $priceFormatted }}
                            </h5>
                        @endif
                        @if ($classified->getClassifiedCondition() || $classified->getCategories(limit: 2)->isNotEmpty())
                            <ul class="flex items-center flex-wrap gap-2 mt-3">
                                <li>
                                    <a href="{{ route('classified.index', ['condition' => $classified->condition]) }}" class="tags active">
                                        {{ $classified->getClassifiedCondition() }}
                                    </a>
                                </li>
                                @if ($classified->getCategories(limit: 2)->isNotEmpty())
                                    @foreach ($classified->getCategories(limit: 2) as $category)
                                        <li>
                                            <a href="{{ route('classified.index', ['category' => $category->slug]) }}" class="tags">
                                                @include('components.frontend.classified.partials.classified-card.classified-category-title', ['category' => $category])
                                            </a></li>
                                    @endforeach
                                @endif
                            </ul>
                        @endif

                        @if ($classified->getAddress() || $classified->updated_at)
                            <ul class="flex items-center sm:gap-2 gap-1.5 mt-2">
                                @if ($classified->getAddress())
                                    <li class="text-mid-gray font-medium xl:text-sm sm:text-xs text-sm tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5">
                                        <span class="flex items-center justify-center w-5 h-5">
                                            <x-icon-location-outline-v2 />
                                        </span>
                                        {{ $classified->getAddress('area') }}
                                    </li>
                                @endif
                                @if ($classified->updated_at)
                                    <li class="text-mid-gray font-medium xl:text-sm sm:text-xs text-sm tracking-[-0.096px] flex items-center sm:gap-2 gap-1.5 {{ $classified->getAddress() ? 'md:border-l border-solid border-gray-1200 md:px-2' : '' }}">
                                        <span class="flex items-center justify-center w-5 h-5">
                                            <x-icon-calendar-icon3 />
                                        </span>
                                        {{ __('Updated:') }} {{ $classified->updated_at->diffForHumans() }}
                                    </li>
                                @endif
                            </ul>
                        @endif
                    </div>
                    <div class="lg:max-w-[389px] md:max-w-[320px] max-w-full w-full mt-0">
                        @if (!empty($socialMedia) || !empty($website))
                            <div class="mb-3">
                                <div class="flex  md:flex-row flex-col md:items-center items-start justify-center lg:gap-3 md:gap-1.5 gap-0 md:mt-0 mt-4">
                                    <p class="text-mid-gray lg:text-sm md:text-xs text-sm font-medium leading-5 tracking-[-0.084px]">
                                        {{ __('Share this classified:') }}
                                    </p>
                                    <ul class="flex lg:gap-2.5 md:gap-1.5 gap-2.5 md:mt-0 mt-3 items-center">
                                        @if (!empty($socialMedia['facebook']))
                                            <li>
                                                <a href="{{ $socialMedia['facebook'] }}"
                                                    target="_blank"
                                                    class="flex justify-center items-center lg:w-10 md:w-8 w-10 lg:h-10 md:h-8 h-10 rounded-full border border-solid border-gray-1200 bg-white">
                                                    <x-icon-facebook />
                                                </a>
                                            </li>
                                        @endif
                                        @if (!empty($socialMedia['twitter']))
                                            <li>
                                                <a href="{{ $socialMedia['twitter'] }}"
                                                    target="_blank"
                                                    class="flex justify-center items-center lg:w-10 md:w-8 w-10 lg:h-10 md:h-8 h-10 rounded-full border border-solid border-gray-1200 bg-white">
                                                    <x-icon-twitter-x />
                                                </a>
                                            </li>
                                        @endif
                                        @if (!empty($socialMedia['linkedin']))
                                            <li>
                                                <a href="{{ $socialMedia['linkedin'] }}"
                                                    target="_blank"
                                                    class="flex justify-center items-center lg:w-10 md:w-8 w-10 lg:h-10 md:h-8 h-10 rounded-full border border-solid border-gray-1200 bg-white">
                                                    <x-icon-linkedin />
                                                </a>
                                            </li>
                                        @endif
                                        @if (!empty($socialMedia['instagram']))
                                            <li>
                                                <a href="{{ $socialMedia['instagram'] }}"
                                                    target="_blank"
                                                    class="flex justify-center items-center lg:w-10 md:w-8 w-10 lg:h-10 md:h-8 h-10 rounded-full border border-solid border-gray-1200 bg-white">
                                                    <x-icon-instagram />
                                                </a>
                                            </li>
                                        @endif
                                        @if ($website)
                                            <li>
                                                <a href="{{ $website }}"
                                                    target="_blank"
                                                    class="flex justify-center items-center lg:w-10 md:w-8 w-10 lg:h-10 md:h-8 h-10 rounded-full border border-solid border-gray-1200 bg-white">
                                                    <x-icon-link />
                                                </a>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        @endif
                        @if (!empty($phone) || !empty($seller->email))
                            <div class="block">
                                <a href="tel:{{ $phone }}" class="text-white mb-3 text-sm font-medium leading-5 gap-3 tracking-[-0.084px] w-full h-[52px] rounded-full secondary-btn-gradient flex items-center justify-center shadow-32xl!">
                                    <x-icon-phone-icon /> {{ __('Call') }}
                                </a>
                                <a href="{{ route('member.show', ['slug' => $seller->slug]) }}" class="secondary-btn h-[52px]!">
                                    <svg width="10"
                                        height="10"
                                        viewBox="0 0 10 10"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M8.30806 3.01999L1.74476 9.58329L0.666504 8.50504L7.22905 1.94173H1.44507V0.416626H9.83317V8.80472H8.30806V3.01999Z" fill="#335CFF"></path>
                                    </svg>
                                    {{ __('View Seller Profile') }}
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
                <!----- PROJECT GALLERY ------>
                @if ($hasImages)
                    <div class="flex md:flex-row flex-col items-start gap-2.5 md:mt-8 mt-4 md:px-0 px-6">
                        <div class="md:w-[calc(100%-134px)] w-full">
                            <div class="relative">
                                <div class="swiper classifiedDetailSwiper">
                                    <div class="swiper-wrapper">
                                        @foreach ($allImages as $image)
                                            <div class="swiper-slide">
                                                @if ($videoMedia && $image->id === $videoMedia->id)
                                                    <img src="{{ $image->getUrl('large') }}"
                                                        loading="lazy"
                                                        alt="{{ $classified->title }}"
                                                        class="w-full md:h-[416px] h-[330px] object-center object-cover rounded-xl" />
                                                    {{-- @if ($duration)
                                                    <span class="absolute right-3 bottom-12 text-white text-[13px] font-bold leading-[130%] h-5 rounded-[40px] bg-blue-1500/[0.3] backdrop-blur-[10px] inline-flex items-center justify-center px-1.5 z-10">
                                                        {{ $duration }}
                                                    </span>
                                                @endif
                                                @if (!empty($videoMedia))
                                                    <a href="javascript:void(0)"
                                                        onclick="Livewire.dispatch('openModal', { component: 'frontend.classified.modal.classified-video-modal', arguments: { classified: {{ $classified->id }} }})"
                                                        class="flex md:bottom-50 bottom-40 left-1/2 absolute justify-center items-center w-10 h-10 rounded-full opacity-75 transition-all duration-500 ease-in-out -translate-x-1/2 -translate-y-1/2 group-hover:opacity-100 group-hover:visible bg-gray-1400 shadow-11xl">
                                                        <x-icon-play-fill />
                                                    </a>
                                                @endif --}}
                                                @else
                                                    <img src="{{ $image->getUrl('large') }}"
                                                        alt="{{ $classified->title }}"
                                                        class="w-full md:h-[416px] h-[330px] object-center object-cover rounded-xl" />
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                                <div class="swiper-pagination swiper-pagination23"></div>
                                <div class="gallerySwiper-btn">
                                    <div class="swiper-button-next after:hidden m-0! top-1/2! -translate-y-1/2! rounded-full w-8! h-8! flex items-center justify-center text-white">
                                        <x-icon-swiper-right-v1 class="text-white" />
                                    </div>
                                    <div class="swiper-button-prev after:hidden m-0! top-1/2! -translate-y-1/2! rounded-full w-8! h-8! flex items-center justify-center text-white">
                                        <x-icon-swiper-left-v1 class="text-white" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="md:block grid grid-cols-4 md:gap-0 gap-1 md:max-w-[134px] max-w-full w-full">
                            @for ($i = 0; $i < min(4, $totalImages); $i++)
                                @php $image = $allImages->get($i); @endphp
                                @if ($i < 3)
                                    <div class="md:mb-2.5 mb-0">
                                        {{-- <a href="#" class="flex items-center justify-center"> --}}
                                        <img src="{{ $image->getUrl('thumb') }}"
                                            alt="{{ $classified->title }}"
                                            class="w-full md:h-[96.5px] h-[76px] object-center object-cover rounded-xl"
                                            loading="lazy" />
                                        {{-- </a> --}}
                                    </div>
                                @else
                                    <div class="relative md:mb-2.5 mb-0">
                                        {{-- <a href="#" class="flex items-center justify-center"> --}}
                                        <img src="{{ $image->getUrl('thumb') }}"
                                            alt="{{ $classified->title }}"
                                            class="w-full md:h-[96.5px] h-[76px] object-center object-cover rounded-xl" />
                                        {{-- </a> --}}
                                        @if ($totalImages > 4)
                                            <div class="absolute left-0 top-0 flex items-center justify-center text-white font-semibold text-2xl leading-6 tracking-[-0.24px] rounded-xl bg-black-1200/[0.56] h-full w-full">
                                                +{{ $totalImages - 4 }}
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            @endfor
                        </div>
                    </div>
                @endif
            </div>
        </section>

        <!----- GALLERY  SEC ------>
        <section class="pt-8 md:pb-20 pb-8">
            <div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
                <div class="flex xl:flex-row flex-col items-start xl:gap-8 gap-0">
                    <div class="2xl:w-[calc(100%_-_447px)] xl:w-[calc(100%_-_370px)] w-full">
                        <div class="bg-white rounded-2xl shadow-33xl md:p-8 pt-4 pb-6 px-4">
                            <div>
                                <div x-data="{ expanded: false }" class="border-b border-solid border-gray-1200 md:pb-12 pb-6">
                                    <h6>{{ __('Description') }}</h6>
                                    <div class="article-content mt-3 text-base md:text-sm lg:text-base leading-6 text-mid-gray">
                                        <div x-show="!expanded" class="max-w-[800px] w-full line-clamp-3 lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray article-content">
                                            {!! tiptap_converter()->asHTML($classified->description) !!}
                                        </div>
                                        <div x-show="expanded" class="max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray article-content">
                                            {!! tiptap_converter()->asHTML($classified->description) !!}
                                        </div>
                                    </div>
                                    @if (strlen($classified->description) > 200)
                                        <a href="javascript:void(0)"
                                            @click="expanded = !expanded"
                                            class="readmore-btn mt-5">
                                            <span x-text="expanded ? 'Read less' : 'Read more'"></span>
                                            <svg :class="{ 'rotate-180': expanded }"
                                                class="transition-transform duration-300"
                                                width="11"
                                                height="7"
                                                viewBox="0 0 11 7"
                                                fill="currentColor"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M5.49999 4.54697L9.21249 0.834473L10.273 1.89497L5.49999 6.66797L0.72699 1.89497L1.78749 0.834473L5.49999 4.54697Z" fill="currentColor" />
                                            </svg>
                                        </a>
                                    @endif
                                </div>

                                @if ($classified->getKeyFeatures())
                                    <div class="border-b border-solid border-gray-1200 md:py-12 py-6">
                                        <div class="bg-black-1800 rounded-3xl md:px-6 md:py-[23px] p-4">
                                            <h5 class="text-white! font-medium md:text-xl text-base md:leading-7 leading-6">
                                                {{ __('Key Features') }}</h5>
                                            <div class="md:overflow-x-visible overflow-x-auto">
                                                <div class="md:w-auto w-[1325px] md:grid flex items-start md:grid-cols-3  grid-cols-1 md:gap-4 gap-2 md:mt-5 mt-4">
                                                    @foreach ($classified->getKeyFeatures() as $feature)
                                                        <div class="md:w-auto w-[140px] border border-solid border-black-1900 md:rounded-2xl rounded-lg bg-black-2000 md:p-4 p-3">
                                                            <p class="text-white/70 font-medium md:text-sm text-xs md:leading-5 leading-3.5 md:tracking-[-0.084px] tracking-[-0.072px]">
                                                                {{ $feature['key'] }}
                                                            </p>
                                                            <h4 class="text-white font-medium md:text-base text-sm md:leading-5 leading-4 md:tracking-[-0.176px] tracking-[-0.154px] mt-1.5">
                                                                {{ $feature['value'] }}
                                                            </h4>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                @if (!empty($classified->maintenance_detail))
                                    <div class="border-b border-solid border-gray-1200 md:py-12 py-6">
                                        <h6>{{ __('Maintenance History') }}</h6>
                                        <div x-data="{ expanded: false }">
                                            <div class="mt-3 text-mid-gray font-normal text-base leading-6"
                                                :class="{ 'line-clamp-3': !expanded }"
                                                @click="expanded = !expanded">
                                                {!! tiptap_converter()->asHTML($classified->maintenance_detail) !!}
                                                @if (strlen($classified->maintenance_detail) > 200)
                                                    <span x-show="!expanded" class="ml-1 text-blue-600 transition-transform duration-300 cursor-pointer">...</span>
                                                @endif
                                            </div>
                                        </div>
                                        @if ($files->count() > 0)
                                            <div class="grid lg:grid-cols-2 grid-cols-1 gap-4 mt-5">
                                                @foreach ($files->take(2) as $file)
                                                    <a href="{{ $file->getUrl() }}" target="_blank">
                                                        <div class="bg-gray-1400 rounded-2xl p-4 flex items-center gap-1.5">
                                                            <span class="flex items-center justify-center w-10 h-10">
                                                                <x-icon-file-download />
                                                            </span>
                                                            <div class="flex-1 flex items-center justify-between w-full">
                                                                <div class="flex-1 w-full">
                                                                    <span class="flex items-center font-medium text-sm tracking-[-0.084px] leading-5 text-mid-gray">PDF</span>
                                                                    <p class="flex items-center font-medium text-sm tracking-[-0.084px] leading-6 text-black-1200">
                                                                        {{ str()->headline($file->name) }}
                                                                    </p>
                                                                </div>
                                                                <div href="{{ $file->getUrl() }}"
                                                                    target="_blank"
                                                                    class="flex items-center justify-center w-9 h-9">
                                                                    <x-icon-download-icon />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </a>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                @endif

                                @if (!empty($phone) || !empty($email))
                                    <div class="border-b border-solid border-gray-1200 md:py-12 py-6">
                                        <h6>{{ __('Contact Seller') }}</h6>
                                        <div class="grid md:grid-cols-2 grid-cols-1 gap-4 mt-5">
                                            @if (!empty($phone))
                                                <div class="border border-solid border-gray-1200 rounded-2xl shadow-19xl p-4 flex items-center gap-1.5">
                                                    <span class="flex items-center justify-center w-10 h-10">
                                                        <x-icon-phone-outline />
                                                    </span>
                                                    <div class="flex-1 w-full">
                                                        <span class="flex items-center font-medium text-sm tracking-[-0.084px] leading-5 text-mid-gray">
                                                            {{ __('Call Seller') }}
                                                        </span>
                                                        <a href="tel:{{ $phone }}" class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">+1
                                                            {{ $phone }}</a>
                                                    </div>
                                                </div>
                                            @endif
                                            @if (!empty($email))
                                                <div class="border border-solid border-gray-1200 shadow-19xl rounded-2xl p-4 flex items-center gap-1.5">
                                                    <span class="flex items-center justify-center w-10 h-10">
                                                        <x-icon-email-icon />
                                                    </span>
                                                    <div class="flex-1 w-full">
                                                        <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">
                                                            {{ __('Email Seller') }}
                                                        </span>
                                                        <a href="javascript:void(0)"
                                                            onclick="Livewire.dispatch('openModal', { component: 'frontend.member.modal.member-contact-modal', arguments: { member: {{ $seller->id }} }})"
                                                            class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">
                                                            {{ esp_mask_email($email) }}
                                                        </a>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                                @if ($classified->getClassifiedTags()->isNotEmpty())
                                    <div class="border-b border-solid border-gray-1200 md:py-12 py-6">
                                        <h6>{{ __('Tags') }}</h6>
                                        <ul class="mt-5 flex items-center flex-wrap gap-2">
                                            @foreach ($classified->getClassifiedTags() as $tag)
                                                <li><a href="{{ route('classified.index', ['tag' => $tag->slug]) }}" class="tags-larg">{{ Str::title($tag->classified_tag_name) }}</a></li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                <x-frontend.classified.classified-detail.our-latest-classifieds :classified="$classified" />

                                <div class="md:pt-12 pt-6">
                                    <div class="md:mb-12 mb-6">
                                        <x-frontend.sidebar.widgets.ads-alert :type="__('Classified')" />
                                    </div>
                                    <x-frontend.member.profile.partials.profile-social-media :user="$seller"
                                        text="{{ __('Share this Ad') }}"
                                        mainClass="pt-0" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="2xl:max-w-[447px] xl:max-w-[370px] max-w-full w-full xl:sticky top-5 xl:mt-0 mt-8">
                        <x-frontend.sidebar.classified-author-sidebar :user="$seller" :reviewsStats="$reviewsStats" />
                    </div>
                </div>
            </div>
        </section>

        <div class="grid fixed right-0 bottom-0 left-0 z-50 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:hidden md:p-0 border-gray-1200">
            <a href="{{ route('member.show', ['slug' => $seller->slug]) }}" class="secondary-btn text-[#335CFF]">
                <x-icon-right-top-arrow />
                {{ __('View Profile') }}
            </a>
            <a href="tel:{{ $phone }}" class="mb-3 text-white primary-btn">
                <x-icon-phone-icon />
                {{ __('Call') }}
            </a>
        </div>
    </div>
@endsection
